/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import com.intellij.ml.llm.core.chat.ui.codeSnippet.CodeSnippetLanguage;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B;\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/CodePartEditorInfo;", "", "code", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "", "component", "Ljavax/swing/JComponent;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "file", "Lcom/intellij/testFramework/LightVirtualFile;", "languageDisplayProperty", "Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "<init>", "(Lcom/intellij/openapi/observable/properties/GraphProperty;Ljavax/swing/JComponent;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/testFramework/LightVirtualFile;Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;)V", "getCode", "()Lcom/intellij/openapi/observable/properties/GraphProperty;", "getComponent", "()Ljavax/swing/JComponent;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "value", "Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/CodeSnippetLanguage;", "language", "getLanguage", "()Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/CodeSnippetLanguage;", "setLanguage", "(Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/CodeSnippetLanguage;)V", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nCodePartEditorInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodePartEditorInfo.kt\ncom/intellij/ml/llm/core/chat/ui/chat/CodePartEditorInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,30:1\n1#2:31\n*E\n"})
public final class CodePartEditorInfo {
    @NotNull
    private final GraphProperty<String> code;
    @NotNull
    private final JComponent component;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final LightVirtualFile file;
    @NotNull
    private final ObservableMutableProperty<String> languageDisplayProperty;
    @NotNull
    private CodeSnippetLanguage language;

    public CodePartEditorInfo(@NotNull GraphProperty<String> code, @NotNull JComponent component, @NotNull EditorEx editor, @NotNull LightVirtualFile file, @NotNull ObservableMutableProperty<String> languageDisplayProperty) {
        Intrinsics.checkNotNullParameter(code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(languageDisplayProperty, (String)"languageDisplayProperty");
        this.code = code;
        this.component = component;
        this.editor = editor;
        this.file = file;
        this.languageDisplayProperty = languageDisplayProperty;
        this.language = CodeSnippetLanguage.Companion.initial();
    }

    @NotNull
    public final GraphProperty<String> getCode() {
        return this.code;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    @NotNull
    public final CodeSnippetLanguage getLanguage() {
        return this.language;
    }

    public final void setLanguage(@NotNull CodeSnippetLanguage value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)this.language, (Object)value)) {
            return;
        }
        this.file.setLanguage(value.getIntellijLanguage());
        LanguageFileType languageFileType = value.getIntellijLanguage().getAssociatedFileType();
        if (languageFileType != null) {
            LanguageFileType it = languageFileType;
            boolean bl = false;
            this.file.setFileType((FileType)it);
        }
        CharSequence charSequence = this.file.getExtension();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.file.rename((Object)this, this.file.getName() + "." + value.getFileExtension());
        }
        this.languageDisplayProperty.set((Object)value.getDisplayName());
        this.editor.setHighlighter(EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter(this.editor.getProject(), (VirtualFile)this.file));
        this.language = value;
    }
}

