/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context;

import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.chat.ui.chat.context.AIChatContextAttachmentFocusListener;
import com.intellij.ml.llm.core.chat.ui.chat.context.AIChatContextVm;
import com.intellij.ml.llm.core.chat.ui.chat.context.ContextAttachmentView;
import com.intellij.ml.llm.core.chat.ui.chat.context.ContextItemBorder;
import com.intellij.ml.llm.core.chat.ui.chat.context.popup.ContextPopupFactory;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0014\u0010\u0010\u001a\u00020\r*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/AddContextItemButton;", "Ljavax/swing/JPanel;", "model", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/AIChatContextVm;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/chat/context/AIChatContextVm;Lkotlinx/coroutines/CoroutineScope;)V", "contextItemBorder", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/ContextItemBorder;", "getPreferredSize", "Ljava/awt/Dimension;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "showAbove", "Lcom/intellij/openapi/ui/popup/JBPopup;", "component", "Ljava/awt/Component;", "intellij.ml.llm.chat"})
public final class AddContextItemButton
extends JPanel {
    @NotNull
    private final ContextItemBorder contextItemBorder;

    public AddContextItemButton(final @NotNull AIChatContextVm model, final @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(true);
        this.contextItemBorder = new ContextItemBorder(false, 1, null);
        Object object = new Border[]{this.contextItemBorder};
        this.setBorder(JBUI.Borders.compound((Border[])object));
        this.setMinimumSize(new Dimension(ContextAttachmentView.Companion.getCONTEXT_ITEM_WIDTH(), ContextAttachmentView.Companion.getCONTEXT_ITEM_HEIGHT()));
        this.setOpaque(false);
        object = this.contextItemBorder;
        this.addMouseListener(new AIChatContextAttachmentFocusListener((ContextItemBorder)object){

            @Override
            public void mouseClicked(MouseEvent e) {
                AIAssistantChatEventLogger.logAttachmentPlusButtonClicked();
                this.showAbove(ContextPopupFactory.INSTANCE.createPopup$intellij_ml_llm_chat(model, scope), this);
            }
        });
        this.getAccessibleContext().setAccessibleName(LLMBundle.message((String)"action.AIAssistant.ToolWindow.Chat.Message.AddAttachment.text", (Object[])new Object[0]));
    }

    @Override
    @Nullable
    public Dimension getPreferredSize() {
        return new Dimension(ContextAttachmentView.Companion.getCONTEXT_ITEM_WIDTH(), ContextAttachmentView.Companion.getCONTEXT_ITEM_HEIGHT());
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        int heightIntend = ContextAttachmentView.Companion.getCONTEXT_ITEM_HEIGHT() / 4;
        int widthIntend = heightIntend + (ContextAttachmentView.Companion.getCONTEXT_ITEM_WIDTH() - ContextAttachmentView.Companion.getCONTEXT_ITEM_HEIGHT()) / 2;
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setColor((Color)ContextAttachmentView.Companion.getIconColor());
        g2.setStroke(new BasicStroke(JBUIScale.scale((float)1.0f)));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        g2.drawLine(this.getWidth() / 2, heightIntend, this.getWidth() / 2, this.getHeight() - heightIntend);
        g2.drawLine(widthIntend, this.getHeight() / 2, this.getWidth() - widthIntend, this.getHeight() / 2);
        g2.dispose();
        super.paintComponent(g);
    }

    private final void showAbove(JBPopup $this$showAbove, Component component) {
        RelativePoint northWest = new RelativePoint(component, new Point());
        $this$showAbove.addListener(new JBPopupListener(northWest, $this$showAbove){
            final /* synthetic */ RelativePoint $northWest;
            final /* synthetic */ JBPopup $this_showAbove;
            {
                this.$northWest = $northWest;
                this.$this_showAbove = $receiver;
            }

            public void beforeShown(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                int gap = JBUI.scale((int)6);
                int anchorY = this.$northWest.getScreenPoint().y - gap;
                Point point = this.$this_showAbove.getLocationOnScreen();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
                Point popupLocation = point;
                popupLocation.y = anchorY - this.$this_showAbove.getSize().height;
                if (anchorY >= this.$this_showAbove.getSize().height + gap) {
                    popupLocation.y = anchorY - this.$this_showAbove.getSize().height;
                    this.$this_showAbove.setLocation(popupLocation);
                }
                this.$this_showAbove.removeListener((JBPopupListener)this);
            }
        });
        $this$showAbove.show(northWest);
    }
}

