/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.context.ContextEntityPrivacy;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.ProjectViewChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010-\u001a\u00020.H\u0096@\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001f\u0010\u0014\u001a\r\u0012\u0004\u0012\u00020\u00110\u0015\u00a2\u0006\u0002\b\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\u000f\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0015\u00a2\u0006\u0002\b\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0014\u0010\u001d\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u00064"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ProjectViewContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "project", "Lcom/intellij/openapi/project/Project;", "attachmentName", "Lcom/intellij/ml/llm/privacy/PSString;", "rawStructureText", "attachmentText", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;)V", "virtualFile", "Lcom/intellij/testFramework/LightVirtualFile;", "getVirtualFile", "()Lcom/intellij/testFramework/LightVirtualFile;", "virtualFile$delegate", "Lkotlin/Lazy;", "id", "", "getId", "()Ljava/lang/String;", "name", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "hint", "getHint", "tooltipText", "getTooltipText", "popupPresentationText", "getPopupPresentationText", "icon", "Ljavax/swing/Icon;", "getIcon", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "privacy", "Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getPrivacy", "()Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "text", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "intellij.ml.llm.chat"})
public final class ProjectViewContextAttachment
extends ContextAttachmentBase {
    @NotNull
    private final Project project;
    @NotNull
    private final PSString attachmentName;
    @NotNull
    private final PSString rawStructureText;
    @NotNull
    private final Lazy virtualFile$delegate;
    @NotNull
    private final String id;
    @NotNull
    private final ObservableProperty<String> name;
    @Nullable
    private final ObservableProperty<String> hint;
    @NotNull
    private final String tooltipText;
    @NotNull
    private final String popupPresentationText;
    @NotNull
    private final ObservableProperty<Icon> icon;
    @NotNull
    private final ContextEntitySource attachedBy;
    @NotNull
    private final ContextEntityPrivacy privacy;
    @NotNull
    private final PSString text;

    public ProjectViewContextAttachment(@NotNull Project project, @NotNull PSString attachmentName, @NotNull PSString rawStructureText, @Nullable PSString attachmentText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)attachmentName, (String)"attachmentName");
        Intrinsics.checkNotNullParameter((Object)rawStructureText, (String)"rawStructureText");
        this.project = project;
        this.attachmentName = attachmentName;
        this.rawStructureText = rawStructureText;
        this.virtualFile$delegate = LazyKt.lazy(() -> ProjectViewContextAttachment.virtualFile_delegate$lambda$0(this));
        this.id = (String)this.rawStructureText.unwrap();
        this.name = (ObservableProperty)new AtomicProperty((Object)this.attachmentName.unwrap());
        this.tooltipText = (String)this.attachmentName.unwrap();
        this.popupPresentationText = (String)this.attachmentName.unwrap();
        this.icon = (ObservableProperty)new AtomicProperty((Object)AllIcons.General.Tree);
        this.attachedBy = ContextAttachmentSource.User.INSTANCE;
        this.privacy = (ContextEntityPrivacy)ContextEntityPrivacy.Unrelated.INSTANCE;
        PSString pSString = attachmentText;
        if (pSString == null) {
            pSString = this.rawStructureText;
        }
        this.text = pSString;
    }

    public /* synthetic */ ProjectViewContextAttachment(Project project, PSString pSString, PSString pSString2, PSString pSString3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            pSString3 = null;
        }
        this(project, pSString, pSString2, pSString3);
    }

    private final LightVirtualFile getVirtualFile() {
        Lazy lazy = this.virtualFile$delegate;
        return (LightVirtualFile)lazy.getValue();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public ObservableProperty<String> getName() {
        return this.name;
    }

    @Override
    @Nullable
    public ObservableProperty<String> getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return this.tooltipText;
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @Override
    @NotNull
    public ObservableProperty<Icon> getIcon() {
        return this.icon;
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }

    @NotNull
    public ContextEntityPrivacy getPrivacy() {
        return this.privacy;
    }

    @Override
    @NotNull
    public PSString getText() {
        return this.text;
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return new ProjectViewChatAttachment(this.project, this.attachmentName, this.getText(), this.getAttachedBy(), this.rawStructureText);
    }

    @Override
    public void performAction(boolean isInMessage) {
        if (this.getVirtualFile().isValid()) {
            FileEditorManager.getInstance((Project)this.project).openFile((VirtualFile)this.getVirtualFile(), true);
        }
    }

    private static final LightVirtualFile virtualFile_delegate$lambda$0(ProjectViewContextAttachment this$0) {
        return new LightVirtualFile((String)this$0.attachmentName.unwrap(), (CharSequence)this$0.getText());
    }
}

