/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.context.ContextEntityPrivacy;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.TextChatAttachment;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010)\u001a\u00020*H\u0096@\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015R\u0014\u0010 \u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0015R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0019R\u0014\u0010%\u001a\u00020&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00060"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/TextContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "project", "Lcom/intellij/openapi/project/Project;", "title", "Lcom/intellij/ml/llm/privacy/PSString;", "text", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/context/ContextEntitySource;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTitle", "()Lcom/intellij/ml/llm/privacy/PSString;", "getText", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "id", "", "getId", "()Ljava/lang/String;", "name", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "getName", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "hint", "", "getHint", "()Ljava/lang/Void;", "tooltipText", "getTooltipText", "popupPresentationText", "getPopupPresentationText", "icon", "Ljavax/swing/Icon;", "getIcon", "privacy", "Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getPrivacy", "()Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nTextContextAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextContextAttachment.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/attachments/TextContextAttachment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class TextContextAttachment
extends ContextAttachmentBase {
    @NotNull
    private final Project project;
    @NotNull
    private final PSString title;
    @NotNull
    private final PSString text;
    @NotNull
    private final ContextEntitySource attachedBy;
    @NotNull
    private final String id;
    @NotNull
    private final AtomicProperty<String> name;
    @Nullable
    private final Void hint;
    @NotNull
    private final String tooltipText;
    @NotNull
    private final String popupPresentationText;
    @NotNull
    private final AtomicProperty<Icon> icon;
    @NotNull
    private final ContextEntityPrivacy privacy;

    public TextContextAttachment(@NotNull Project project, @NotNull PSString title2, @NotNull PSString text2, @NotNull ContextEntitySource attachedBy) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)attachedBy, (String)"attachedBy");
        this.project = project;
        this.title = title2;
        this.text = text2;
        this.attachedBy = attachedBy;
        this.id = (String)this.title.unwrap();
        this.name = new AtomicProperty((Object)this.getId());
        this.tooltipText = this.getId();
        this.popupPresentationText = "";
        this.icon = new AtomicProperty((Object)AllIcons.FileTypes.Custom);
        this.privacy = (ContextEntityPrivacy)ContextEntityPrivacy.Unrelated.INSTANCE;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final PSString getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public PSString getText() {
        return this.text;
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public AtomicProperty<String> getName() {
        return this.name;
    }

    @Nullable
    public Void getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return this.tooltipText;
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @NotNull
    public AtomicProperty<Icon> getIcon() {
        return this.icon;
    }

    @NotNull
    public ContextEntityPrivacy getPrivacy() {
        return this.privacy;
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return new TextChatAttachment(this.project, this.title, this.getText(), this.getAttachedBy());
    }

    @Override
    public void performAction(boolean isInMessage) {
        VirtualFile file;
        String fileName = this.getId() + ".txt";
        VirtualFile virtualFile2 = TextContextAttachment.performAction$getOpenedLocalChangesFile(this, fileName);
        if (virtualFile2 == null) {
            virtualFile2 = (VirtualFile)new LightVirtualFile(fileName, (CharSequence)this.getText());
        }
        if ((file = virtualFile2).isValid()) {
            FileEditorManager.getInstance((Project)this.project).openFile(file, true);
        }
    }

    private static final VirtualFile performAction$getOpenedLocalChangesFile(TextContextAttachment this$0, String fileName) {
        Object object;
        block1: {
            VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this$0.project).getOpenFiles();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
            for (Object object2 : (Object[])virtualFileArray) {
                VirtualFile it = (VirtualFile)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
                object = object2;
                break block1;
            }
            object = null;
        }
        return (VirtualFile)object;
    }
}

