/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.codeSnippet;

import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage;
import com.intellij.ml.llm.core.chat.ui.AIAssistantColors;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatMessageView;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.CodeViewerKt;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.EditorComponentWrapper;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.EditorFooterComponentWrapper;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.EditorFragment;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.EditorHeaderComponentWrapper;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.ExpandCollapseLabelWrapper;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.StickyComponentHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.impl.zoomIndicator.ZoomIndicatorManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000]\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001#\b\u0000\u0018\u00002\u00020\u0001:\u0001)B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010$\u00a8\u0006*"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/EditorFragment;", "Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/StickyComponentHolder;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "message", "Lcom/intellij/ml/llm/core/chat/messages/MarkdownChatMessage;", "disposable", "Lcom/intellij/openapi/Disposable;", "headerComponentWrapper", "Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/EditorHeaderComponentWrapper;", "footerComponentWrapper", "Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/EditorFooterComponentWrapper;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/ml/llm/core/chat/messages/MarkdownChatMessage;Lcom/intellij/openapi/Disposable;Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/EditorHeaderComponentWrapper;Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/EditorFooterComponentWrapper;)V", "getMessage", "()Lcom/intellij/ml/llm/core/chat/messages/MarkdownChatMessage;", "frameThickness", "", "editorLineThreshold", "value", "", "collapsed", "getCollapsed", "()Z", "setCollapsed", "(Z)V", "content", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "getContent", "()Lcom/intellij/util/ui/components/BorderLayoutPanel;", "stickyHeaderComponentWrapper", "stickyFooterComponentWrapper", "contentWithEditor", "com/intellij/ml/llm/core/chat/ui/codeSnippet/EditorFragment$contentWithEditor$1", "Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/EditorFragment$contentWithEditor$1;", "updateEditorBackgroundColor", "", "calculateContentWithEditorBorder", "Ljavax/swing/border/Border;", "CaretMoveScroller", "intellij.ml.llm.chat"})
public final class EditorFragment
extends StickyComponentHolder {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final MarkdownChatMessage message;
    @NotNull
    private final EditorHeaderComponentWrapper headerComponentWrapper;
    @NotNull
    private final EditorFooterComponentWrapper footerComponentWrapper;
    private final int frameThickness;
    private final int editorLineThreshold;
    @NotNull
    private final BorderLayoutPanel content;
    @NotNull
    private final EditorHeaderComponentWrapper stickyHeaderComponentWrapper;
    @NotNull
    private final EditorFooterComponentWrapper stickyFooterComponentWrapper;
    @NotNull
    private final contentWithEditor.1 contentWithEditor;

    public EditorFragment(@NotNull Project project, @NotNull EditorEx editor, @NotNull MarkdownChatMessage message, @NotNull Disposable disposable, @NotNull EditorHeaderComponentWrapper headerComponentWrapper, @NotNull EditorFooterComponentWrapper footerComponentWrapper) {
        EditorComponentWrapper<EditorHeaderComponentWrapper> it;
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)headerComponentWrapper, (String)"headerComponentWrapper");
        Intrinsics.checkNotNullParameter((Object)footerComponentWrapper, (String)"footerComponentWrapper");
        super(editor.getLineHeight());
        this.editor = editor;
        this.message = message;
        this.headerComponentWrapper = headerComponentWrapper;
        this.footerComponentWrapper = footerComponentWrapper;
        this.frameThickness = 1;
        this.editorLineThreshold = 6;
        BorderLayoutPanel borderLayoutPanel = object = new BorderLayoutPanel(this){
            final /* synthetic */ EditorFragment this$0;
            {
                this.this$0 = $receiver;
                this.setOpaque(false);
            }

            public void paint(Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                super.paint(g);
                CodeViewerKt.access$paintTheRoundBorderWithBackground(g, (JComponent)((Object)this), AIAssistantColors.INSTANCE.getMessageBorder(this.this$0.getMessage().getAuthor()), EditorFragment.access$getFrameThickness$p(this.this$0));
            }
        };
        EditorFragment editorFragment = this;
        boolean bl = false;
        EditorFooterComponentWrapper editorFooterComponentWrapper = this.footerComponentWrapper;
        ExpandCollapseLabelWrapper expandCollapseLabelWrapper = editorFooterComponentWrapper instanceof ExpandCollapseLabelWrapper ? (ExpandCollapseLabelWrapper)editorFooterComponentWrapper : null;
        if (expandCollapseLabelWrapper != null) {
            expandCollapseLabelWrapper.setContentRepaint$intellij_ml_llm_chat((Function0<Unit>)((Function0)() -> EditorFragment.content$lambda$2$lambda$1(this, (Object)it)));
        }
        editorFragment.content = object;
        object = this.headerComponentWrapper.createStickyVersion();
        it = (EditorHeaderComponentWrapper)object;
        editorFragment = this;
        boolean bl2 = false;
        it.getComponent().setVisible(false);
        it.getComponent().setBorder(JBUI.Borders.merge((Border)it.getComponent().getBorder(), (Border)JBUI.Borders.customLine((Color)AIAssistantColors.INSTANCE.getMessageBorder(this.message.getAuthor()), (int)this.frameThickness, (int)this.frameThickness, (int)0, (int)this.frameThickness), (boolean)true));
        editorFragment.stickyHeaderComponentWrapper = (EditorHeaderComponentWrapper)object;
        object = this.footerComponentWrapper.createStickyVersion();
        it = (EditorFooterComponentWrapper)object;
        editorFragment = this;
        boolean bl3 = false;
        it.getComponent().setVisible(false);
        it.getComponent().setBorder(JBUI.Borders.merge((Border)it.getComponent().getBorder(), (Border)JBUI.Borders.customLine((Color)AIAssistantColors.INSTANCE.getMessageBorder(this.message.getAuthor()), (int)0, (int)this.frameThickness, (int)this.frameThickness, (int)this.frameThickness), (boolean)true));
        editorFragment.stickyFooterComponentWrapper = (EditorFooterComponentWrapper)object;
        this.contentWithEditor = new BorderLayoutPanel(this){
            final /* synthetic */ EditorFragment this$0;
            {
                this.this$0 = $receiver;
            }

            public Dimension getPreferredSize() {
                boolean shouldCollapse;
                Dimension preferredSize = super.getPreferredSize();
                boolean bl = shouldCollapse = EditorFragment.access$getEditor$p(this.this$0).getDocument().getLineCount() > EditorFragment.access$getEditorLineThreshold$p(this.this$0);
                if (shouldCollapse && this.this$0.getCollapsed()) {
                    int n = EditorFragment.access$getEditor$p(this.this$0).getLineHeight() * EditorFragment.access$getEditorLineThreshold$p(this.this$0);
                    Insets insets = EditorFragment.access$getEditor$p(this.this$0).getScrollPane().getInsets();
                    Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
                    int n2 = n + UiSizeUtilKt.getHeight((Insets)insets);
                    Insets insets2 = this.getInsets();
                    Intrinsics.checkNotNullExpressionValue((Object)insets2, (String)"getInsets(...)");
                    int editorMaxHeight = n2 + UiSizeUtilKt.getHeight((Insets)insets2);
                    editorMaxHeight += EditorFragment.access$getFooterComponentWrapper$p((EditorFragment)this.this$0).getComponent().getPreferredSize().height;
                    return new Dimension(preferredSize.width, editorMaxHeight += EditorFragment.access$getHeaderComponentWrapper$p((EditorFragment)this.this$0).getComponent().getPreferredSize().height);
                }
                Intrinsics.checkNotNull((Object)preferredSize);
                return preferredSize;
            }
        };
        JComponent jComponent = this.editor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent editorComponent = jComponent;
        editorComponent.putClientProperty("EditorEx", this.editor);
        editorComponent.setBorder((Border)JBUI.Borders.empty());
        this.editor.putUserData(ZoomIndicatorManager.SUPPRESS_ZOOM_INDICATOR, (Object)true);
        this.editor.getScrollPane().setVerticalScrollBarPolicy(20);
        this.editor.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        this.contentWithEditor.setBorder(this.calculateContentWithEditorBorder());
        this.contentWithEditor.addToCenter(editorComponent);
        this.getContent().setBorder((Border)JBUI.Borders.empty((int)8, (int)0, (int)12, (int)0));
        this.getContent().addToTop((Component)this.headerComponentWrapper.getComponent());
        this.getContent().add((Component)((Object)this.contentWithEditor));
        this.getContent().addToBottom((Component)this.footerComponentWrapper.getComponent());
        CaretMoveScroller caretMoveScroller = new CaretMoveScroller();
        this.editor.addEditorMouseListener((EditorMouseListener)caretMoveScroller);
        this.editor.getCaretModel().addCaretListener((CaretListener)caretMoveScroller);
        JScrollPane jScrollPane = this.editor.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"getScrollPane(...)");
        CodeViewerKt.scrollToTopWhenNeeded(jScrollPane);
        this.updateEditorBackgroundColor();
        editorFooterComponentWrapper = this.footerComponentWrapper;
        ExpandCollapseLabelWrapper expandCollapseLabelWrapper2 = editorFooterComponentWrapper instanceof ExpandCollapseLabelWrapper ? (ExpandCollapseLabelWrapper)editorFooterComponentWrapper : null;
        if (expandCollapseLabelWrapper2 != null) {
            expandCollapseLabelWrapper2.updateExpandCollapseLabel();
        }
        editorFooterComponentWrapper = this.stickyFooterComponentWrapper;
        ExpandCollapseLabelWrapper expandCollapseLabelWrapper3 = editorFooterComponentWrapper instanceof ExpandCollapseLabelWrapper ? (ExpandCollapseLabelWrapper)editorFooterComponentWrapper : null;
        if (expandCollapseLabelWrapper3 != null) {
            expandCollapseLabelWrapper3.updateExpandCollapseLabel();
        }
        MessageBusConnection messageBusConnection = project.getMessageBus().connect(disposable);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> EditorFragment._init_$lambda$5(this, arg_0));
        this.setupStickyComponents(this.headerComponentWrapper.getComponent(), this.stickyHeaderComponentWrapper.getComponent(), this.footerComponentWrapper.getComponent(), this.stickyFooterComponentWrapper.getComponent(), (Function0<Boolean>)((Function0)() -> EditorFragment._init_$lambda$6(this)));
    }

    @NotNull
    public final MarkdownChatMessage getMessage() {
        return this.message;
    }

    public final boolean getCollapsed() {
        EditorFooterComponentWrapper editorFooterComponentWrapper = this.footerComponentWrapper;
        ExpandCollapseLabelWrapper expandCollapseLabelWrapper = editorFooterComponentWrapper instanceof ExpandCollapseLabelWrapper ? (ExpandCollapseLabelWrapper)editorFooterComponentWrapper : null;
        return expandCollapseLabelWrapper != null ? expandCollapseLabelWrapper.getCollapsed() : this.message.getAuthor() == ChatMessageAuthor.User;
    }

    public final void setCollapsed(boolean value) {
        block0: {
            EditorFooterComponentWrapper editorFooterComponentWrapper = this.footerComponentWrapper;
            ExpandCollapseLabelWrapper expandCollapseLabelWrapper = editorFooterComponentWrapper instanceof ExpandCollapseLabelWrapper ? (ExpandCollapseLabelWrapper)editorFooterComponentWrapper : null;
            if (expandCollapseLabelWrapper == null) break block0;
            EditorFooterComponentWrapper $this$_set_collapsed__u24lambda_u240 = editorFooterComponentWrapper = expandCollapseLabelWrapper;
            boolean bl = false;
            ((ExpandCollapseLabelWrapper)$this$_set_collapsed__u24lambda_u240).setCollapsed(value);
            ((ExpandCollapseLabelWrapper)$this$_set_collapsed__u24lambda_u240).updateExpandCollapseLabel();
        }
    }

    @NotNull
    protected BorderLayoutPanel getContent() {
        return this.content;
    }

    private final void updateEditorBackgroundColor() {
        Color color = this.editor.getBackgroundColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackgroundColor(...)");
        Color editorBackgroundColor = color;
        this.contentWithEditor.setBackground(editorBackgroundColor);
        this.headerComponentWrapper.updateBackgroundColor(editorBackgroundColor);
        this.stickyHeaderComponentWrapper.updateBackgroundColor(editorBackgroundColor);
        this.footerComponentWrapper.updateBackgroundColor(editorBackgroundColor);
        this.stickyFooterComponentWrapper.updateBackgroundColor(editorBackgroundColor);
    }

    private final Border calculateContentWithEditorBorder() {
        Border border = JBUI.Borders.merge((Border)((Border)JBUI.Borders.empty((int)0, (int)8)), (Border)JBUI.Borders.customLine((Color)AIAssistantColors.INSTANCE.getMessageBorder(this.message.getAuthor()), (int)(this.headerComponentWrapper.getComponent().isVisible() || this.stickyHeaderComponentWrapper.getComponent().isVisible() ? 0 : this.frameThickness), (int)this.frameThickness, (int)(this.footerComponentWrapper.getComponent().isVisible() || this.stickyFooterComponentWrapper.getComponent().isVisible() ? 0 : this.frameThickness), (int)this.frameThickness), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"merge(...)");
        return border;
    }

    private static final Unit content$lambda$2$lambda$1(EditorFragment this$0, content.1 $it) {
        this$0.contentWithEditor.setBorder(this$0.calculateContentWithEditorBorder());
        $it.repaint();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$5(EditorFragment this$0, EditorColorsScheme it) {
        this$0.updateEditorBackgroundColor();
    }

    private static final boolean _init_$lambda$6(EditorFragment this$0) {
        return this$0.footerComponentWrapper instanceof ExpandCollapseLabelWrapper ? !((ExpandCollapseLabelWrapper)this$0.footerComponentWrapper).getCollapsed() : true;
    }

    public static final /* synthetic */ int access$getFrameThickness$p(EditorFragment $this) {
        return $this.frameThickness;
    }

    public static final /* synthetic */ int access$getEditorLineThreshold$p(EditorFragment $this) {
        return $this.editorLineThreshold;
    }

    public static final /* synthetic */ EditorFooterComponentWrapper access$getFooterComponentWrapper$p(EditorFragment $this) {
        return $this.footerComponentWrapper;
    }

    public static final /* synthetic */ EditorHeaderComponentWrapper access$getHeaderComponentWrapper$p(EditorFragment $this) {
        return $this.headerComponentWrapper;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/EditorFragment$CaretMoveScroller;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/EditorFragment;)V", "caretMoveByMouse", "", "mousePressed", "", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mouseReleased", "caretPositionChanged", "Lcom/intellij/openapi/editor/event/CaretEvent;", "intellij.ml.llm.chat"})
    public final class CaretMoveScroller
    implements EditorMouseListener,
    CaretListener {
        private boolean caretMoveByMouse;

        public void mousePressed(@NotNull EditorMouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.caretMoveByMouse = true;
        }

        public void mouseReleased(@NotNull EditorMouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.caretMoveByMouse = false;
        }

        public void caretPositionChanged(@NotNull CaretEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (this.caretMoveByMouse) {
                return;
            }
            Caret caret = event.getCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCaret(...)");
            Caret caret2 = caret;
            if (!EditorFragment.this.getCollapsed() && Intrinsics.areEqual((Object)caret2, (Object)EditorFragment.this.editor.getCaretModel().getPrimaryCaret())) {
                AIAssistantChatMessageView message;
                Point point = EditorFragment.this.editor.visualPositionToXY(caret2.getVisualPosition());
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"visualPositionToXY(...)");
                Point caretPosition = point;
                Rectangle caretRectangleInEditor = new Rectangle(caretPosition, new Dimension(1, EditorFragment.this.editor.getLineHeight()));
                Rectangle editorVisibleRect = EditorFragment.this.editor.getContentComponent().getVisibleRect();
                if (!editorVisibleRect.contains(caretRectangleInEditor) && (message = (AIAssistantChatMessageView)UIUtil.getParentOfType(AIAssistantChatMessageView.class, (Component)EditorFragment.this.editor.getContentComponent())) != null) {
                    Rectangle caretRectangleInMessage = SwingUtilities.convertRectangle(EditorFragment.this.editor.getContentComponent(), caretRectangleInEditor, message);
                    Intrinsics.checkNotNull((Object)caretRectangleInMessage);
                    message.scrollRectToVisible(caretRectangleInMessage);
                }
            }
        }
    }
}

