/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.intentions.chat;

import ai.grazie.model.task.id.TaskName;
import com.intellij.DynamicBundle;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.LLMPromptsKt;
import com.intellij.ml.llm.core.chat.context.ChatContextItem;
import com.intellij.ml.llm.core.chat.session.ChatCreationContext;
import com.intellij.ml.llm.core.chat.session.ChatCreationContextWithSelection;
import com.intellij.ml.llm.core.chat.session.ChatOrigin;
import com.intellij.ml.llm.core.chat.session.ChatSourceAction;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.ChatIntentionTaskParameters;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.PrivacySafeTaskCall;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.SuggestRefactoringTaskCallBuilder;
import com.intellij.ml.llm.grazie.tasks.intentions.SuggestRefactoringTask;
import com.intellij.ml.llm.intentions.chat.AbstractChatIntention;
import com.intellij.ml.llm.intentions.chat.ChatIntentionTarget;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.openapi.RegistryKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J0\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0094@\u00a2\u0006\u0002\u0010\u0010J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010!\u001a\u00020\"H\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/intentions/chat/SuggestRefactoringChatIntention;", "Lcom/intellij/ml/llm/intentions/chat/AbstractChatIntention;", "<init>", "()V", "getText", "", "getFamilyName", "getChatCreationContext", "Lcom/intellij/ml/llm/core/chat/session/ChatCreationContext;", "extraItems", "", "Lcom/intellij/ml/llm/core/chat/context/ChatContextItem;", "sourceFile", "Lcom/intellij/psi/PsiFile;", "selectionRange", "Lcom/intellij/openapi/editor/RangeMarker;", "(Ljava/util/List;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/RangeMarker;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "hasAvailableLlmProfile", "getPrompt", "Lcom/intellij/ml/llm/intentions/chat/AbstractChatIntention$Prompt;", "intentionTarget", "Lcom/intellij/ml/llm/intentions/chat/ChatIntentionTarget;", "createTask", "Lcom/intellij/ml/llm/grazie/adapters/tasksFacade/PrivacySafeTaskCall;", "parameters", "Lcom/intellij/ml/llm/grazie/adapters/tasksFacade/ChatIntentionTaskParameters;", "getTaskName", "Lai/grazie/model/task/id/TaskName;", "intellij.ml.llm.chat"})
public final class SuggestRefactoringChatIntention
extends AbstractChatIntention {
    public SuggestRefactoringChatIntention() {
        super(null, 1, null);
    }

    @NotNull
    public String getText() {
        return LLMBundle.message((String)"intentions.chat.refactor.code.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return LLMBundle.message((String)"intention.category.small.on.selected.code", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    protected Object getChatCreationContext(@NotNull List<ChatContextItem> extraItems, @Nullable PsiFile sourceFile, @Nullable RangeMarker selectionRange, @NotNull Continuation<? super ChatCreationContext> $completion) {
        return new ChatCreationContextWithSelection(ChatOrigin.CustomIntention.INSTANCE, ChatSourceAction.REFACTOR_THIS, sourceFile, null, null, selectionRange, 24, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!super.isAvailable(project, editor, psiFile)) return false;
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) return false;
        boolean bl = psiFile2.isWritable();
        if (!bl) return false;
        if (!this.hasAvailableLlmProfile()) return false;
        return true;
    }

    private final boolean hasAvailableLlmProfile() {
        ChatSourceAction sourceAction = ChatSourceAction.REFACTOR_THIS;
        return AIAssistantUIUtil.INSTANCE.hasAvailableLlmProfileId(LLMPromptsKt.getChatPromptId((ChatSourceAction)sourceAction));
    }

    @Override
    @Deprecated(message="Use Task API instead", replaceWith=@ReplaceWith(expression="createTask(builder, intentionTarget)", imports={}))
    @NotNull
    public AbstractChatIntention.Prompt getPrompt(@NotNull Project project, @Nullable Editor editor, @NotNull ChatIntentionTarget intentionTarget) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)intentionTarget, (String)"intentionTarget");
        PSString displayPrompt = PSStringOperatorsKt.getMessagePrivacySafe((DynamicBundle)((DynamicBundle)LLMBundle.INSTANCE), (String)"intentions.chat.refactor.code.prompt.message").plus(AbstractChatIntention.Companion.getSELECTION_CODE_PROMPT_PART());
        PSString internalPrompt = RegistryKt.registryStringValuePrivacySafe((String)"llm.refactor.code.instruction").replace("\\n", (PrivacySafe)ConstantsKt.getNL()).trimIndent().plus(AbstractChatIntention.Companion.getSELECTION_CODE_PROMPT_PART());
        return new AbstractChatIntention.Prompt(displayPrompt, internalPrompt);
    }

    @Override
    @NotNull
    protected PrivacySafeTaskCall createTask(@NotNull ChatIntentionTaskParameters parameters, @NotNull ChatIntentionTarget intentionTarget) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)intentionTarget, (String)"intentionTarget");
        return new SuggestRefactoringTaskCallBuilder(parameters).build();
    }

    @Override
    @NotNull
    protected TaskName getTaskName() {
        return SuggestRefactoringTask.INSTANCE.getName();
    }
}

