/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.intentions.conversion;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/intentions/conversion/ResponseProcessor;", "", "<init>", "()V", "horizontalWhitespace", "", "", "whitespace", "extractCodeFromResponse", "", "response", "intellij.ml.llm.chat"})
public final class ResponseProcessor {
    @NotNull
    private final Set<Character> horizontalWhitespace;
    @NotNull
    private final Set<Character> whitespace;

    public ResponseProcessor() {
        Object[] objectArray = new Character[]{Character.valueOf(' '), Character.valueOf('\t')};
        this.horizontalWhitespace = SetsKt.setOf((Object[])objectArray);
        objectArray = new Character[]{Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\n')};
        this.whitespace = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public final String extractCodeFromResponse(@NotNull String response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        int startCodeBlock = StringsKt.indexOf$default((CharSequence)response, (String)"```", (int)0, (boolean)false, (int)6, null);
        if (startCodeBlock == -1) {
            return "";
        }
        int i = startCodeBlock += 3;
        while (i < response.length()) {
            while (this.horizontalWhitespace.contains(Character.valueOf(response.charAt(i)))) {
                if (++i != response.length()) continue;
                return "";
            }
            while (!this.whitespace.contains(Character.valueOf(response.charAt(i))) && response.charAt(i) != '`') {
                if (++i != response.length()) continue;
                return "";
            }
            boolean newLinePresent = false;
            while (this.whitespace.contains(Character.valueOf(response.charAt(i)))) {
                if (response.charAt(i) == '\n') {
                    newLinePresent = true;
                }
                if (++i != response.length()) continue;
                return "";
            }
            if (i + 2 < response.length() && response.charAt(i) == '`' && response.charAt(i + 1) == '`' && response.charAt(i + 2) == '`') {
                if ((i += 3) != response.length()) continue;
                return "";
            }
            if (newLinePresent) {
                startCodeBlock = i;
                break;
            }
            if ((i = StringsKt.indexOf$default((CharSequence)response, (String)"```", (int)i, (boolean)false, (int)4, null)) == -1) {
                return "";
            }
            i += 3;
        }
        while (i < response.length()) {
            if (response.charAt(i) == '\n') {
                int potentialEndCodeBlock = i;
                while (this.whitespace.contains(Character.valueOf(response.charAt(i)))) {
                    if (++i != response.length()) continue;
                    return "";
                }
                if (i + 2 < response.length() && response.charAt(i) == '`' && response.charAt(i + 1) == '`' && response.charAt(i + 2) == '`') {
                    String string = response.substring(startCodeBlock, potentialEndCodeBlock);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    return string;
                }
            }
            if (++i != response.length()) continue;
            return "";
        }
        return "";
    }
}

