/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector;

import com.intellij.lang.Language;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIInEditorDiffViewer;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.CodeGenerationDiffRenderer;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptFusCollector;
import com.intellij.ml.llm.inlinePromptDetector.UndoGeneration;
import com.intellij.ml.llm.inlinePromptDetector.diff.CGResultDiffGutterRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.impl.UndoRedoListener;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/AiUndoDiffDocumentUndoRedoListener;", "Lcom/intellij/openapi/command/impl/UndoRedoListener;", "<init>", "()V", "undoRedoStarted", "", "project", "Lcom/intellij/openapi/project/Project;", "undoManager", "Lcom/intellij/openapi/command/undo/UndoManager;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "isUndo", "", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.ml.llm.inlinePromptDetector"})
public final class AiUndoDiffDocumentUndoRedoListener
implements UndoRedoListener {
    public void undoRedoStarted(@Nullable Project project, @NotNull UndoManager undoManager, @Nullable FileEditor fileEditor, boolean isUndo, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)undoManager, (String)"undoManager");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        if (textEditor == null || (textEditor = textEditor.getEditor()) == null) {
            return;
        }
        TextEditor editor = textEditor;
        if (project != null) {
            Long l = (Long)editor.getDocument().getUserData(UndoGeneration.INSTANCE.getAI_GENERATION_MODIFICATION_STAMP_KEY());
            long l2 = editor.getDocument().getModificationStamp();
            if (l != null && l == l2 && isUndo) {
                VirtualFile virtualFile = editor.getVirtualFile();
                FileType fileType = virtualFile != null ? virtualFile.getFileType() : null;
                LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
                Language lang = languageFileType != null ? languageFileType.getLanguage() : null;
                InlinePromptFusCollector.INSTANCE.logUndoShown(lang);
                if (Registry.Companion.is("llm.action.generateCodeInlinePrompt.show.diff")) {
                    VirtualFile virtualFile2 = editor.getVirtualFile();
                    FileType fileType2 = virtualFile2 != null ? virtualFile2.getFileType() : null;
                    CGResultDiffGutterRenderer renderer = CGResultDiffGutterRenderer.Companion.create((Editor)editor, fileType2, null);
                    AIInEditorDiffViewer diffViewer = AIInEditorDiffViewer.Companion.create((Editor)editor, null, (CodeGenerationDiffRenderer)renderer);
                    UndoGeneration.INSTANCE.attachUndoDiffToEditor((Editor)editor, (Disposable)diffViewer);
                    diffViewer.beforeGenerationStarted();
                    Disposer.register((Disposable)disposable, () -> AiUndoDiffDocumentUndoRedoListener.undoRedoStarted$lambda$0(diffViewer, (Editor)editor));
                }
            }
        }
    }

    private static final void undoRedoStarted$lambda$0(AIInEditorDiffViewer $diffViewer, Editor $editor) {
        $diffViewer.rediff();
        $diffViewer.onGenerationFinished(null);
        $editor.getCaretModel().addCaretListener(new CaretListener($editor){
            final /* synthetic */ Editor $editor;
            {
                this.$editor = $editor;
            }

            public void caretAdded(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                UndoGeneration.INSTANCE.hideUndoDiffIfShown(this.$editor);
            }

            public void caretRemoved(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                UndoGeneration.INSTANCE.hideUndoDiffIfShown(this.$editor);
            }

            public void caretPositionChanged(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getOldPosition().line != event.getNewPosition().line) {
                    UndoGeneration.INSTANCE.hideUndoDiffIfShown(this.$editor);
                }
            }
        }, (Disposable)$diffViewer);
    }
}

