/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector;

import com.intellij.ml.llm.editor.AICaretAttributeKeys;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptEditorFilter;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptHighlightingPassFactoryKt;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptMarkupModelListenerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorHighlightingPredicate;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptMarkupModelListener;", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "Lcom/intellij/openapi/Disposable$Default;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "isPromptShown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "beforeRemoved", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "attributesChanged", "renderersChanged", "", "fontStyleChanged", "foregroundColorChanged", "addPredicate", "removePredicate", "intellij.ml.llm.inlinePromptDetector"})
@SourceDebugExtension(value={"SMAP\nInlinePromptMarkupModelListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlinePromptMarkupModelListener.kt\ncom/intellij/ml/llm/inlinePromptDetector/InlinePromptMarkupModelListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,146:1\n14#2:147\n14#2:148\n*S KotlinDebug\n*F\n+ 1 InlinePromptMarkupModelListener.kt\ncom/intellij/ml/llm/inlinePromptDetector/InlinePromptMarkupModelListener\n*L\n122#1:147\n136#1:148\n*E\n"})
final class InlinePromptMarkupModelListener
implements MarkupModelListener,
Disposable.Default {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final AtomicBoolean isPromptShown;

    public InlinePromptMarkupModelListener(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.isPromptShown = new AtomicBoolean();
    }

    public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        if (Intrinsics.areEqual((Object)highlighter.getTextAttributesKey(), (Object)AICaretAttributeKeys.INLINE_PROMPT_ATTRS)) {
            this.removePredicate(highlighter);
        }
    }

    public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleChanged, boolean foregroundColorChanged) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        if (Intrinsics.areEqual((Object)highlighter.getTextAttributesKey(), (Object)AICaretAttributeKeys.INLINE_PROMPT_ATTRS)) {
            if (highlighter.getEditorFilter().avaliableIn((Editor)this.editor)) {
                this.addPredicate(highlighter);
            } else {
                this.removePredicate(highlighter);
            }
        }
    }

    private final void addPredicate(RangeHighlighterEx highlighter) {
        if (this.isPromptShown.compareAndSet(false, true)) {
            ApplicationKt.getApplication().invokeLater(() -> InlinePromptMarkupModelListener.addPredicate$lambda$0(this, highlighter));
        }
    }

    private final void removePredicate(RangeHighlighterEx highlighter) {
        if (this.isPromptShown.compareAndSet(true, false)) {
            ApplicationKt.getApplication().invokeLater(() -> InlinePromptMarkupModelListener.removePredicate$lambda$2(this));
        }
    }

    private static final void addPredicate$lambda$0(InlinePromptMarkupModelListener this$0, RangeHighlighterEx $highlighter) {
        InlinePromptHighlightingPassFactoryKt.getInlinePromptLog().info("InlinePromptEditorFilter is added to editor=" + this$0.editor);
        EditorColorsScheme editorColorsScheme = this$0.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        InlinePromptEditorFilter filter = new InlinePromptEditorFilter($highlighter, editorColorsScheme);
        Disposer.register((Disposable)((Disposable)this$0), (Disposable)((Disposable)filter));
        InlinePromptEditorFilter prevFilter = (InlinePromptEditorFilter)this$0.editor.addHighlightingPredicate(InlinePromptMarkupModelListenerKt.access$getEDITOR_FILTER_KEY$p(), (EditorHighlightingPredicate)filter);
        if (prevFilter != null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(InlinePromptMarkupModelListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Inline prompt filter was already set for editor=" + this$0.editor);
            Disposer.dispose((Disposable)((Disposable)prevFilter));
        }
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)((Document)this$0.editor.getDocument()), (Project)this$0.editor.getProject(), (boolean)true);
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx markup = (MarkupModelEx)markupModel;
        markup.addMarkupModelListener((Disposable)filter, (MarkupModelListener)filter);
    }

    private static final void removePredicate$lambda$2(InlinePromptMarkupModelListener this$0) {
        InlinePromptHighlightingPassFactoryKt.getInlinePromptLog().info("InlinePromptEditorFilter is removed from editor=" + this$0.editor);
        InlinePromptEditorFilter inlinePromptEditorFilter = (InlinePromptEditorFilter)this$0.editor.removeHighlightingPredicate(InlinePromptMarkupModelListenerKt.access$getEDITOR_FILTER_KEY$p());
        if (inlinePromptEditorFilter == null) {
            InlinePromptMarkupModelListener $this$removePredicate_u24lambda_u242_u24lambda_u241 = this$0;
            boolean bl = false;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(InlinePromptMarkupModelListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Inline prompt filter was not set for editor=" + $this$removePredicate_u24lambda_u242_u24lambda_u241.editor);
            return;
        }
        InlinePromptEditorFilter filter = inlinePromptEditorFilter;
        Disposer.dispose((Disposable)((Disposable)filter));
    }
}

