/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector;

import com.intellij.lang.Language;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptByTextDetector;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\f\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/NonAsciiSymbolsDetector;", "Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptByTextDetector;", "<init>", "()V", "programmingLanguagesWithRarelyUsedAscii", "", "", "isInlinePrompt", "Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptByTextDetector$Decision;", "text", "editorLanguage", "Lcom/intellij/lang/Language;", "CharRangeGroup", "NaturalLanguageFamily", "intellij.ml.llm.inlinePromptDetector"})
public final class NonAsciiSymbolsDetector
implements InlinePromptByTextDetector {
    @NotNull
    public static final NonAsciiSymbolsDetector INSTANCE = new NonAsciiSymbolsDetector();
    @NotNull
    private static final Set<String> programmingLanguagesWithRarelyUsedAscii;

    private NonAsciiSymbolsDetector() {
    }

    @Override
    @NotNull
    public InlinePromptByTextDetector.Decision isInlinePrompt(@NotNull String text, @NotNull Language editorLanguage) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)editorLanguage, (String)"editorLanguage");
        String string = editorLanguage.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!programmingLanguagesWithRarelyUsedAscii.contains(string2)) {
            return InlinePromptByTextDetector.Decision.UNSURE;
        }
        NaturalLanguageFamily naturalLanguageFamily = NaturalLanguageFamily.Companion.of(text);
        return (naturalLanguageFamily == null ? -1 : WhenMappings.$EnumSwitchMapping$0[naturalLanguageFamily.ordinal()]) == -1 ? InlinePromptByTextDetector.Decision.UNSURE : InlinePromptByTextDetector.Decision.PROMPT;
    }

    static {
        Object[] objectArray = new String[]{"java", "c", "c++", "cpp", "go", "rust", "kotlin", "groovy"};
        programmingLanguagesWithRarelyUsedAscii = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0081\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/NonAsciiSymbolsDetector$CharRangeGroup;", "", "ranges", "", "Lkotlin/ranges/CharRange;", "<init>", "(Ljava/lang/String;ILjava/util/List;)V", "getRanges", "()Ljava/util/List;", "MANDARIN", "RUSSIAN", "UKRAINIAN", "BELARUSIAN", "GERMAN", "FRENCH", "SPANISH", "ANY_LATIN", "PUNCTUATION", "DIGITS", "MANDARIN_PUNCTUATION", "Companion", "intellij.ml.llm.inlinePromptDetector"})
    public static final class CharRangeGroup
    extends Enum<CharRangeGroup> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final List<CharRange> ranges;
        public static final /* enum */ CharRangeGroup MANDARIN;
        public static final /* enum */ CharRangeGroup RUSSIAN;
        public static final /* enum */ CharRangeGroup UKRAINIAN;
        public static final /* enum */ CharRangeGroup BELARUSIAN;
        public static final /* enum */ CharRangeGroup GERMAN;
        public static final /* enum */ CharRangeGroup FRENCH;
        public static final /* enum */ CharRangeGroup SPANISH;
        public static final /* enum */ CharRangeGroup ANY_LATIN;
        public static final /* enum */ CharRangeGroup PUNCTUATION;
        public static final /* enum */ CharRangeGroup DIGITS;
        public static final /* enum */ CharRangeGroup MANDARIN_PUNCTUATION;
        private static final /* synthetic */ CharRangeGroup[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CharRangeGroup(List<CharRange> ranges) {
            this.ranges = ranges;
        }

        @NotNull
        public final List<CharRange> getRanges() {
            return this.ranges;
        }

        public static CharRangeGroup[] values() {
            return (CharRangeGroup[])$VALUES.clone();
        }

        public static CharRangeGroup valueOf(String value) {
            return Enum.valueOf(CharRangeGroup.class, value);
        }

        @NotNull
        public static EnumEntries<CharRangeGroup> getEntries() {
            return $ENTRIES;
        }

        static {
            Object[] objectArray = new CharRange[]{new CharRange('\u4e00', '\u9fff'), new CharRange('\u3400', '\u4dbf')};
            MANDARIN = new CharRangeGroup(CollectionsKt.listOf((Object[])objectArray));
            objectArray = new CharRange[]{new CharRange('\u0400', '\u04ff'), new CharRange('\u0500', '\u052f')};
            RUSSIAN = new CharRangeGroup(CollectionsKt.listOf((Object[])objectArray));
            objectArray = new CharRange[]{new CharRange('\u0400', '\u04ff'), new CharRange('\u0490', '\u0491'), new CharRange('\u04e8', '\u04e9')};
            UKRAINIAN = new CharRangeGroup(CollectionsKt.listOf((Object[])objectArray));
            objectArray = new CharRange[]{new CharRange('\u0400', '\u04ff'), new CharRange('\u04ee', '\u04ef')};
            BELARUSIAN = new CharRangeGroup(CollectionsKt.listOf((Object[])objectArray));
            objectArray = new CharRange[]{new CharRange('A', 'Z'), new CharRange('a', 'z'), new CharRange('\u00c0', '\u00d6'), new CharRange('\u00d8', '\u00df')};
            GERMAN = new CharRangeGroup(CollectionsKt.listOf((Object[])objectArray));
            objectArray = new CharRange[]{new CharRange('A', 'Z'), new CharRange('a', 'z'), new CharRange('\u00c0', '\u00ff')};
            FRENCH = new CharRangeGroup(CollectionsKt.listOf((Object[])objectArray));
            objectArray = new CharRange[]{new CharRange('A', 'Z'), new CharRange('a', 'z'), new CharRange('\u00c0', '\u00ff')};
            SPANISH = new CharRangeGroup(CollectionsKt.listOf((Object[])objectArray));
            objectArray = new CharRange[]{new CharRange('A', 'Z'), new CharRange('a', 'z')};
            ANY_LATIN = new CharRangeGroup(CollectionsKt.listOf((Object[])objectArray));
            objectArray = new CharRange[]{new CharRange(' ', '/'), new CharRange(':', '@'), new CharRange('[', '`'), new CharRange('{', '~')};
            PUNCTUATION = new CharRangeGroup(CollectionsKt.listOf((Object[])objectArray));
            DIGITS = new CharRangeGroup(CollectionsKt.listOf((Object)new CharRange('0', '9')));
            objectArray = new CharRange[]{new CharRange('\u3002', '\u3002'), new CharRange('\uff0c', '\uff0c'), new CharRange('\u3001', '\u3001'), new CharRange('\uff1b', '\uff1b'), new CharRange('\uff1a', '\uff1a'), new CharRange('\u201c', '\u201d'), new CharRange('\u2018', '\u2019'), new CharRange('\u300a', '\u300b'), new CharRange('\u300c', '\u300d'), new CharRange('\u300e', '\u300f'), new CharRange('\uff08', '\uff09'), new CharRange('\uff01', '\uff1f')};
            MANDARIN_PUNCTUATION = new CharRangeGroup(CollectionsKt.listOf((Object[])objectArray));
            $VALUES = charRangeGroupArray = new CharRangeGroup[]{CharRangeGroup.MANDARIN, CharRangeGroup.RUSSIAN, CharRangeGroup.UKRAINIAN, CharRangeGroup.BELARUSIAN, CharRangeGroup.GERMAN, CharRangeGroup.FRENCH, CharRangeGroup.SPANISH, CharRangeGroup.ANY_LATIN, CharRangeGroup.PUNCTUATION, CharRangeGroup.DIGITS, CharRangeGroup.MANDARIN_PUNCTUATION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0004J\u001b\u0010\t\u001a\u00020\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0086\u0004J\u001b\u0010\t\u001a\u00020\u0005*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0086\u0004J\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0004J!\u0010\r\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u000b0\u000e2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0086\u0004J\u001b\u0010\u000f\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0004\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/NonAsciiSymbolsDetector$CharRangeGroup$Companion;", "", "<init>", "()V", "isFrom", "", "", "range", "Lcom/intellij/ml/llm/inlinePromptDetector/NonAsciiSymbolsDetector$CharRangeGroup;", "isFromAny", "", "", "ranges", "allAreFromAny", "", "allAreFrom", "intellij.ml.llm.inlinePromptDetector"})
        @SourceDebugExtension(value={"SMAP\nNonAsciiSymbolsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonAsciiSymbolsDetector.kt\ncom/intellij/ml/llm/inlinePromptDetector/NonAsciiSymbolsDetector$CharRangeGroup$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,204:1\n1761#2,3:205\n1761#2,3:208\n1740#2,3:215\n1740#2,3:218\n1069#3,2:211\n1069#3,2:213\n*S KotlinDebug\n*F\n+ 1 NonAsciiSymbolsDetector.kt\ncom/intellij/ml/llm/inlinePromptDetector/NonAsciiSymbolsDetector$CharRangeGroup$Companion\n*L\n79#1:205,3\n83#1:208,3\n95#1:215,3\n99#1:218,3\n87#1:211,2\n91#1:213,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean isFrom(char $this$isFrom, @NotNull CharRangeGroup range) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)((Object)range), (String)"range");
                    Iterable $this$any$iv = range.getRanges();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            CharRange it = (CharRange)element$iv;
                            boolean bl2 = false;
                            char c = it.getFirst();
                            boolean bl3 = $this$isFrom <= it.getLast() ? c <= $this$isFrom : false;
                            if (!bl3) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            public final boolean isFromAny(char $this$isFromAny, @NotNull Collection<? extends CharRangeGroup> range) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter(range, (String)"range");
                    Iterable $this$any$iv = range;
                    boolean $i$f$any = false;
                    if (((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            CharRangeGroup it = (CharRangeGroup)((Object)element$iv);
                            boolean bl2 = false;
                            if (!Companion.isFrom($this$isFromAny, it)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            public final boolean isFromAny(@NotNull String $this$isFromAny, @NotNull Collection<? extends CharRangeGroup> ranges) {
                boolean bl;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)$this$isFromAny, (String)"<this>");
                    Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
                    CharSequence $this$all$iv = $this$isFromAny;
                    boolean $i$f$all = false;
                    for (int i = 0; i < $this$all$iv.length(); ++i) {
                        char element$iv;
                        char it = element$iv = $this$all$iv.charAt(i);
                        boolean bl2 = false;
                        if (Companion.isFromAny(it, ranges)) continue;
                        bl = false;
                        break block1;
                    }
                    bl = true;
                }
                return bl;
            }

            public final boolean isFrom(@NotNull String $this$isFrom, @NotNull CharRangeGroup range) {
                boolean bl;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)$this$isFrom, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)((Object)range), (String)"range");
                    CharSequence $this$all$iv = $this$isFrom;
                    boolean $i$f$all = false;
                    for (int i = 0; i < $this$all$iv.length(); ++i) {
                        char element$iv;
                        char it = element$iv = $this$all$iv.charAt(i);
                        boolean bl2 = false;
                        if (Companion.isFrom(it, range)) continue;
                        bl = false;
                        break block1;
                    }
                    bl = true;
                }
                return bl;
            }

            public final boolean allAreFromAny(@NotNull List<String> $this$allAreFromAny, @NotNull Collection<? extends CharRangeGroup> range) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter($this$allAreFromAny, (String)"<this>");
                    Intrinsics.checkNotNullParameter(range, (String)"range");
                    Iterable $this$all$iv = $this$allAreFromAny;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String token = (String)element$iv;
                            boolean bl2 = false;
                            if (Companion.isFromAny(token, range)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }

            public final boolean allAreFrom(@NotNull List<String> $this$allAreFrom, @NotNull CharRangeGroup range) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter($this$allAreFrom, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)((Object)range), (String)"range");
                    Iterable $this$all$iv = $this$allAreFrom;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String token = (String)element$iv;
                            boolean bl2 = false;
                            if (Companion.isFrom(token, range)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013BG\b\u0002\u0012<\u0010\u0002\u001a8\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0004\b\u000b\u0010\fRG\u0010\u0002\u001a8\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/NonAsciiSymbolsDetector$NaturalLanguageFamily;", "", "isThisForSure", "Lkotlin/Function2;", "", "", "Lkotlin/ParameterName;", "name", "tokens", "text", "", "<init>", "(Ljava/lang/String;ILkotlin/jvm/functions/Function2;)V", "()Lkotlin/jvm/functions/Function2;", "Nonsense", "English", "LanguageWithCyrillicLetters", "Mandarin", "LanguageWithExtendedLatin", "Companion", "intellij.ml.llm.inlinePromptDetector"})
    @SourceDebugExtension(value={"SMAP\nNonAsciiSymbolsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonAsciiSymbolsDetector.kt\ncom/intellij/ml/llm/inlinePromptDetector/NonAsciiSymbolsDetector$NaturalLanguageFamily\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,204:1\n1788#2,4:205\n1104#3,3:209\n*S KotlinDebug\n*F\n+ 1 NonAsciiSymbolsDetector.kt\ncom/intellij/ml/llm/inlinePromptDetector/NonAsciiSymbolsDetector$NaturalLanguageFamily\n*L\n120#1:205,4\n143#1:209,3\n*E\n"})
    public static final class NaturalLanguageFamily
    extends Enum<NaturalLanguageFamily> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final Function2<List<String>, String, Boolean> isThisForSure;
        public static final /* enum */ NaturalLanguageFamily Nonsense;
        public static final /* enum */ NaturalLanguageFamily English;
        public static final /* enum */ NaturalLanguageFamily LanguageWithCyrillicLetters;
        public static final /* enum */ NaturalLanguageFamily Mandarin;
        public static final /* enum */ NaturalLanguageFamily LanguageWithExtendedLatin;
        private static final /* synthetic */ NaturalLanguageFamily[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private NaturalLanguageFamily(Function2<? super List<String>, ? super String, Boolean> isThisForSure) {
            this.isThisForSure = isThisForSure;
        }

        @NotNull
        public final Function2<List<String>, String, Boolean> isThisForSure() {
            return this.isThisForSure;
        }

        public static NaturalLanguageFamily[] values() {
            return (NaturalLanguageFamily[])$VALUES.clone();
        }

        public static NaturalLanguageFamily valueOf(String value) {
            return Enum.valueOf(NaturalLanguageFamily.class, value);
        }

        @NotNull
        public static EnumEntries<NaturalLanguageFamily> getEntries() {
            return $ENTRIES;
        }

        private static final boolean _init_$lambda$0(List tokens, String text) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            CharRangeGroup[] charRangeGroupArray = new CharRangeGroup[]{CharRangeGroup.PUNCTUATION, CharRangeGroup.DIGITS, CharRangeGroup.MANDARIN_PUNCTUATION};
            return CharRangeGroup.Companion.allAreFromAny(tokens, CollectionsKt.listOf((Object[])charRangeGroupArray));
        }

        private static final boolean _init_$lambda$1(List tokens, String text) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            CharRangeGroup[] charRangeGroupArray = new CharRangeGroup[]{CharRangeGroup.PUNCTUATION, CharRangeGroup.DIGITS, CharRangeGroup.ANY_LATIN};
            return CharRangeGroup.Companion.allAreFromAny(tokens, CollectionsKt.listOf((Object[])charRangeGroupArray));
        }

        private static final boolean _init_$lambda$3(List tokens, String text) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            if (tokens.size() < 2) {
                bl = false;
            } else {
                double onlyCyrillicRatio;
                int nTokensWithCyrillic;
                Iterable $this$count$iv = tokens;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    v1 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        CharRangeGroup[] charRangeGroupArray = new CharRangeGroup[]{CharRangeGroup.UKRAINIAN, CharRangeGroup.BELARUSIAN, CharRangeGroup.RUSSIAN, CharRangeGroup.PUNCTUATION, CharRangeGroup.DIGITS};
                        if (!CharRangeGroup.Companion.isFromAny(it, (Collection<? extends CharRangeGroup>)CollectionsKt.listOf((Object[])charRangeGroupArray)) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v1 = nTokensWithCyrillic = count$iv;
                }
                bl = nTokensWithCyrillic < 2 ? false : (onlyCyrillicRatio = (double)nTokensWithCyrillic / (double)tokens.size()) > 0.51;
            }
            return bl;
        }

        private static final boolean _init_$lambda$5(List tokens, String text) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            CharSequence charSequence = text;
            Regex regex = new Regex("\\s");
            String string = "";
            String textWithoutWhitespaces = regex.replace(charSequence, string);
            CharSequence $this$count$iv = textWithoutWhitespaces;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                CharRangeGroup[] charRangeGroupArray = new CharRangeGroup[]{CharRangeGroup.MANDARIN_PUNCTUATION, CharRangeGroup.MANDARIN};
                if (!CharRangeGroup.Companion.isFromAny(it, (Collection<? extends CharRangeGroup>)CollectionsKt.listOf((Object[])charRangeGroupArray))) continue;
                ++count$iv;
            }
            int mandarinChars = count$iv;
            int textLength = textWithoutWhitespaces.length();
            double ratio = textLength > 0 ? (double)mandarinChars / (double)textLength : 0.0;
            return textLength < 7 ? ratio > 0.7 : (textLength < 20 ? ratio > 0.4 : mandarinChars > 10);
        }

        private static final boolean _init_$lambda$6(List tokens, String text) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            if (tokens.size() < 2) {
                bl = false;
            } else {
                CharRangeGroup[] charRangeGroupArray = new CharRangeGroup[]{CharRangeGroup.PUNCTUATION, CharRangeGroup.DIGITS, CharRangeGroup.GERMAN, CharRangeGroup.FRENCH, CharRangeGroup.SPANISH};
                bl = CharRangeGroup.Companion.allAreFromAny(tokens, CollectionsKt.listOf((Object[])charRangeGroupArray));
            }
            return bl;
        }

        static {
            Nonsense = new NaturalLanguageFamily((Function2<? super List<String>, ? super String, Boolean>)((Function2)NaturalLanguageFamily::_init_$lambda$0));
            English = new NaturalLanguageFamily((Function2<? super List<String>, ? super String, Boolean>)((Function2)NaturalLanguageFamily::_init_$lambda$1));
            LanguageWithCyrillicLetters = new NaturalLanguageFamily((Function2<? super List<String>, ? super String, Boolean>)((Function2)NaturalLanguageFamily::_init_$lambda$3));
            Mandarin = new NaturalLanguageFamily((Function2<? super List<String>, ? super String, Boolean>)((Function2)NaturalLanguageFamily::_init_$lambda$5));
            LanguageWithExtendedLatin = new NaturalLanguageFamily((Function2<? super List<String>, ? super String, Boolean>)((Function2)NaturalLanguageFamily::_init_$lambda$6));
            $VALUES = naturalLanguageFamilyArray = new NaturalLanguageFamily[]{NaturalLanguageFamily.Nonsense, NaturalLanguageFamily.English, NaturalLanguageFamily.LanguageWithCyrillicLetters, NaturalLanguageFamily.Mandarin, NaturalLanguageFamily.LanguageWithExtendedLatin};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/NonAsciiSymbolsDetector$NaturalLanguageFamily$Companion;", "", "<init>", "()V", "of", "Lcom/intellij/ml/llm/inlinePromptDetector/NonAsciiSymbolsDetector$NaturalLanguageFamily;", "text", "", "intellij.ml.llm.inlinePromptDetector"})
        @SourceDebugExtension(value={"SMAP\nNonAsciiSymbolsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonAsciiSymbolsDetector.kt\ncom/intellij/ml/llm/inlinePromptDetector/NonAsciiSymbolsDetector$NaturalLanguageFamily$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,204:1\n1761#2,3:205\n827#2:208\n855#2,2:209\n774#2:211\n865#2,2:212\n*S KotlinDebug\n*F\n+ 1 NonAsciiSymbolsDetector.kt\ncom/intellij/ml/llm/inlinePromptDetector/NonAsciiSymbolsDetector$NaturalLanguageFamily$Companion\n*L\n182#1:205,3\n183#1:208\n183#1:209,2\n183#1:211\n183#1:212,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final NaturalLanguageFamily of(@NotNull String text) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                NaturalLanguageFamily it;
                void $this$filterNotTo$iv$iv;
                Object element$iv2;
                boolean bl;
                List notPrompt;
                List tokens;
                block8: {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    List list = StringUtil.getWordsIn((String)text);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getWordsIn(...)");
                    tokens = list;
                    if (tokens.isEmpty()) {
                        return null;
                    }
                    NaturalLanguageFamily[] naturalLanguageFamilyArray = new NaturalLanguageFamily[]{English, Nonsense};
                    notPrompt = CollectionsKt.listOf((Object[])naturalLanguageFamilyArray);
                    Iterable $this$any$iv = notPrompt;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            NaturalLanguageFamily it2 = (NaturalLanguageFamily)((Object)element$iv2);
                            boolean bl2 = false;
                            if (!((Boolean)it2.isThisForSure().invoke((Object)tokens, (Object)text)).booleanValue()) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return null;
                }
                Iterable $this$filterNot$iv = (Iterable)NaturalLanguageFamily.getEntries();
                boolean $i$f$filterNot = false;
                element$iv2 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    it = (NaturalLanguageFamily)((Object)element$iv$iv);
                    boolean bl3 = false;
                    if (notPrompt.contains((Object)it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$filterNotTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (NaturalLanguageFamily)((Object)element$iv$iv);
                    boolean bl4 = false;
                    if (!((Boolean)it.isThisForSure().invoke((Object)tokens, (Object)text)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List forSure = (List)destination$iv$iv;
                if (forSure.size() == 1) {
                    return (NaturalLanguageFamily)((Object)CollectionsKt.first((List)forSure));
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            $EnumSwitchMapping$0 = new int[NaturalLanguageFamily.values().length];
        }
    }
}

