/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector.jetenry;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.ml.llm.codeGeneration.AICodeGenerationFeatures;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptByTextDetector;
import com.intellij.ml.llm.inlinePromptDetector.jetenry.InlinePromptDetectionModelLoader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.ml.api.feature.FeatureDeclaration;
import com.jetbrains.ml.tools.model.ClassesProbabilities;
import com.jetbrains.ml.tools.model.MLModel;
import com.jetbrains.ml.tools.model.pipeline.ModelPipeline;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/jetenry/JetEnryPromptByTextDetector;", "Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptByTextDetector;", "<init>", "()V", "thresholdPrompt", "", "getThresholdPrompt", "()D", "thresholdCode", "getThresholdCode", "isInlinePrompt", "Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptByTextDetector$Decision;", "text", "", "editorLanguage", "Lcom/intellij/lang/Language;", "Features", "intellij.ml.llm.inlinePromptDetector"})
@SourceDebugExtension(value={"SMAP\nJetEnryPromptByTextDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetEnryPromptByTextDetector.kt\ncom/intellij/ml/llm/inlinePromptDetector/jetenry/JetEnryPromptByTextDetector\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,41:1\n40#2,3:42\n*S KotlinDebug\n*F\n+ 1 JetEnryPromptByTextDetector.kt\ncom/intellij/ml/llm/inlinePromptDetector/jetenry/JetEnryPromptByTextDetector\n*L\n27#1:42,3\n*E\n"})
public final class JetEnryPromptByTextDetector
implements InlinePromptByTextDetector {
    @NotNull
    public static final JetEnryPromptByTextDetector INSTANCE = new JetEnryPromptByTextDetector();

    private JetEnryPromptByTextDetector() {
    }

    private final double getThresholdPrompt() {
        return Registry.Companion.doubleValue("llm.code.generation.detector.threshold.prompt");
    }

    private final double getThresholdCode() {
        return Registry.Companion.doubleValue("llm.code.generation.detector.threshold.code");
    }

    @Override
    @NotNull
    public InlinePromptByTextDetector.Decision isInlinePrompt(@NotNull String text, @NotNull Language editorLanguage) {
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)editorLanguage, (String)"editorLanguage");
                if (!AICodeGenerationFeatures.INSTANCE.isMLInlinePromptDetectionEnabled(editorLanguage)) {
                    return InlinePromptByTextDetector.Decision.UNSURE;
                }
                boolean $i$f$service = false;
                Class<InlinePromptDetectionModelLoader> serviceClass$iv = InlinePromptDetectionModelLoader.class;
                Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object2 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                object = ((InlinePromptDetectionModelLoader)object2).getModel();
                if (object == null) break block5;
                ModelPipeline<MLModel<ClassesProbabilities>, ClassesProbabilities> model = object;
                boolean bl = false;
                ClassesProbabilities predictions = (ClassesProbabilities)model.predict(CollectionsKt.listOf((Object)Features.INSTANCE.getINPUT_STRING().with(text)));
                double proba = ((Number)MapsKt.getValue(predictions.getProbabilities(), (Object)"text")).doubleValue();
                InlinePromptByTextDetector.Decision decision = proba < INSTANCE.getThresholdCode() ? InlinePromptByTextDetector.Decision.CODE : (proba > INSTANCE.getThresholdPrompt() ? InlinePromptByTextDetector.Decision.PROMPT : InlinePromptByTextDetector.Decision.UNSURE);
                object = decision;
                if (decision != null) break block6;
            }
            object = InlinePromptByTextDetector.Decision.UNSURE;
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/jetenry/JetEnryPromptByTextDetector$Features;", "", "<init>", "()V", "INPUT_STRING", "Lcom/jetbrains/ml/api/feature/FeatureDeclaration;", "", "getINPUT_STRING", "()Lcom/jetbrains/ml/api/feature/FeatureDeclaration;", "intellij.ml.llm.inlinePromptDetector"})
    private static final class Features {
        @NotNull
        public static final Features INSTANCE = new Features();
        @NotNull
        private static final FeatureDeclaration<String> INPUT_STRING = FeatureDeclaration.Companion.string$default(FeatureDeclaration.Companion, "input_string", null, null, 6, null);

        private Features() {
        }

        @NotNull
        public final FeatureDeclaration<String> getINPUT_STRING() {
            return INPUT_STRING;
        }
    }
}

