/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector.ui;

import com.intellij.ml.llm.editor.MagicWand;
import com.intellij.ml.llm.inlinePromptDetector.ui.MagicWandService;
import com.intellij.ml.llm.inlinePromptDetector.ui.PromptSearcher;
import com.intellij.ml.llm.util.CoroutineScopeKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/ui/MagicWandRusher;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "enchantAllExistingEditors", "enchantCreatedEditors", "enchantEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "subscribeCaretMovedInEditor", "subscribeHighlightingChanged", "onHighlighterChanged", "token", "", "searchPrompt", "caretPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "isMainEditor", "", "intellij.ml.llm.inlinePromptDetector"})
@SourceDebugExtension(value={"SMAP\nMagicWandRusher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MagicWandRusher.kt\ncom/intellij/ml/llm/inlinePromptDetector/ui/MagicWandRusher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,140:1\n13472#2,2:141\n30#3,2:143\n30#3,2:145\n30#3,2:147\n*S KotlinDebug\n*F\n+ 1 MagicWandRusher.kt\ncom/intellij/ml/llm/inlinePromptDetector/ui/MagicWandRusher\n*L\n37#1:141,2\n49#1:143,2\n67#1:145,2\n74#1:147,2\n*E\n"})
final class MagicWandRusher
implements ProjectActivity {
    @NotNull
    private final String token;

    public MagicWandRusher() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.token = string;
    }

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        this.enchantAllExistingEditors(project);
        this.enchantCreatedEditors(project);
        return Unit.INSTANCE;
    }

    private final void enchantAllExistingEditors(Project project) {
        Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
        Object[] $this$forEach$iv = editorArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Editor editor = (Editor)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)editor);
            this.enchantEditor(project, editor);
        }
    }

    private final void enchantCreatedEditors(Project project) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<MagicWandService> serviceClass$iv = MagicWandService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(this, project){
            final /* synthetic */ MagicWandRusher this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void editorCreated(EditorFactoryEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Editor editor = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                MagicWandRusher.access$enchantEditor(this.this$0, this.$project, editor);
            }
        }, CoroutineScopeKt.asDisposable((CoroutineScope)((MagicWandService)object).getCs()));
    }

    private final void enchantEditor(Project project, Editor editor) {
        if (Intrinsics.areEqual((Object)project, (Object)editor.getProject())) {
            this.subscribeCaretMovedInEditor(project, editor);
            this.subscribeHighlightingChanged(project, editor);
        }
    }

    public final void subscribeCaretMovedInEditor(@NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (this.isMainEditor(project, editor)) {
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            CaretModel caretModel2 = caretModel;
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<MagicWandService> serviceClass$iv = MagicWandService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            caretModel2.addCaretListener(new CaretListener(this){
                final /* synthetic */ MagicWandRusher this$0;
                {
                    this.this$0 = $receiver;
                }

                public void caretPositionChanged(CaretEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Editor editor = event.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                    LogicalPosition logicalPosition = event.getNewPosition();
                    Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getNewPosition(...)");
                    MagicWandRusher.access$searchPrompt(this.this$0, editor, logicalPosition);
                }
            }, CoroutineScopeKt.newEditorDisposable((Editor)editor, (CoroutineScope)((MagicWandService)object).getCs()));
        }
    }

    public final void subscribeHighlightingChanged(@NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ApplicationManager.getApplication().invokeLater(() -> MagicWandRusher.subscribeHighlightingChanged$lambda$1(this, project, editor));
    }

    private final void onHighlighterChanged(Editor editor) {
        ApplicationManager.getApplication().invokeLater(() -> MagicWandRusher.onHighlighterChanged$lambda$2(editor, this), ModalityState.nonModal());
    }

    private final void searchPrompt(Editor editor, LogicalPosition caretPosition) {
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int line = caretPosition.line;
        int startOffset = document2.getLineStartOffset(line);
        int endOffset = document2.getLineEndOffset(line);
        PromptSearcher promptSearcher = new PromptSearcher();
        this.markupModel(editor).processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor)promptSearcher);
        MagicWand wand = new MagicWand(editor, this.token);
        if (promptSearcher.getFound()) {
            wand.start();
        } else {
            wand.stop();
        }
    }

    private final MarkupModelEx markupModel(Editor editor) {
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        MarkupModelEx markupModelEx = ((EditorEx)editor).getFilteredDocumentMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getFilteredDocumentMarkupModel(...)");
        return markupModelEx;
    }

    private final boolean isMainEditor(Project project, Editor editor) {
        return Intrinsics.areEqual((Object)project, (Object)editor.getProject()) && editor instanceof EditorEx && ((EditorEx)editor).getEditorKind() == EditorKind.MAIN_EDITOR && !project.isDisposed() && !((EditorEx)editor).isDisposed();
    }

    private static final void subscribeHighlightingChanged$lambda$1(MagicWandRusher this$0, Project $project, Editor $editor) {
        if (this$0.isMainEditor($project, $editor)) {
            ComponentManager $this$service$iv = (ComponentManager)$project;
            boolean $i$f$service = false;
            Class<MagicWandService> serviceClass$iv = MagicWandService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            Disposable disposable = CoroutineScopeKt.newEditorDisposable((Editor)$editor, (CoroutineScope)((MagicWandService)object).getCs());
            this$0.markupModel($editor).addMarkupModelListener(disposable, new MarkupModelListener(this$0, $editor){
                final /* synthetic */ MagicWandRusher this$0;
                final /* synthetic */ Editor $editor;
                {
                    this.this$0 = $receiver;
                    this.$editor = $editor;
                }

                public void afterRemoved(RangeHighlighterEx highlighter) {
                    Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                    MagicWandRusher.access$onHighlighterChanged(this.this$0, this.$editor);
                }

                public void afterAdded(RangeHighlighterEx highlighter) {
                    Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                    MagicWandRusher.access$onHighlighterChanged(this.this$0, this.$editor);
                }
            });
        }
    }

    private static final void onHighlighterChanged$lambda$2(Editor $editor, MagicWandRusher this$0) {
        if (!$editor.isDisposed()) {
            LogicalPosition logicalPosition = $editor.getCaretModel().getPrimaryCaret().getLogicalPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
            LogicalPosition caretPosition = logicalPosition;
            this$0.searchPrompt($editor, caretPosition);
        }
    }

    public static final /* synthetic */ void access$enchantEditor(MagicWandRusher $this, Project project, Editor editor) {
        $this.enchantEditor(project, editor);
    }

    public static final /* synthetic */ void access$searchPrompt(MagicWandRusher $this, Editor editor, LogicalPosition caretPosition) {
        $this.searchPrompt(editor, caretPosition);
    }

    public static final /* synthetic */ void access$onHighlighterChanged(MagicWandRusher $this, Editor editor) {
        $this.onHighlighterChanged(editor);
    }
}

