/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context;

import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.ml.llm.context.LLMQueryContext;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u0006H\u0016J\u001a\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0002J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J7\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/context/SimilarChunkContext;", "Lcom/intellij/ml/llm/context/LLMQueryContext;", "language", "Lcom/intellij/lang/Language;", "paths", "", "Lcom/intellij/ml/llm/privacy/PSString;", "chunks", "<init>", "(Lcom/intellij/lang/Language;Ljava/util/List;Ljava/util/List;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "getPaths", "()Ljava/util/List;", "getChunks", "toQuery", "commentCode", "code", "commentSymbol", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nSimilarChunksContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimilarChunksContext.kt\ncom/intellij/ml/llm/context/SimilarChunkContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n774#2:43\n865#2,2:44\n1869#2,2:46\n*S KotlinDebug\n*F\n+ 1 SimilarChunksContext.kt\ncom/intellij/ml/llm/context/SimilarChunkContext\n*L\n22#1:43\n22#1:44,2\n25#1:46,2\n*E\n"})
public final class SimilarChunkContext
implements LLMQueryContext {
    @NotNull
    private final Language language;
    @Nullable
    private final List<PSString> paths;
    @Nullable
    private final List<PSString> chunks;

    public SimilarChunkContext(@NotNull Language language, @Nullable List<? extends PSString> paths, @Nullable List<? extends PSString> chunks) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.language = language;
        this.paths = paths;
        this.chunks = chunks;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @Nullable
    public final List<PSString> getPaths() {
        return this.paths;
    }

    @Nullable
    public final List<PSString> getChunks() {
        return this.chunks;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PSString toQuery() {
        void $this$filterTo$iv$iv;
        PSString commentPrefix;
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(this.language);
        Commenter commenter2 = commenter;
        PSString pSString = commenter2 != null && (commenter2 = SharedExtensionsKtKt.getPrivacySafe((Commenter)commenter2)) != null ? commenter2.getLineCommentPrefix() : (commentPrefix = null);
        if (this.paths == null || this.chunks == null) {
            return ConstantsKt.getPrivacyConst((String)"");
        }
        Iterable $this$filter$iv = CollectionsKt.zip((Iterable)this.paths, (Iterable)this.chunks);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            PSString chunk = (PSString)pair.component2();
            boolean bl2 = chunk.unwrap().length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredPairs = (List)destination$iv$iv;
        ConcatenateBuilder queryBuilder = new ConcatenateBuilder(null, 1, null);
        Iterable $this$forEach$iv = filteredPairs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            PSString path = (PSString)pair.component1();
            PSString chunk = (PSString)pair.component2();
            PSString commentedCode = this.commentCode(chunk, commentPrefix);
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{commentPrefix, path};
            queryBuilder.append(ConstantsKt.getPrivacyConst((String)"%s Compare this snippet from %s:\n").format(pSStringConvertibleArray));
            queryBuilder.append(commentedCode);
            queryBuilder.append(ConstantsKt.getPrivacyConst((String)"\n"));
        }
        return queryBuilder.toPSString().trim();
    }

    private final PSString commentCode(PSString code, PSString commentSymbol) {
        if (commentSymbol == null) {
            return code;
        }
        String[] stringArray = new String[]{"\n"};
        return PSStringKt.joinToString$default((Iterable)PrivacySafe.split$default((PrivacySafe)((PrivacySafe)code), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)"\n")), null, null, (int)0, null, arg_0 -> SimilarChunkContext.commentCode$lambda$2(commentSymbol, arg_0), (int)30, null);
    }

    @NotNull
    public final Language component1() {
        return this.language;
    }

    @Nullable
    public final List<PSString> component2() {
        return this.paths;
    }

    @Nullable
    public final List<PSString> component3() {
        return this.chunks;
    }

    @NotNull
    public final SimilarChunkContext copy(@NotNull Language language, @Nullable List<? extends PSString> paths, @Nullable List<? extends PSString> chunks) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return new SimilarChunkContext(language, paths, chunks);
    }

    public static /* synthetic */ SimilarChunkContext copy$default(SimilarChunkContext similarChunkContext, Language language, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            language = similarChunkContext.language;
        }
        if ((n & 2) != 0) {
            list = similarChunkContext.paths;
        }
        if ((n & 4) != 0) {
            list2 = similarChunkContext.chunks;
        }
        return similarChunkContext.copy(language, list, list2);
    }

    @NotNull
    public String toString() {
        return "SimilarChunkContext(language=" + this.language + ", paths=" + this.paths + ", chunks=" + this.chunks + ")";
    }

    public int hashCode() {
        int result2 = this.language.hashCode();
        result2 = result2 * 31 + (this.paths == null ? 0 : ((Object)this.paths).hashCode());
        result2 = result2 * 31 + (this.chunks == null ? 0 : ((Object)this.chunks).hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimilarChunkContext)) {
            return false;
        }
        SimilarChunkContext similarChunkContext = (SimilarChunkContext)other;
        if (!Intrinsics.areEqual((Object)this.language, (Object)similarChunkContext.language)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paths, similarChunkContext.paths)) {
            return false;
        }
        return Intrinsics.areEqual(this.chunks, similarChunkContext.chunks);
    }

    private static final PrivacySafe commentCode$lambda$2(PSString $commentSymbol, PSString it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{$commentSymbol, it};
        return (PrivacySafe)ConstantsKt.getPrivacyConst((String)"%s %s").format(pSStringConvertibleArray);
    }
}

