/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.actions;

import com.intellij.ml.llm.activation.presentation.AiaScreen;
import com.intellij.ml.llm.activation.presentation.AiaScreenManager;
import com.intellij.ml.llm.activation.presentation.navigation.AiaNavDestination;
import com.intellij.ml.llm.activation.presentation.vm.AipLicenseMissingUiState;
import com.intellij.ml.llm.activation.presentation.vm.JbaUserLoginPhaseUi;
import com.intellij.ml.llm.activation.presentation.vm.JbaUserLoginUi;
import com.intellij.ml.llm.activation.presentation.vm.components.IdeLicenseAiFlagUiState;
import com.intellij.ml.llm.activation.presentation.vm.util.JourneyOutcomeKt;
import com.intellij.ml.llm.activation.state.manager.AiaActivationManager;
import com.intellij.ml.llm.activation.state.model.AiProJbaActivation;
import com.intellij.ml.llm.activation.state.model.AiaActivation;
import com.intellij.ml.llm.activation.state.model.Journey;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/core/actions/AIAssistantManageLicenseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nAIAssistantManageLicenseAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantManageLicenseAction.kt\ncom/intellij/ml/llm/core/actions/AIAssistantManageLicenseAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,75:1\n30#2,2:76\n30#2,2:78\n*S KotlinDebug\n*F\n+ 1 AIAssistantManageLicenseAction.kt\ncom/intellij/ml/llm/core/actions/AIAssistantManageLicenseAction\n*L\n28#1:76,2\n69#1:78,2\n*E\n"})
public final class AIAssistantManageLicenseAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        AiaActivation activation2 = AiaActivationManager.Companion.currentActivation();
        if (project == null || !(activation2 instanceof AiProJbaActivation) || JourneyOutcomeKt.isNullOrIncomplete((Journey)((Journey)((AiProJbaActivation)activation2).getJbaAuthStep()))) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<AiaScreenManager> serviceClass$iv = AiaScreenManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        AiaScreen screen = (AiaScreen)((AiaScreenManager)object).getActiveScreenFlow().getValue();
        Presentation presentation = e.getPresentation();
        AiaScreen aiaScreen = screen;
        if (Intrinsics.areEqual((Object)aiaScreen, (Object)AiaScreen.Initializing.INSTANCE)) {
            bl = false;
        } else if (aiaScreen instanceof AiaScreen.ActivationPending) {
            bl = false;
        } else if (aiaScreen instanceof AiaScreen.LinkPaymentMethod) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)aiaScreen, (Object)AiaScreen.AieBlocked.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)aiaScreen, (Object)AiaScreen.MainScreen.INSTANCE)) {
            bl = true;
        } else if (aiaScreen instanceof AiaScreen.JbaUserLogin) {
            JbaUserLoginPhaseUi uiState = ((JbaUserLoginUi)((AiaScreen.JbaUserLogin)screen).getViewModel().getUiState().getValue()).getPhase();
            IdeLicenseAiFlagUiState ideLicenseAiFlagViewModel = (IdeLicenseAiFlagUiState)((AiaScreen.JbaUserLogin)screen).getViewModel().getAiFlagViewModel().getUiState().getValue();
            bl = uiState instanceof JbaUserLoginPhaseUi.Failure || uiState instanceof JbaUserLoginPhaseUi.InternalError ? true : (ideLicenseAiFlagViewModel instanceof IdeLicenseAiFlagUiState.AiDisabled && !((IdeLicenseAiFlagUiState.AiDisabled)ideLicenseAiFlagViewModel).isRefreshing() ? false : false);
        } else if (aiaScreen instanceof AiaScreen.AipLicenseMissing) {
            AipLicenseMissingUiState uiState = (AipLicenseMissingUiState)((AiaScreen.AipLicenseMissing)screen).getViewModel().getUiState().getValue();
            bl = uiState.isManageLicenseContextMenuActionEnabled();
        } else if (aiaScreen instanceof AiaScreen.AipLicensePicker) {
            bl = false;
        } else if (aiaScreen instanceof AiaScreen.PreFlightCheck) {
            bl = true;
        } else if (aiaScreen instanceof AiaScreen.AipLicenseAgreement) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        presentation.setEnabled(bl);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<AiaScreenManager> serviceClass$iv = AiaScreenManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        AiaScreenManager screenManager = (AiaScreenManager)object;
        screenManager.navigateTo(AiaNavDestination.AiaNavAipLicensePicker);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

