/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.models;

import ai.grazie.model.llm.chat.v5.LLMChat;
import com.intellij.ml.llm.core.models.api.AiChatMediaMessage;
import com.intellij.ml.llm.core.models.api.AiChatMessage;
import com.intellij.ml.llm.core.models.api.AiaLlmChatRole;
import com.intellij.ml.llm.grazie.GrazieUtilsKt;
import com.intellij.ml.llm.grazie.adapters.LLMChatPrivacySafe;
import com.intellij.ml.llm.grazie.adapters.PrivacySafeLLMChatBuilder;
import com.intellij.ml.llm.grazie.adapters.PrivacySafeLLMChatBuilderKt;
import com.intellij.ml.llm.grazie.adapters.PrivacySafeLLMChatUserMedia;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\f\u001a\u00020\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u000e"}, d2={"customChat", "", "Lcom/intellij/ml/llm/core/models/api/AiChatMessage;", "contextPrompt", "Lcom/intellij/ml/llm/privacy/PSString;", "systemPrompt", "toGrazieChatPrivacySafe", "Lcom/intellij/ml/llm/grazie/adapters/LLMChatPrivacySafe;", "messages", "", "shouldAddMedia", "", "toGrazieChat", "Lai/grazie/model/llm/chat/v5/LLMChat;", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nChatRecipes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatRecipes.kt\ncom/intellij/ml/llm/core/models/ChatRecipesKt\n+ 2 LLMChat.kt\nai/grazie/model/llm/chat/v5/LLMChat$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n117#2:39\n1869#3,2:40\n1869#3:42\n1869#3,2:43\n1870#3:45\n*S KotlinDebug\n*F\n+ 1 ChatRecipes.kt\ncom/intellij/ml/llm/core/models/ChatRecipesKt\n*L\n34#1:39\n35#1:40,2\n20#1:42\n23#1:43,2\n20#1:45\n*E\n"})
public final class ChatRecipesKt {
    @NotNull
    public static final List<AiChatMessage> customChat(@NotNull PSString contextPrompt, @NotNull PSString systemPrompt) {
        Intrinsics.checkNotNullParameter((Object)contextPrompt, (String)"contextPrompt");
        Intrinsics.checkNotNullParameter((Object)systemPrompt, (String)"systemPrompt");
        Object[] objectArray = new AiChatMessage[]{new AiChatMessage(AiaLlmChatRole.System, systemPrompt, null, null, null, 28, null), new AiChatMessage(AiaLlmChatRole.User, contextPrompt, null, null, null, 28, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public static final LLMChatPrivacySafe toGrazieChatPrivacySafe(@NotNull Collection<AiChatMessage> messages, boolean shouldAddMedia) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        return PrivacySafeLLMChatBuilderKt.buildPrivacySafe(LLMChat.Companion, (Function1<? super PrivacySafeLLMChatBuilder, Unit>)((Function1)arg_0 -> ChatRecipesKt.toGrazieChatPrivacySafe$lambda$2(messages, shouldAddMedia, arg_0)));
    }

    public static /* synthetic */ LLMChatPrivacySafe toGrazieChatPrivacySafe$default(Collection collection, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ChatRecipesKt.toGrazieChatPrivacySafe(collection, bl);
    }

    @NotNull
    public static final LLMChat toGrazieChat(@NotNull List<AiChatMessage> messages) {
        LLMChat.Builder builder;
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        LLMChat.Companion this_$iv = LLMChat.Companion;
        boolean $i$f$build = false;
        LLMChat.Builder $this$toGrazieChat_u24lambda_u244 = builder = new LLMChat.Builder(null, 1, null);
        boolean bl = false;
        Iterable $this$forEach$iv = messages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AiChatMessage message = (AiChatMessage)element$iv;
            boolean bl2 = false;
            $this$toGrazieChat_u24lambda_u244.message(GrazieUtilsKt.toLLMChatMessage(message).unwrap());
        }
        return builder.build();
    }

    private static final Unit toGrazieChatPrivacySafe$lambda$2(Collection $messages, boolean $shouldAddMedia, PrivacySafeLLMChatBuilder $this$buildPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildPrivacySafe, (String)"$this$buildPrivacySafe");
        Iterable $this$forEach$iv = $messages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AiChatMessage message = (AiChatMessage)element$iv;
            boolean bl = false;
            if ($shouldAddMedia && !((Collection)message.getMedia()).isEmpty()) {
                Iterable $this$forEach$iv2 = message.getMedia();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    AiChatMediaMessage media = (AiChatMediaMessage)element$iv2;
                    boolean bl2 = false;
                    PrivacySafeLLMChatUserMedia psMedia = new PrivacySafeLLMChatUserMedia(ConstantsKt.getEMPTY(), media.getContentType(), media.getData());
                    $this$buildPrivacySafe.message(psMedia);
                }
            }
            $this$buildPrivacySafe.message(GrazieUtilsKt.toLLMChatMessage(message));
        }
        return Unit.INSTANCE;
    }
}

