/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.promptlog;

import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.NotificationsKt;
import com.intellij.ml.llm.core.promptlog.LogLLMChatService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/core/promptlog/OpenPromptLogAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "showNotification", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nOpenPromptLogAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenPromptLogAction.kt\ncom/intellij/ml/llm/core/promptlog/OpenPromptLogAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,47:1\n1#2:48\n14#3:49\n*S KotlinDebug\n*F\n+ 1 OpenPromptLogAction.kt\ncom/intellij/ml/llm/core/promptlog/OpenPromptLogAction\n*L\n18#1:49\n*E\n"})
public final class OpenPromptLogAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public OpenPromptLogAction() {
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        super(LLMBundle.messagePointer("action.PromptLog.OpenLog.brandedText", objectArray));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project != null) {
            VirtualFile logVFile;
            File logFile;
            LogLLMChatService service = LogLLMChatService.Companion.getInstance();
            File file = logFile = service.getLogFile();
            if (file != null) {
                File it = file;
                boolean bl = false;
                v1 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(it);
            } else {
                v1 = logVFile = null;
            }
            if (logVFile != null) {
                FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).openFile(logVFile, true);
                Intrinsics.checkNotNull((Object)fileEditorArray);
            } else {
                this.showNotification(project);
                logger.warn("There is no active prompt log");
            }
        }
    }

    private final void showNotification(Project project) {
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        Notification notification = NotificationsKt.createNotificationGroup().createNotification(LLMBundle.message("action.promptlogger.there.is.no.active.log", objectArray), NotificationType.WARNING);
        notification.notify(project);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(OpenPromptLogAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        OpenPromptLogAction.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/core/promptlog/OpenPromptLogAction$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

