/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.PluginInstallationCustomization;
import com.intellij.llmInstaller.api.AiPluginCoreConstants;
import com.intellij.llmInstaller.impl.AIAssistantInstallationCustomization;
import com.intellij.ml.llm.activation.data.model.AipLicense;
import com.intellij.ml.llm.activation.state.manager.AiaActivationManager;
import com.intellij.ml.llm.activation.state.model.AiEnterpriseActivation;
import com.intellij.ml.llm.activation.state.model.AiProJbaActivation;
import com.intellij.ml.llm.activation.state.model.AiaActivation;
import com.intellij.ml.llm.activation.state.model.Outcome;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.VerticalComponentGap;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\b\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/core/settings/LLMInstallationCustomization;", "Lcom/intellij/ide/plugins/newui/PluginInstallationCustomization;", "<init>", "()V", "baseCustomization", "Lcom/intellij/llmInstaller/impl/AIAssistantInstallationCustomization;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "getPluginId", "()Lcom/intellij/openapi/extensions/PluginId;", "createLicensePanel", "Ljavax/swing/JComponent;", "isMarketplace", "", "update", "beforeInstallOrUpdate", "", "customizeTagsCompatibility", "", "", "tags", "calcLicenceState", "Lcom/intellij/ml/llm/core/settings/LLMInstallationCustomization$LicenseState;", "LicenseState", "intellij.ml.llm.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLLMInstallationCustomization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMInstallationCustomization.kt\ncom/intellij/ml/llm/core/settings/LLMInstallationCustomization\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,111:1\n40#2,3:112\n*S KotlinDebug\n*F\n+ 1 LLMInstallationCustomization.kt\ncom/intellij/ml/llm/core/settings/LLMInstallationCustomization\n*L\n94#1:112,3\n*E\n"})
public final class LLMInstallationCustomization
implements PluginInstallationCustomization {
    @NotNull
    private final AIAssistantInstallationCustomization baseCustomization = new AIAssistantInstallationCustomization();

    @NotNull
    public PluginId getPluginId() {
        return AiPluginCoreConstants.INSTANCE.getLLM_PLUGIN_ID();
    }

    @Nullable
    public JComponent createLicensePanel(boolean isMarketplace, boolean update) {
        Object[] result2;
        Object[] objectArray;
        String string;
        if (isMarketplace) {
            return this.baseCustomization.createLicensePanel(isMarketplace, update);
        }
        LicenseState licenseState = this.calcLicenceState();
        if (!licenseState.isActivated() || licenseState.getExpirationDate() == null) {
            string = null;
        } else {
            String expirationText = PluginManagerConfigurable.DATE_FORMAT.format(Date.from(ConvertersKt.toJavaInstant((Instant)licenseState.getExpirationDate())));
            objectArray = new Object[]{expirationText};
            string = IdeBundle.message((String)"plugins.configurable.license.is.active.until.0", (Object[])objectArray);
        }
        String text = string;
        Object[] $this$createLicensePanel_u24lambda_u243 = objectArray = (result2 = text == null ? new JPanel() : (JPanel)BuilderKt.panel(arg_0 -> LLMInstallationCustomization.createLicensePanel$lambda$2(text, arg_0)));
        boolean bl = false;
        $this$createLicensePanel_u24lambda_u243.setOpaque(false);
        return (JComponent)objectArray;
    }

    public void beforeInstallOrUpdate(boolean update) {
        this.baseCustomization.beforeInstallOrUpdate(update);
    }

    @NotNull
    public final List<String> customizeTagsCompatibility(@NotNull List<String> tags) {
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        LicenseState licenseState = this.calcLicenceState();
        if (!licenseState.isActivated()) {
            return tags;
        }
        List result2 = CollectionsKt.toMutableList((Collection)tags);
        String purchasedTag = "Purchased";
        int freemiumIndex = result2.indexOf("Freemium");
        if (freemiumIndex < 0) {
            result2.add(0, purchasedTag);
        } else {
            result2.set(freemiumIndex, purchasedTag);
        }
        return result2;
    }

    private final LicenseState calcLicenceState() {
        AipLicense activeLicense;
        boolean $i$f$service = false;
        Class<AiaActivationManager> serviceClass$iv = AiaActivationManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        AiaActivation aiaActivation = ((AiaActivationManager)object).getActivation();
        LicenseState licenseState = Outcome.isIncomplete-impl((Object)aiaActivation.getOutcome-X8CKn68()) ? new LicenseState(false, null, 2, null) : (aiaActivation instanceof AiProJbaActivation ? ((activeLicense = ((AiProJbaActivation)aiaActivation).getActiveLicense()) == null ? new LicenseState(false, null, 2, null) : new LicenseState(true, activeLicense.getExpiresOn())) : (aiaActivation instanceof AiEnterpriseActivation ? new LicenseState(true, null, 2, null) : new LicenseState(false, null, 2, null)));
        return licenseState;
    }

    private static final Unit createLicensePanel$lambda$2$lambda$1$lambda$0(JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.putClientProperty(DslComponentProperty.VERTICAL_COMPONENT_GAP, VerticalComponentGap.NONE);
        return Unit.INSTANCE;
    }

    private static final Unit createLicensePanel$lambda$2$lambda$1(String $text, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)$text, (int)0, null, (int)6, null).applyToComponent(LLMInstallationCustomization::createLicensePanel$lambda$2$lambda$1$lambda$0);
        return Unit.INSTANCE;
    }

    private static final Unit createLicensePanel$lambda$2(String $text, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LLMInstallationCustomization.createLicensePanel$lambda$2$lambda$1($text, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/core/settings/LLMInstallationCustomization$LicenseState;", "", "isActivated", "", "expirationDate", "Lkotlinx/datetime/Instant;", "<init>", "(ZLkotlinx/datetime/Instant;)V", "()Z", "getExpirationDate", "()Lkotlinx/datetime/Instant;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.ml.llm.core"})
    private static final class LicenseState {
        private final boolean isActivated;
        @Nullable
        private final Instant expirationDate;

        public LicenseState(boolean isActivated, @Nullable Instant expirationDate) {
            this.isActivated = isActivated;
            this.expirationDate = expirationDate;
        }

        public /* synthetic */ LicenseState(boolean bl, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                instant = null;
            }
            this(bl, instant);
        }

        public final boolean isActivated() {
            return this.isActivated;
        }

        @Nullable
        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        public final boolean component1() {
            return this.isActivated;
        }

        @Nullable
        public final Instant component2() {
            return this.expirationDate;
        }

        @NotNull
        public final LicenseState copy(boolean isActivated, @Nullable Instant expirationDate) {
            return new LicenseState(isActivated, expirationDate);
        }

        public static /* synthetic */ LicenseState copy$default(LicenseState licenseState, boolean bl, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                bl = licenseState.isActivated;
            }
            if ((n & 2) != 0) {
                instant = licenseState.expirationDate;
            }
            return licenseState.copy(bl, instant);
        }

        @NotNull
        public String toString() {
            return "LicenseState(isActivated=" + this.isActivated + ", expirationDate=" + this.expirationDate + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.isActivated);
            result2 = result2 * 31 + (this.expirationDate == null ? 0 : this.expirationDate.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LicenseState)) {
                return false;
            }
            LicenseState licenseState = (LicenseState)other;
            if (this.isActivated != licenseState.isActivated) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.expirationDate, (Object)licenseState.expirationDate);
        }
    }
}

