/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.settings;

import ai.grazie.model.llm.profile.LLMProfileID;
import ai.grazie.model.llm.prompt.LLMPromptID;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.completion.IgnoredExtensionsFilter;
import com.intellij.ml.llm.core.LLMPromptsKt;
import com.intellij.ml.llm.core.chat.limits.UserMessageTrimmingThreshold;
import com.intellij.ml.llm.core.chat.session.ChatSessionMode;
import com.intellij.ml.llm.core.chat.session.ChatSourceAction;
import com.intellij.ml.llm.core.chat.ui.ChatModelKey;
import com.intellij.ml.llm.core.models.LlmInfoService;
import com.intellij.ml.llm.core.models.api.AiaLlmProfileID;
import com.intellij.ml.llm.core.models.api.AiaLlmProfileIDUtils;
import com.intellij.ml.llm.core.settings.LLMSettings;
import com.intellij.ml.llm.core.settings.LLMSettingsListener;
import com.intellij.ml.llm.grazie.GrazieUtilsKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.tokenizer.fus.TokenizerLimitLogger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.MutableBooleanProperty;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.APP})
@State(name="LLMSettings", storages={@Storage(value="llm.for.code.xml", roamingType=RoamingType.DISABLED, exportable=true)}, category=SettingsCategory.CODE)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\r\b\u0007\u0018\u0000 |2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001|B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bH\u0007J\b\u0010!\u001a\u00020\bH\u0007J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0#J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0#J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00180#J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120#J\b\u0010(\u001a\u00020\u0002H\u0016J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u0002H\u0016J\u0006\u0010+\u001a\u00020\bJ\u0006\u0010,\u001a\u00020\bJ\u000e\u0010-\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\u0006\u0010.\u001a\u00020\bJ\u000e\u0010/\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\u000e\u00100\u001a\u00020\u00102\u0006\u0010 \u001a\u000201J\u0006\u00102\u001a\u000203J\f\u00106\u001a\b\u0012\u0004\u0012\u00020\b0#J\u0006\u00107\u001a\u00020\bJ\u000e\u00108\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\u0006\u00109\u001a\u00020\bJ\u000e\u0010:\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\u0006\u0010;\u001a\u00020\bJ\u000e\u0010<\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\u0006\u0010=\u001a\u00020\bJ\u000e\u0010>\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\u0006\u0010?\u001a\u00020\bJ\u000e\u0010@\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\u0006\u0010A\u001a\u00020\bJ\u000e\u0010B\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\u0006\u0010C\u001a\u00020\bJ\u000e\u0010D\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\u0006\u0010E\u001a\u00020FJ\u000e\u0010G\u001a\u00020\u00102\u0006\u0010 \u001a\u00020FJ\u0006\u0010H\u001a\u00020\bJ\u000e\u0010I\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\u000e\u0010J\u001a\u00020\b2\u0006\u0010K\u001a\u00020LJ\u000e\u0010M\u001a\u00020\b2\u0006\u0010K\u001a\u00020LJ\u0015\u0010N\u001a\u00020\u00102\u0006\u0010K\u001a\u00020LH\u0000\u00a2\u0006\u0002\bOJ\u0015\u0010P\u001a\u00020\u00102\u0006\u0010K\u001a\u00020LH\u0000\u00a2\u0006\u0002\bQJ\u0006\u0010R\u001a\u00020\u0010J\u0006\u0010S\u001a\u00020\u0018J\u000e\u0010T\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0018J\b\u0010U\u001a\u0004\u0018\u00010VJ\u0010\u0010W\u001a\u00020\u00102\b\u0010 \u001a\u0004\u0018\u00010VJ\u000e\u0010Y\u001a\u00020\b2\u0006\u0010Z\u001a\u00020[J\u0016\u0010\\\u001a\u00020\b2\u0006\u0010]\u001a\u00020[2\u0006\u0010^\u001a\u00020_J\u000e\u0010`\u001a\u00020\u00102\u0006\u0010Z\u001a\u00020[J\u0010\u0010a\u001a\u0004\u0018\u00010V2\u0006\u0010Z\u001a\u00020[J\u0018\u0010b\u001a\u00020\u00102\b\u0010Z\u001a\u0004\u0018\u00010[2\u0006\u0010c\u001a\u00020VJ\u0016\u0010d\u001a\u00020\u00102\u0006\u0010Z\u001a\u00020[2\u0006\u0010e\u001a\u000201J\u000e\u0010f\u001a\u0002012\u0006\u0010Z\u001a\u00020[J\b\u0010g\u001a\u0004\u0018\u00010hJ\b\u0010i\u001a\u0004\u0018\u000101J\u000e\u0010j\u001a\u00020\u00102\u0006\u0010 \u001a\u00020hJ\u0010\u0010k\u001a\u00020\u00102\b\u0010 \u001a\u0004\u0018\u000101J\r\u0010l\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010mJ\u000e\u0010n\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\f\u0010o\u001a\b\u0012\u0004\u0012\u0002010pJ\u0014\u0010q\u001a\u00020\u00102\f\u0010 \u001a\b\u0012\u0004\u0012\u0002010pJ\u0006\u0010r\u001a\u00020\bJ\u000e\u0010s\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\u0006\u0010t\u001a\u00020\bJ\u000e\u0010u\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\u0006\u0010v\u001a\u00020\bJ\u000e\u0010w\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\u0006\u0010x\u001a\u00020\bJ\u000e\u0010y\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\u0006\u0010z\u001a\u00020\u0012J\u000e\u0010{\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0012R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\tR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000b\u001a\u0004\b\f\u0010\tR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000b\u001a\u0004\b\u0013\u0010\tR!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0015\u0010\tR!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000b\u001a\u0004\b\u0019\u0010\tR\u001b\u0010\u001b\u001a\u00020\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u000b\u001a\u0004\b\u001b\u0010\u001dR!\u00104\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u000b\u001a\u0004\b4\u0010\tR\u000e\u0010X\u001a\u000201X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006}"}, d2={"Lcom/intellij/ml/llm/core/settings/LLMSettingsManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ml/llm/core/settings/LLMSettings;", "<init>", "()V", "state", "isPasteConvertEnabledFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "isPasteConvertEnabledFlow$delegate", "Lkotlin/Lazy;", "isShelveTitleGenerateEnabledFlow", "isShelveTitleGenerateEnabledFlow$delegate", "chatPreferredLLMChangedFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "userMessageTrimmingThresholdFlow", "Lcom/intellij/ml/llm/core/chat/limits/UserMessageTrimmingThreshold;", "getUserMessageTrimmingThresholdFlow", "userMessageTrimmingThresholdFlow$delegate", "isChatNaturalLanguageSelectionEnabledFlow", "isChatNaturalLanguageSelectionEnabledFlow$delegate", "chatNaturalLanguageFlow", "Lcom/intellij/ml/llm/privacy/PSString;", "getChatNaturalLanguageFlow", "chatNaturalLanguageFlow$delegate", "isInlineCompletionEnabledState", "Lcom/intellij/openapi/observable/properties/MutableBooleanProperty;", "()Lcom/intellij/openapi/observable/properties/MutableBooleanProperty;", "isInlineCompletionEnabledState$delegate", "setInlineCompletionEnabled", "newValue", "isInlineCompletionEnabled", "getPasteConvertEnabledState", "Lkotlinx/coroutines/flow/StateFlow;", "getChatPreferredLLMClangedFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "getChatNaturalLanguageSelectionEnabledState", "getChatNaturalLanguageState", "getState", "loadState", "newState", "isSmartChatEnabled", "isUniversalCompletionEnabled", "setUniversalCompletionEnabled", "isDatabaseContextEnabled", "setDatabaseContextEnabled", "setIgnoredCompletionExtensions", "", "getIgnoredCompletionExtensions", "Lcom/intellij/ml/llm/completion/IgnoredExtensionsFilter;", "isNameSuggestionsEnabledFlow", "isNameSuggestionsEnabledFlow$delegate", "getNameSuggestionsEnabledState", "isNameSuggestionsEnabled", "setNameSuggestionsEnabled", "isPasteConvertEnabled", "setPasteConvertEnabled", "isShelveTitleGenerationEnabled", "setShelveTitleGenerationEnabled", "isGenerateCommitSummaryEnabled", "setGenerateCommitSummaryEnabled", "isUpdateGenerateCommitSummaryEnabled", "setUpdateGenerateCommitSummaryEnabled", "isFileGenerateCommitSummaryEnabled", "setFileGenerateCommitSummaryEnabled", "isSelectionGenerateCommitSummaryEnabled", "setSelectionGenerateCommitSummaryEnabled", "getToolwindowFontScale", "", "setToolwindowFontScale", "isChatNaturalLanguageSelectionEnabled", "setChatNaturalLanguageSelectionEnabled", "isExplicitlyExperimentalEnabled", "registry", "Lcom/intellij/openapi/util/registry/RegistryValue;", "isExplicitlyExperimentalDisabled", "setExplicitlyExperimentalEnabled", "setExplicitlyExperimentalEnabled$intellij_ml_llm_core", "setExplicitlyExperimentalDisabled", "setExplicitlyExperimentalDisabled$intellij_ml_llm_core", "clearExplicitlySetExperimental", "getChatNaturalLanguage", "setChatNaturalLanguage", "getChatPreferredLLM", "Lai/grazie/model/llm/profile/LLMProfileID;", "setChatPreferredLLM", "AUTO_MODEL_PLACEHOLDER", "isChatPreferredLLMAuto", "modelKey", "Lcom/intellij/ml/llm/core/chat/ui/ChatModelKey;", "isPreferableModelForMode", "mode", "profileIdToCheck", "Lcom/intellij/ml/llm/core/models/api/AiaLlmProfileID;", "setChatPreferredLLMAuto", "getChatPreferredModel", "setChatPreferredModelsPerMode", "value", "setChatForcedModelEventForMode", "eventVersionId", "getChatForcedModelEventForMode", "getChatMode", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionMode;", "getAgentId", "setChatMode", "setAgentId", "getCodebaseEnabledInChatMode", "()Ljava/lang/Boolean;", "setCodebaseEnabledInChatMode", "getTrustedDomains", "", "setTrustedDomains", "isCustomChatInstructionWasShown", "setCustomChatInstructionWasShown", "useSoftWrapsInChat", "setUseSoftWrapsInChat", "useLineNumbersInChat", "setUseLineNumbersInChat", "useIndentGuidesInChat", "setUseIndentGuidesInChat", "getUserMessageTrimmingThreshold", "setUserMessageTrimmingThreshold", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nLLMSettingsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMSettingsManager.kt\ncom/intellij/ml/llm/core/settings/LLMSettingsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,479:1\n774#2:480\n865#2,2:481\n774#2:483\n865#2,2:484\n1#3:486\n40#4,3:487\n*S KotlinDebug\n*F\n+ 1 LLMSettingsManager.kt\ncom/intellij/ml/llm/core/settings/LLMSettingsManager\n*L\n218#1:480\n218#1:481,2\n225#1:483\n225#1:484,2\n261#1:487,3\n*E\n"})
public final class LLMSettingsManager
implements PersistentStateComponent<LLMSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LLMSettings state = new LLMSettings();
    @NotNull
    private final Lazy isPasteConvertEnabledFlow$delegate = LazyKt.lazy(() -> LLMSettingsManager.isPasteConvertEnabledFlow_delegate$lambda$0(this));
    @NotNull
    private final Lazy isShelveTitleGenerateEnabledFlow$delegate = LazyKt.lazy(() -> LLMSettingsManager.isShelveTitleGenerateEnabledFlow_delegate$lambda$1(this));
    @NotNull
    private final MutableSharedFlow<Unit> chatPreferredLLMChangedFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
    @NotNull
    private final Lazy userMessageTrimmingThresholdFlow$delegate = LazyKt.lazy(() -> LLMSettingsManager.userMessageTrimmingThresholdFlow_delegate$lambda$2(this));
    @NotNull
    private final Lazy isChatNaturalLanguageSelectionEnabledFlow$delegate = LazyKt.lazy(() -> LLMSettingsManager.isChatNaturalLanguageSelectionEnabledFlow_delegate$lambda$3(this));
    @NotNull
    private final Lazy chatNaturalLanguageFlow$delegate = LazyKt.lazy(() -> LLMSettingsManager.chatNaturalLanguageFlow_delegate$lambda$4(this));
    @NotNull
    private final Lazy isInlineCompletionEnabledState$delegate = LazyKt.lazy(() -> LLMSettingsManager.isInlineCompletionEnabledState_delegate$lambda$7(this));
    @NotNull
    private final Lazy isNameSuggestionsEnabledFlow$delegate = LazyKt.lazy(() -> LLMSettingsManager.isNameSuggestionsEnabledFlow_delegate$lambda$8(this));
    @NotNull
    private final String AUTO_MODEL_PLACEHOLDER;
    public static final boolean SMART_CHAT_DEFAULT_SETTING = true;
    public static final boolean NAME_SUGGESTION_DEFAULT_SETTING = true;
    public static final boolean PASTE_CONVERT_DEFAULT_SETTING = false;
    public static final boolean SHELVE_TITLE_GENERATION_DEFAULT_SETTING = true;

    public LLMSettingsManager() {
        this.AUTO_MODEL_PLACEHOLDER = "auto_9f9c7f49";
    }

    private final MutableStateFlow<Boolean> isPasteConvertEnabledFlow() {
        Lazy lazy = this.isPasteConvertEnabledFlow$delegate;
        return (MutableStateFlow)lazy.getValue();
    }

    private final MutableStateFlow<Boolean> isShelveTitleGenerateEnabledFlow() {
        Lazy lazy = this.isShelveTitleGenerateEnabledFlow$delegate;
        return (MutableStateFlow)lazy.getValue();
    }

    private final MutableStateFlow<UserMessageTrimmingThreshold> getUserMessageTrimmingThresholdFlow() {
        Lazy lazy = this.userMessageTrimmingThresholdFlow$delegate;
        return (MutableStateFlow)lazy.getValue();
    }

    private final MutableStateFlow<Boolean> isChatNaturalLanguageSelectionEnabledFlow() {
        Lazy lazy = this.isChatNaturalLanguageSelectionEnabledFlow$delegate;
        return (MutableStateFlow)lazy.getValue();
    }

    private final MutableStateFlow<PSString> getChatNaturalLanguageFlow() {
        Lazy lazy = this.chatNaturalLanguageFlow$delegate;
        return (MutableStateFlow)lazy.getValue();
    }

    @NotNull
    public final MutableBooleanProperty isInlineCompletionEnabledState() {
        Lazy lazy = this.isInlineCompletionEnabledState$delegate;
        return (MutableBooleanProperty)lazy.getValue();
    }

    @TestOnly
    public final void setInlineCompletionEnabled(boolean newValue) {
        this.isInlineCompletionEnabledState().set((Object)newValue);
    }

    @TestOnly
    public final boolean isInlineCompletionEnabled() {
        return (Boolean)this.isInlineCompletionEnabledState().get();
    }

    @NotNull
    public final StateFlow<Boolean> getPasteConvertEnabledState() {
        return FlowKt.asStateFlow(this.isPasteConvertEnabledFlow());
    }

    @NotNull
    public final SharedFlow<Unit> getChatPreferredLLMClangedFlow() {
        return FlowKt.asSharedFlow(this.chatPreferredLLMChangedFlow);
    }

    @NotNull
    public final StateFlow<Boolean> getChatNaturalLanguageSelectionEnabledState() {
        return FlowKt.asStateFlow(this.isChatNaturalLanguageSelectionEnabledFlow());
    }

    @NotNull
    public final StateFlow<PSString> getChatNaturalLanguageState() {
        return FlowKt.asStateFlow(this.getChatNaturalLanguageFlow());
    }

    @NotNull
    public final StateFlow<UserMessageTrimmingThreshold> getUserMessageTrimmingThresholdFlow() {
        return FlowKt.asStateFlow(this.getUserMessageTrimmingThresholdFlow());
    }

    @NotNull
    public LLMSettings getState() {
        return this.state;
    }

    public void loadState(@NotNull LLMSettings newState) {
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        this.state = newState;
        Companion.fireSettingsChanged();
    }

    public final boolean isSmartChatEnabled() {
        return Registry.Companion.is("llm.smart.chat.enabled");
    }

    public final boolean isUniversalCompletionEnabled() {
        return this.state.isCompletionFallbackEnabled();
    }

    public final void setUniversalCompletionEnabled(boolean newValue) {
        this.state.setCompletionFallbackEnabled(newValue);
    }

    public final boolean isDatabaseContextEnabled() {
        return this.state.isDatabaseContextEnabled();
    }

    public final void setDatabaseContextEnabled(boolean newValue) {
        this.state.setDatabaseContextEnabled(newValue);
    }

    public final void setIgnoredCompletionExtensions(@NotNull String newValue) {
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        this.state.setIgnoredCompletionExtensions(newValue);
    }

    @NotNull
    public final IgnoredExtensionsFilter getIgnoredCompletionExtensions() {
        String string = this.state.getIgnoredCompletionExtensions();
        if (string == null) {
            string = "";
        }
        return new IgnoredExtensionsFilter(string);
    }

    private final MutableStateFlow<Boolean> isNameSuggestionsEnabledFlow() {
        Lazy lazy = this.isNameSuggestionsEnabledFlow$delegate;
        return (MutableStateFlow)lazy.getValue();
    }

    @NotNull
    public final StateFlow<Boolean> getNameSuggestionsEnabledState() {
        return FlowKt.asStateFlow(this.isNameSuggestionsEnabledFlow());
    }

    public final boolean isNameSuggestionsEnabled() {
        return this.state.isNameSuggestionsEnabled();
    }

    public final void setNameSuggestionsEnabled(boolean newValue) {
        this.state.setNameSuggestionsEnabled(newValue);
        this.isNameSuggestionsEnabledFlow().setValue((Object)newValue);
    }

    public final boolean isPasteConvertEnabled() {
        return this.state.isPasteConvertEnabled();
    }

    public final void setPasteConvertEnabled(boolean newValue) {
        this.state.setPasteConvertEnabled(newValue);
        this.isPasteConvertEnabledFlow().setValue((Object)newValue);
    }

    public final boolean isShelveTitleGenerationEnabled() {
        return this.state.isShelveTitleGenerationEnabled();
    }

    public final void setShelveTitleGenerationEnabled(boolean newValue) {
        this.state.setShelveTitleGenerationEnabled(newValue);
        this.isShelveTitleGenerateEnabledFlow().setValue((Object)newValue);
    }

    public final boolean isGenerateCommitSummaryEnabled() {
        return this.state.isGenerateCommitSummaryEnabled();
    }

    public final void setGenerateCommitSummaryEnabled(boolean newValue) {
        this.state.setGenerateCommitSummaryEnabled(newValue);
    }

    public final boolean isUpdateGenerateCommitSummaryEnabled() {
        return Registry.Companion.is("llm.generate.commit.summary") && this.state.isUpdateGenerateCommitSummaryEnabled() && this.state.isGenerateCommitSummaryEnabled();
    }

    public final void setUpdateGenerateCommitSummaryEnabled(boolean newValue) {
        this.state.setUpdateGenerateCommitSummaryEnabled(newValue);
    }

    public final boolean isFileGenerateCommitSummaryEnabled() {
        return Registry.Companion.is("llm.generate.commit.summary") && this.state.isFileGenerateCommitSummaryEnabled() && this.state.isGenerateCommitSummaryEnabled();
    }

    public final void setFileGenerateCommitSummaryEnabled(boolean newValue) {
        this.state.setFileGenerateCommitSummaryEnabled(newValue);
    }

    public final boolean isSelectionGenerateCommitSummaryEnabled() {
        return Registry.Companion.is("llm.generate.commit.summary") && this.state.isSelectionGenerateCommitSummaryEnabled() && this.state.isGenerateCommitSummaryEnabled();
    }

    public final void setSelectionGenerateCommitSummaryEnabled(boolean newValue) {
        this.state.setSelectionGenerateCommitSummaryEnabled(newValue);
    }

    public final float getToolwindowFontScale() {
        return this.state.getToolwindowFontScale();
    }

    public final void setToolwindowFontScale(float newValue) {
        this.state.setToolwindowFontScale(newValue);
    }

    public final boolean isChatNaturalLanguageSelectionEnabled() {
        return this.state.isChatNaturalLanguageSelectionEnabled();
    }

    public final void setChatNaturalLanguageSelectionEnabled(boolean newValue) {
        this.state.setChatNaturalLanguageSelectionEnabled(newValue);
        this.isChatNaturalLanguageSelectionEnabledFlow().setValue((Object)newValue);
    }

    public final boolean isExplicitlyExperimentalEnabled(@NotNull RegistryValue registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        return this.state.getExplicitlyEnabledExperimentalFeatures().contains(registry.getKey());
    }

    public final boolean isExplicitlyExperimentalDisabled(@NotNull RegistryValue registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        return this.state.getExplicitlyDisabledExperimentalFeatures().contains(registry.getKey());
    }

    /*
     * WARNING - void declaration
     */
    public final void setExplicitlyExperimentalEnabled$intellij_ml_llm_core(@NotNull RegistryValue registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        if (!this.state.getExplicitlyEnabledExperimentalFeatures().contains(registry.getKey())) {
            this.state.setExplicitlyEnabledExperimentalFeatures(CollectionsKt.plus((Collection)this.state.getExplicitlyEnabledExperimentalFeatures(), (Object)registry.getKey()));
        }
        if (this.state.getExplicitlyDisabledExperimentalFeatures().contains(registry.getKey())) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = this.state.getExplicitlyDisabledExperimentalFeatures();
            LLMSettings lLMSettings = this.state;
            boolean $i$f$filter = false;
            void var4_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)registry.getKey()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            lLMSettings.setExplicitlyDisabledExperimentalFeatures((List)destination$iv$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setExplicitlyExperimentalDisabled$intellij_ml_llm_core(@NotNull RegistryValue registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        if (!this.state.getExplicitlyDisabledExperimentalFeatures().contains(registry.getKey())) {
            this.state.setExplicitlyDisabledExperimentalFeatures(CollectionsKt.plus((Collection)this.state.getExplicitlyDisabledExperimentalFeatures(), (Object)registry.getKey()));
        }
        if (this.state.getExplicitlyEnabledExperimentalFeatures().contains(registry.getKey())) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = this.state.getExplicitlyEnabledExperimentalFeatures();
            LLMSettings lLMSettings = this.state;
            boolean $i$f$filter = false;
            void var4_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)registry.getKey()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            lLMSettings.setExplicitlyEnabledExperimentalFeatures((List)destination$iv$iv);
        }
    }

    public final void clearExplicitlySetExperimental() {
        this.state.setExplicitlyEnabledExperimentalFeatures(CollectionsKt.emptyList());
        this.state.setExplicitlyDisabledExperimentalFeatures(CollectionsKt.emptyList());
    }

    @NotNull
    public final PSString getChatNaturalLanguage() {
        PSString pSString = this.state.getChatNaturalLanguage();
        if (pSString == null) {
            pSString = ConstantsKt.getPrivacyConst((String)"");
        }
        return pSString;
    }

    public final void setChatNaturalLanguage(@NotNull PSString newValue) {
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        this.state.setChatNaturalLanguage(newValue);
        this.getChatNaturalLanguageFlow().setValue((Object)newValue);
    }

    @Nullable
    public final LLMProfileID getChatPreferredLLM() {
        LLMProfileID lLMProfileID;
        String string = this.state.getChatPreferredLLM();
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            lLMProfileID = new LLMProfileID(p0);
        } else {
            lLMProfileID = null;
        }
        return lLMProfileID;
    }

    public final void setChatPreferredLLM(@Nullable LLMProfileID newValue) {
        LLMProfileID lLMProfileID = newValue;
        this.state.setChatPreferredLLM(lLMProfileID != null ? lLMProfileID.getId() : null);
        this.chatPreferredLLMChangedFlow.tryEmit((Object)Unit.INSTANCE);
    }

    public final boolean isChatPreferredLLMAuto(@NotNull ChatModelKey modelKey) {
        Intrinsics.checkNotNullParameter((Object)modelKey, (String)"modelKey");
        LLMProfileID lLMProfileID = this.getChatPreferredModel(modelKey);
        return Intrinsics.areEqual((Object)(lLMProfileID != null ? lLMProfileID.getId() : null), (Object)this.AUTO_MODEL_PLACEHOLDER);
    }

    public final boolean isPreferableModelForMode(@NotNull ChatModelKey mode2, @NotNull AiaLlmProfileID profileIdToCheck) {
        Intrinsics.checkNotNullParameter((Object)mode2, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)profileIdToCheck, (String)"profileIdToCheck");
        LLMPromptID promptId = Intrinsics.areEqual((Object)mode2, (Object)ChatModelKey.Companion.getCodeGeneration()) ? LLMPromptsKt.getCODE_GENERATION_FROM_CHAT_PROMPT_ID() : LLMPromptsKt.getChatPromptId(ChatSourceAction.NEW_CHAT);
        boolean $i$f$service = false;
        Class<LlmInfoService> serviceClass$iv = LlmInfoService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        if (((LlmInfoService)object).hasCloudConfig() && this.isChatPreferredLLMAuto(mode2)) {
            return AiaLlmProfileIDUtils.INSTANCE.isAuto(profileIdToCheck, promptId);
        }
        LLMProfileID lLMProfileID = this.getChatPreferredModel(mode2);
        AiaLlmProfileID savedModel = lLMProfileID != null ? GrazieUtilsKt.fromLLMProfileID(lLMProfileID) : null;
        return Intrinsics.areEqual((Object)savedModel, (Object)profileIdToCheck);
    }

    public final void setChatPreferredLLMAuto(@NotNull ChatModelKey modelKey) {
        Intrinsics.checkNotNullParameter((Object)modelKey, (String)"modelKey");
        this.setChatPreferredModelsPerMode(modelKey, new LLMProfileID(this.AUTO_MODEL_PLACEHOLDER));
    }

    @Nullable
    public final LLMProfileID getChatPreferredModel(@NotNull ChatModelKey modelKey) {
        LLMProfileID lLMProfileID;
        Intrinsics.checkNotNullParameter((Object)modelKey, (String)"modelKey");
        String string = this.state.getChatPreferredModelsPerMode().get(modelKey.getName());
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            lLMProfileID = new LLMProfileID(p0);
        } else {
            lLMProfileID = this.getChatPreferredLLM();
        }
        return lLMProfileID;
    }

    public final void setChatPreferredModelsPerMode(@Nullable ChatModelKey modelKey, @NotNull LLMProfileID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (modelKey != null) {
            this.state.getChatPreferredModelsPerMode().put(modelKey.getName(), value.getId());
        }
        this.setChatPreferredLLM(value);
    }

    public final void setChatForcedModelEventForMode(@NotNull ChatModelKey modelKey, @NotNull String eventVersionId) {
        Intrinsics.checkNotNullParameter((Object)modelKey, (String)"modelKey");
        Intrinsics.checkNotNullParameter((Object)eventVersionId, (String)"eventVersionId");
        this.state.getChatForcedModelsPerMode().put(modelKey.getName(), eventVersionId);
    }

    @NotNull
    public final String getChatForcedModelEventForMode(@NotNull ChatModelKey modelKey) {
        Intrinsics.checkNotNullParameter((Object)modelKey, (String)"modelKey");
        String string = this.state.getChatForcedModelsPerMode().get(modelKey.getName());
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Nullable
    public final ChatSessionMode getChatMode() {
        ChatSessionMode chatSessionMode;
        String string = this.state.getChatMode();
        if (string != null) {
            ChatSessionMode chatSessionMode2;
            String it = string;
            boolean bl = false;
            try {
                chatSessionMode2 = ChatSessionMode.valueOf(it);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                chatSessionMode2 = null;
            }
            chatSessionMode = chatSessionMode2;
        } else {
            chatSessionMode = null;
        }
        return chatSessionMode;
    }

    @Nullable
    public final String getAgentId() {
        return this.state.getAgentId();
    }

    public final void setChatMode(@NotNull ChatSessionMode newValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)newValue), (String)"newValue");
        this.state.setChatMode(newValue.name());
    }

    public final void setAgentId(@Nullable String newValue) {
        this.state.setAgentId(newValue);
    }

    @Nullable
    public final Boolean getCodebaseEnabledInChatMode() {
        String string = this.state.getCodeBaseEnabledInChatMode();
        return string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
    }

    public final void setCodebaseEnabledInChatMode(boolean newValue) {
        this.state.setCodeBaseEnabledInChatMode(String.valueOf(newValue));
    }

    @NotNull
    public final List<String> getTrustedDomains() {
        return this.state.getTrustedDomains();
    }

    public final void setTrustedDomains(@NotNull List<String> newValue) {
        Intrinsics.checkNotNullParameter(newValue, (String)"newValue");
        this.state.setTrustedDomains(CollectionsKt.toMutableList((Collection)newValue));
    }

    public final boolean isCustomChatInstructionWasShown() {
        return this.state.isCustomChatInstructionWasShown();
    }

    public final void setCustomChatInstructionWasShown(boolean newValue) {
        this.state.setCustomChatInstructionWasShown(newValue);
    }

    public final boolean useSoftWrapsInChat() {
        return this.state.getUseSoftWrapsInChat();
    }

    public final void setUseSoftWrapsInChat(boolean newValue) {
        this.state.setUseSoftWrapsInChat(newValue);
    }

    public final boolean useLineNumbersInChat() {
        return this.state.getUseLineNumbersInChat();
    }

    public final void setUseLineNumbersInChat(boolean newValue) {
        this.state.setUseLineNumbersInChat(newValue);
    }

    public final boolean useIndentGuidesInChat() {
        return this.state.getUseIndentGuidesInChat();
    }

    public final void setUseIndentGuidesInChat(boolean newValue) {
        this.state.setUseIndentGuidesInChat(newValue);
    }

    @NotNull
    public final UserMessageTrimmingThreshold getUserMessageTrimmingThreshold() {
        return this.state.getUserMessageTrimmingThreshold();
    }

    public final void setUserMessageTrimmingThreshold(@NotNull UserMessageTrimmingThreshold newValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)newValue), (String)"newValue");
        UserMessageTrimmingThreshold currentThreshold = this.state.getUserMessageTrimmingThreshold();
        if (currentThreshold != newValue) {
            TokenizerLimitLogger.logUserMessageTrimmingThresholdChanged((int)currentThreshold.getPercentage(), (int)newValue.getPercentage());
        }
        this.state.setUserMessageTrimmingThreshold(newValue);
        this.getUserMessageTrimmingThresholdFlow().setValue((Object)newValue);
    }

    private static final MutableStateFlow isPasteConvertEnabledFlow_delegate$lambda$0(LLMSettingsManager this$0) {
        return StateFlowKt.MutableStateFlow((Object)this$0.isPasteConvertEnabled());
    }

    private static final MutableStateFlow isShelveTitleGenerateEnabledFlow_delegate$lambda$1(LLMSettingsManager this$0) {
        return StateFlowKt.MutableStateFlow((Object)this$0.isShelveTitleGenerationEnabled());
    }

    private static final MutableStateFlow userMessageTrimmingThresholdFlow_delegate$lambda$2(LLMSettingsManager this$0) {
        return StateFlowKt.MutableStateFlow((Object)((Object)this$0.getUserMessageTrimmingThreshold()));
    }

    private static final MutableStateFlow isChatNaturalLanguageSelectionEnabledFlow_delegate$lambda$3(LLMSettingsManager this$0) {
        return StateFlowKt.MutableStateFlow((Object)this$0.isChatNaturalLanguageSelectionEnabled());
    }

    private static final MutableStateFlow chatNaturalLanguageFlow_delegate$lambda$4(LLMSettingsManager this$0) {
        return StateFlowKt.MutableStateFlow((Object)this$0.getChatNaturalLanguage());
    }

    private static final Unit isInlineCompletionEnabledState_delegate$lambda$7$lambda$6$lambda$5(LLMSettingsManager this$0, boolean it) {
        this$0.state.setInlineCompletionEnabled(it);
        return Unit.INSTANCE;
    }

    private static final AtomicBooleanProperty isInlineCompletionEnabledState_delegate$lambda$7(LLMSettingsManager this$0) {
        AtomicBooleanProperty atomicBooleanProperty;
        AtomicBooleanProperty $this$isInlineCompletionEnabledState_delegate_u24lambda_u247_u24lambda_u246 = atomicBooleanProperty = new AtomicBooleanProperty(this$0.state.isInlineCompletionEnabled());
        boolean bl = false;
        $this$isInlineCompletionEnabledState_delegate_u24lambda_u247_u24lambda_u246.afterChange(arg_0 -> LLMSettingsManager.isInlineCompletionEnabledState_delegate$lambda$7$lambda$6$lambda$5(this$0, arg_0));
        return atomicBooleanProperty;
    }

    private static final MutableStateFlow isNameSuggestionsEnabledFlow_delegate$lambda$8(LLMSettingsManager this$0) {
        return StateFlowKt.MutableStateFlow((Object)this$0.isNameSuggestionsEnabled());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/core/settings/LLMSettingsManager$Companion;", "", "<init>", "()V", "SMART_CHAT_DEFAULT_SETTING", "", "NAME_SUGGESTION_DEFAULT_SETTING", "PASTE_CONVERT_DEFAULT_SETTING", "SHELVE_TITLE_GENERATION_DEFAULT_SETTING", "getInstance", "Lcom/intellij/ml/llm/core/settings/LLMSettingsManager;", "fireSettingsChanged", "", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nLLMSettingsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMSettingsManager.kt\ncom/intellij/ml/llm/core/settings/LLMSettingsManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,479:1\n40#2,3:480\n*S KotlinDebug\n*F\n+ 1 LLMSettingsManager.kt\ncom/intellij/ml/llm/core/settings/LLMSettingsManager$Companion\n*L\n53#1:480,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLMSettingsManager getInstance() {
            boolean $i$f$service = false;
            Class<LLMSettingsManager> serviceClass$iv = LLMSettingsManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LLMSettingsManager)object;
        }

        public final void fireSettingsChanged() {
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
            MessageBus messageBus2 = messageBus;
            ((LLMSettingsListener)messageBus2.syncPublisher(LLMSettingsListener.Companion.getTOPIC())).settingsChanged();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

