/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.editor;

import com.intellij.ml.llm.editor.AICaretAttributeKeys;
import com.intellij.ml.llm.editor.Holder;
import com.intellij.ml.llm.editor.MagicWandKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Color;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\rH\u0007J\b\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/editor/MagicWand;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "token", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getToken", "()Ljava/lang/String;", "start", "", "stop", "changeColor", "revertColor", "magicCaretAttributes", "Lcom/intellij/openapi/editor/CaretVisualAttributes;", "currentCaretVisualAttributes", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nMagicWand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MagicWand.kt\ncom/intellij/ml/llm/editor/MagicWand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public final class MagicWand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final String token;

    public MagicWand(@NotNull Editor editor, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.editor = editor;
        this.token = token;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @RequiresEdt
    public final void start() {
        Set currentTokens;
        Set set = (Set)this.editor.getUserData(MagicWandKt.access$getACTIVE_TOKENS_KEY$p());
        if (set == null) {
            set = new LinkedHashSet();
        }
        if ((currentTokens = set).isEmpty()) {
            this.changeColor();
        }
        currentTokens.add(this.token);
        this.editor.putUserData(MagicWandKt.access$getACTIVE_TOKENS_KEY$p(), (Object)currentTokens);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void stop() {
        void it;
        Set set;
        Set set2 = (Set)this.editor.getUserData(MagicWandKt.access$getACTIVE_TOKENS_KEY$p());
        if (set2 == null) {
            set2 = new LinkedHashSet();
        }
        Set currentTokens = set2;
        currentTokens.remove(this.token);
        if (currentTokens.isEmpty()) {
            this.revertColor();
        }
        Set set3 = set = currentTokens;
        Key key = MagicWandKt.access$getACTIVE_TOKENS_KEY$p();
        Editor editor = this.editor;
        boolean bl = false;
        boolean bl2 = !((Collection)it).isEmpty();
        editor.putUserData(key, (Object)(bl2 ? set : null));
    }

    private final void changeColor() {
        Caret caret = this.editor.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        Caret caret2 = caret;
        CaretVisualAttributes caretVisualAttributes = caret2.getVisualAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)caretVisualAttributes, (String)"getVisualAttributes(...)");
        CaretVisualAttributes currentCaretVisualAttributes = caretVisualAttributes;
        this.editor.putUserData(MagicWandKt.access$getUSUAL_CARET_COLOR_KEY$p(), new Holder<Color>(currentCaretVisualAttributes.getColor()));
        EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        caret2.setVisualAttributes(this.magicCaretAttributes(currentCaretVisualAttributes, editorColorsScheme));
    }

    private final void revertColor() {
        Caret caret = this.editor.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        Caret caret2 = caret;
        Holder prevCaretColor = (Holder)this.editor.getUserData(MagicWandKt.access$getUSUAL_CARET_COLOR_KEY$p());
        if (prevCaretColor != null) {
            this.editor.putUserData(MagicWandKt.access$getUSUAL_CARET_COLOR_KEY$p(), null);
            CaretVisualAttributes caretVisualAttributes = caret2.getVisualAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)caretVisualAttributes, (String)"getVisualAttributes(...)");
            CaretVisualAttributes currentCaretVisualAttributes = caretVisualAttributes;
            caret2.setVisualAttributes(new CaretVisualAttributes((Color)prevCaretColor.getValue(), currentCaretVisualAttributes.getWeight(), currentCaretVisualAttributes.getShape(), currentCaretVisualAttributes.getThickness()));
        }
    }

    private final CaretVisualAttributes magicCaretAttributes(CaretVisualAttributes currentCaretVisualAttributes, EditorColorsScheme scheme) {
        TextAttributes attributes = scheme.getAttributes(AICaretAttributeKeys.INLINE_PROMPT_ATTRS);
        return new CaretVisualAttributes(attributes.getForegroundColor(), currentCaretVisualAttributes.getWeight(), currentCaretVisualAttributes.getShape(), currentCaretVisualAttributes.getThickness());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/editor/MagicWand$Companion;", "", "<init>", "()V", "isActive", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        @RequiresEdt
        public final boolean isActive(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            ThreadingAssertions.assertEventDispatchThread();
            Set set = (Set)editor.getUserData(MagicWandKt.access$getACTIVE_TOKENS_KEY$p());
            boolean bl = set != null ? !((Collection)set).isEmpty() : false;
            if (bl) {
                return true;
            }
            return editor.getUserData(MagicWandKt.access$getUSUAL_CARET_COLOR_KEY$p()) != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

