/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.hub;

import com.intellij.codeWithMe.ClientId;
import com.intellij.llmInstaller.api.AiToolWindowService;
import com.intellij.llmInstaller.ui.hub.AIAssistantHubExtension;
import com.intellij.llmInstaller.ui.hub.states.AIHubNotInstalled;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.MLLlmIcons;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtilKt;
import com.intellij.ml.llm.hub.AIAssistantHub;
import com.intellij.ml.llm.hub.AIAssistantHubKt;
import com.intellij.ml.llm.hub.AIHubInstalled;
import com.intellij.ml.llm.hub.AIHubInstalledManager;
import com.intellij.ml.llm.hub.AIHubNotificationManager;
import com.intellij.ml.llm.hub.AIHubNotificationManagerKt;
import com.intellij.ml.llm.hub.actions.InstallJunieHubActionManager;
import com.intellij.ml.llm.hub.statistics.AIHubLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.BadgeIcon;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UiScopeKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/hub/AIAssistantHub;", "Lcom/intellij/llmInstaller/ui/hub/AIAssistantHubExtension;", "<init>", "()V", "getContentActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "project", "Lcom/intellij/openapi/project/Project;", "getContent", "Ljavax/swing/JComponent;", "popup", "Lcom/intellij/ui/popup/WizardPopup;", "actionGroupContent", "updatePresentation", "", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "getIcon", "Ljavax/swing/Icon;", "defaultIcon", "getBadgeColor", "Ljava/awt/Color;", "intellij.ml.llm.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAIAssistantHub.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantHub.kt\ncom/intellij/ml/llm/hub/AIAssistantHub\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,131:1\n774#2:132\n865#2,2:133\n1#3:135\n40#4,3:136\n*S KotlinDebug\n*F\n+ 1 AIAssistantHub.kt\ncom/intellij/ml/llm/hub/AIAssistantHub\n*L\n121#1:132\n121#1:133,2\n57#1:136,3\n*E\n"})
public final class AIAssistantHub
implements AIAssistantHubExtension {
    @NotNull
    public ActionGroup getContentActionGroup(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String groupId = "AIHub.Installed";
        ActionGroup actionGroup = ActionUtil.getActionGroup((String)groupId);
        if (actionGroup == null) {
            throw new IllegalStateException("Action group " + groupId + " not found");
        }
        return actionGroup;
    }

    @NotNull
    public JComponent getContent(@NotNull Project project, @NotNull WizardPopup popup, @NotNull JComponent actionGroupContent) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        Intrinsics.checkNotNullParameter((Object)actionGroupContent, (String)"actionGroupContent");
        AIHubLogger.INSTANCE.logHubIconClicked(project);
        boolean activationPending = AIHubInstalledManager.Companion.isActivationPending(project);
        if (AIAssistantHubKt.isLetsGoMode(project)) {
            Runnable enableAction = () -> AIAssistantHub.getContent$lambda$0(project);
            jComponent = new AIHubNotInstalled(project, popup, enableAction, actionGroupContent).getContent();
        } else {
            jComponent = new AIHubInstalled(project, popup, actionGroupContent).getContent();
        }
        JComponent result2 = jComponent;
        UiScopeKt.launchOnShow$default((Component)result2, (String)"AIAssistantHub.mode", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, popup, activationPending, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ WizardPopup $popup;
            final /* synthetic */ boolean $activationPending;
            {
                this.$project = $project;
                this.$popup = $popup;
                this.$activationPending = $activationPending;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        InstallJunieHubActionManager.Companion.getInstance(this.$project).onHubOpen();
                        Disposer.register((Disposable)((Disposable)this.$popup), () -> getContent.1.invokeSuspend$lambda$0(this.$project));
                        this.label = 1;
                        Object object2 = AIHubInstalledManager.Companion.getInstance(this.$project).getMode().collect(new FlowCollector(this.$project, this.$activationPending, this.$popup){
                            final /* synthetic */ Project $project;
                            final /* synthetic */ boolean $activationPending;
                            final /* synthetic */ WizardPopup $popup;
                            {
                                this.$project = $project;
                                this.$activationPending = $activationPending;
                                this.$popup = $popup;
                            }

                            public final Object emit(AIHubInstalledManager.Mode it, Continuation<? super Unit> $completion) {
                                boolean newActivationPending = AIHubInstalledManager.Companion.isActivationPending(this.$project);
                                if (this.$activationPending != newActivationPending) {
                                    Disposer.dispose((Disposable)((Disposable)this.$popup));
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(Project $project) {
                InstallJunieHubActionManager.Companion.getInstance($project).onHubClose();
            }
        }), (int)2, null);
        return result2;
    }

    public void updatePresentation(@NotNull Project project, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Icon icon = presentation.getIcon();
        if (icon == null) {
            return;
        }
        presentation.setIcon(this.getIcon(project, icon));
        presentation.setText(LLMBundle.message("ai.hub.tooltip.text", new Object[0]));
        presentation.setDescription(LLMBundle.message("ai.hub.tooltip.description", new Object[0]));
        presentation.setEnabledAndVisible(true);
    }

    private final Icon getIcon(Project project, Icon defaultIcon) {
        Color badgeColor;
        Icon icon;
        AIHubInstalledManager.Mode mode2 = (AIHubInstalledManager.Mode)((Object)AIHubInstalledManager.Companion.getInstance(project).getMode().getValue());
        switch (WhenMappings.$EnumSwitchMapping$0[mode2.ordinal()]) {
            case 1: 
            case 2: {
                icon = defaultIcon;
                break;
            }
            case 3: {
                Icon icon2 = MLLlmIcons.Hub.ToolbarAirplane;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ToolbarAirplane");
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                Icon icon3 = MLLlmIcons.Hub.ToolbarDisabled;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"ToolbarDisabled");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Icon icon4 = icon;
        InstallJunieHubActionManager junieManager = InstallJunieHubActionManager.Companion.getInstance(project);
        Color color = badgeColor = mode2 == AIHubInstalledManager.Mode.OFFLINE || mode2 == AIHubInstalledManager.Mode.ONLINE || mode2 == AIHubInstalledManager.Mode.ACTIVATION_PENDING && !AIAssistantHubKt.isLetsGoMode(project) ? this.getBadgeColor() : null;
        if (badgeColor == null && ((Boolean)junieManager.isActionVisible().getValue()).booleanValue() && ((Boolean)junieManager.getShouldShowBadge().getValue()).booleanValue()) {
            badgeColor = JBUI.CurrentTheme.IconBadge.INFORMATION;
        }
        return badgeColor == null ? icon4 : (Icon)new BadgeIcon(icon4, (Paint)badgeColor);
    }

    /*
     * WARNING - void declaration
     */
    private final Color getBadgeColor() {
        Object v0;
        block3: {
            void $this$filterTo$iv$iv;
            AIHubNotificationManager notificationManager = AIHubNotificationManager.Companion.getInstance();
            Iterable $this$filter$iv = (Iterable)notificationManager.getNotifications().getValue();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AIHubNotificationManager.NotificationState it = (AIHubNotificationManager.NotificationState)element$iv$iv;
                boolean bl = false;
                if (!(AIHubInstalled.Companion.isAllowedHubNotifications(it.getNotification()) && !it.getSeen())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List notSeenNotifications = (List)destination$iv$iv;
            if (notSeenNotifications.isEmpty()) {
                return null;
            }
            iterable = notSeenNotifications;
            for (Object t : iterable) {
                AIHubNotificationManager.NotificationState it = (AIHubNotificationManager.NotificationState)t;
                boolean bl = false;
                if (!AIHubNotificationManagerKt.isWarning(it.getNotification())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        boolean isWarning = v0 != null;
        return isWarning ? JBUI.CurrentTheme.IconBadge.WARNING : JBUI.CurrentTheme.IconBadge.INFORMATION;
    }

    private static final void getContent$lambda$0(Project $project) {
        AIHubLogger.INSTANCE.logButtonClicked($project, AIHubLogger.ButtonName.LETS_GO, AIAssistantUIUtilKt.getLicenseType());
        boolean $i$f$service = false;
        Class<AiToolWindowService> serviceClass$iv = AiToolWindowService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((AiToolWindowService)object).activateToolWindow($project);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AIHubInstalledManager.Mode.values().length];
            try {
                nArray[AIHubInstalledManager.Mode.ONLINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubInstalledManager.Mode.ACTIVATION_PENDING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubInstalledManager.Mode.OFFLINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubInstalledManager.Mode.NOT_AVAILABLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubInstalledManager.Mode.DISABLED_FOR_PROJECT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubInstalledManager.Mode.DISABLED_COMMERCIAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubInstalledManager.Mode.DISABLED_ENTERPRISE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubInstalledManager.Mode.DISABLED_NO_AI_FILE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

