/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.hub;

import com.intellij.ide.HelpTooltip;
import com.intellij.llmInstaller.ui.hub.states.AIHubUIKt;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtilKt;
import com.intellij.ml.llm.core.chat.ui.QuotaTimeData;
import com.intellij.ml.llm.core.chat.ui.RemainedQuotasInfo;
import com.intellij.ml.llm.core.quota.QuotaInfo;
import com.intellij.ml.llm.core.quota.QuotaManager2;
import com.intellij.ml.llm.hub.AIHubInstalled;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.VerticalComponentGap;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.util.ui.UiScopeKt;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/hub/AIHubQuotes;", "", "panel", "Lcom/intellij/ui/dsl/builder/Panel;", "popup", "Lcom/intellij/ui/popup/WizardPopup;", "<init>", "(Lcom/intellij/ui/dsl/builder/Panel;Lcom/intellij/ui/popup/WizardPopup;)V", "quotesPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "remainedLabel", "Ljavax/swing/JLabel;", "progressBar", "Ljavax/swing/JProgressBar;", "updateQuotes", "", "intellij.ml.llm.core"})
public final class AIHubQuotes {
    @NotNull
    private final DialogPanel quotesPanel;
    private JLabel remainedLabel;
    private JProgressBar progressBar;

    public AIHubQuotes(@NotNull Panel panel, @NotNull WizardPopup popup) {
        JProgressBar jProgressBar;
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        this.quotesPanel = BuilderKt.panel(arg_0 -> AIHubQuotes._init_$lambda$3(this, arg_0));
        Panel $this$_init__u24lambda_u245 = panel;
        boolean bl = false;
        Panel.row$default((Panel)$this$_init__u24lambda_u245, null, arg_0 -> AIHubQuotes.lambda$5$lambda$4(this, arg_0), (int)1, null);
        JLabel jLabel = this.remainedLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remainedLabel");
            jLabel = null;
        }
        if ((jProgressBar = this.progressBar) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
            jProgressBar = null;
        }
        this.updateQuotes(this.quotesPanel, jLabel, jProgressBar);
        JProgressBar jProgressBar2 = this.progressBar;
        if (jProgressBar2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
            jProgressBar2 = null;
        }
        UiScopeKt.launchOnShow$default((Component)jProgressBar2, (String)"HUB quotes", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, popup, null){
            int label;
            final /* synthetic */ AIHubQuotes this$0;
            final /* synthetic */ WizardPopup $popup;
            {
                this.this$0 = $receiver;
                this.$popup = $popup;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Flow[] flowArray = new Flow[]{QuotaManager2.Companion.getInstance().getQuotaInfo(), QuotaManager2.Companion.getInstance().getNextRefill()};
                        this.label = 1;
                        Object object2 = FlowKt.merge((Flow[])flowArray).collect(new FlowCollector(){

                            public final Object emit(Object it, Continuation<? super Unit> $completion) {
                                JProgressBar jProgressBar;
                                DialogPanel dialogPanel = this$0.quotesPanel;
                                JLabel jLabel = this$0.remainedLabel;
                                if (jLabel == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"remainedLabel");
                                    jLabel = null;
                                }
                                if ((jProgressBar = this$0.progressBar) == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
                                    jProgressBar = null;
                                }
                                this$0.updateQuotes(dialogPanel, jLabel, jProgressBar);
                                AIAssistantUIUtilKt.repack((AbstractPopup)$popup);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void updateQuotes(DialogPanel quotesPanel, JLabel remainedLabel, JProgressBar progressBar) {
        boolean isUnimplementedQuota;
        boolean bl = isUnimplementedQuota = QuotaManager2.Companion.getInstance().getQuotaInfo().getValue() == QuotaInfo.Companion.getEMPTY_AVAILABLE();
        if (!AIAssistantUIUtilKt.isValid(AIAssistantUIUtilKt.getLicenseType()) || isUnimplementedQuota) {
            quotesPanel.setVisible(false);
            return;
        }
        quotesPanel.setVisible(true);
        RemainedQuotasInfo quotasInfo = AIAssistantUIUtil.INSTANCE.getRemainedTariffQuotasInfo();
        QuotaTimeData quotaData = AIAssistantUIUtil.INSTANCE.getQuotaTimeData();
        remainedLabel.setText(AIAssistantUIUtil.INSTANCE.formatQuotaInfoLabel(quotaData));
        progressBar.setValue(quotasInfo.getRemainedPercents());
        QuotaInfo.SuccessfulQuotaInfo quota = (QuotaInfo.SuccessfulQuotaInfo)QuotaManager2.Companion.getInstance().getLastSuccessfulQuota().getValue();
        long usedCredits = 0L;
        long totalCredits = 0L;
        if (quota == null) {
            AIHubInstalled.Companion.getLog$intellij_ml_llm_core().debug("updateQuotes: lastSuccessfulQuota is null");
            usedCredits = 0L;
            totalCredits = 0L;
        } else {
            long l;
            QuotaInfo.SuccessfulQuotaInfo successfulQuotaInfo = quota;
            if (successfulQuotaInfo instanceof QuotaInfo.Available) {
                l = MathKt.roundToLong((double)((QuotaInfo.Available)quota).getCurrent().doubleValue());
            } else if (successfulQuotaInfo instanceof QuotaInfo.Reached) {
                l = MathKt.roundToLong((double)((QuotaInfo.Reached)quota).getMaximum().doubleValue());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            usedCredits = l;
            totalCredits = MathKt.roundToLong((double)quota.getMaximum().doubleValue());
        }
        new HelpTooltip().setTitle(LLMBundle.message("ai.hub.quota.tooltip.title", new Object[0])).setDescription(AIHubInstalled.Companion.getQuotaTooltipMessage(usedCredits, totalCredits, quotasInfo.getEndsInDays(), quotasInfo.getEndsInHours())).installOn((JComponent)quotesPanel);
    }

    private static final Unit lambda$3$lambda$0(AIHubQuotes this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(LLMBundle.message("ai.hub.label.quota", new Object[0]));
        this$0.remainedLabel = (JLabel)AIAssistantUIUtilKt.greyForeground($this$row.label("")).align((Align)AlignX.RIGHT.INSTANCE).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$3$lambda$2$lambda$1(JProgressBar $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setValue(0);
        $this$applyToComponent.putClientProperty(DslComponentProperty.VERTICAL_COMPONENT_GAP, new VerticalComponentGap(Boolean.valueOf(false), null, 2, null));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$3$lambda$2(AIHubQuotes this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.progressBar = (JProgressBar)AIHubUIKt.hubProgressBar((Row)$this$row, (int)0, (int)100).align((Align)AlignX.FILL.INSTANCE).applyToComponent(AIHubQuotes::lambda$3$lambda$2$lambda$1).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(AIHubQuotes this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AIHubQuotes.lambda$3$lambda$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AIHubQuotes.lambda$3$lambda$2(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$lambda$4(AIHubQuotes this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.quotesPanel).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }
}

