/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.util.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000  *\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00060\u0003j\u0002`\u0004:\u0002 !B\u0011\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0017\b\u0016\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0016\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0002J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0006H\u0002R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/util/collections/AppendOnlyList;", "T", "Lkotlin/collections/AbstractList;", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "capacity", "", "<init>", "(I)V", "items", "", "(Ljava/util/Collection;)V", "", "", "[Ljava/lang/Object;", "value", "size", "getSize", "()I", "get", "index", "(I)Ljava/lang/Object;", "snapshot", "", "add", "", "item", "(Ljava/lang/Object;)V", "addAll", "newItems", "grow", "requiredSize", "Companion", "Snapshot", "intellij.ml.llm.core"})
public final class AppendOnlyList<T>
extends AbstractList<T>
implements RandomAccess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Object[] items;
    private int size;
    public static final int DEFAULT_CAPACITY = 10;

    public AppendOnlyList(int capacity) {
        this.items = new Object[capacity];
    }

    public /* synthetic */ AppendOnlyList(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    public AppendOnlyList(@NotNull Collection<? extends T> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this(items.size());
        super.addAll(items);
    }

    public int getSize() {
        return this.size;
    }

    public T get(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException(index);
        }
        return (T)this.items[index];
    }

    @NotNull
    public final List<T> snapshot() {
        return (List)((Object)new Snapshot(this.items, this.size()));
    }

    public final void add(T item) {
        if (this.size() == this.items.length) {
            this.grow(this.size() + 1);
        }
        int n = this.size();
        this.size = n + 1;
        this.items[n] = item;
    }

    private final void addAll(Collection<? extends T> newItems) {
        int newItemsCount = this.items.length;
        int newSize = this.size() + newItemsCount;
        if (newSize > this.items.length) {
            this.grow(newSize);
        }
        int index = this.size();
        for (T newItem : newItems) {
            this.items[index++] = newItem;
        }
        this.size = newSize;
    }

    private final void grow(int requiredSize) {
        int oldCapacity = this.items.length;
        int newCapacity = Math.max(requiredSize, Math.max(oldCapacity + (oldCapacity >> 1), 10));
        Object[] objectArray = Arrays.copyOf(this.items, newCapacity);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        this.items = objectArray;
    }

    public AppendOnlyList() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/util/collections/AppendOnlyList$Companion;", "", "<init>", "()V", "DEFAULT_CAPACITY", "", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00060\u0003j\u0002`\u0004B\u001f\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u000f\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u0010\u0011R\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/util/collections/AppendOnlyList$Snapshot;", "T", "Lkotlin/collections/AbstractList;", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "items", "", "", "size", "", "<init>", "([Ljava/lang/Object;I)V", "[Ljava/lang/Object;", "getSize", "()I", "get", "index", "(I)Ljava/lang/Object;", "intellij.ml.llm.core"})
    private static final class Snapshot<T>
    extends AbstractList<T>
    implements RandomAccess {
        @NotNull
        private final Object[] items;
        private final int size;

        public Snapshot(@NotNull Object[] items, int size) {
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            this.items = items;
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public T get(int index) {
            if (index >= this.size()) {
                throw new IndexOutOfBoundsException(index);
            }
            return (T)this.items[index];
        }
    }
}

