/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.FontAlreadyLoadedException;
import org.scilab.forge.jlatexmath.FontInfo;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.XMLResourceParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultTeXFontParser {
    private static boolean registerFontExceptionDisplayed = false;
    private static boolean shouldRegisterFonts = true;
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    public static final String RESOURCE_NAME = "DefaultTeXFont.xml";
    public static final String STYLE_MAPPING_EL = "TextStyleMapping";
    public static final String SYMBOL_MAPPING_EL = "SymbolMapping";
    public static final String GEN_SET_EL = "GeneralSettings";
    public static final String MUFONTID_ATTR = "mufontid";
    public static final String SPACEFONTID_ATTR = "spacefontid";
    protected static ArrayList<String> Font_ID = new ArrayList();
    private static Map<String, Integer> rangeTypeMappings = new HashMap<String, Integer>();
    private static Map<String, CharChildParser> charChildParsers = new HashMap<String, CharChildParser>();
    private Map<String, CharFont[]> parsedTextStyles;
    private Element root;
    private Object base = null;

    public DefaultTeXFontParser() throws ResourceParseException {
        this(DefaultTeXFontParser.class.getResourceAsStream(RESOURCE_NAME), RESOURCE_NAME);
    }

    public DefaultTeXFontParser(InputStream file, String name) throws ResourceParseException {
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        try {
            this.root = factory.newDocumentBuilder().parse(file).getDocumentElement();
        }
        catch (Exception e) {
            throw new XMLResourceParseException(name, e);
        }
    }

    public DefaultTeXFontParser(Object base, InputStream file, String name) throws ResourceParseException {
        this.base = base;
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        try {
            this.root = factory.newDocumentBuilder().parse(file).getDocumentElement();
        }
        catch (Exception e) {
            throw new XMLResourceParseException(name, e);
        }
    }

    private static void setCharChildParsers() {
        charChildParsers.put("Kern", new KernParser());
        charChildParsers.put("Lig", new LigParser());
        charChildParsers.put("NextLarger", new NextLargerParser());
        charChildParsers.put("Extension", new ExtensionParser());
    }

    public FontInfo[] parseFontDescriptions(FontInfo[] fi, InputStream file, String name) throws ResourceParseException {
        Element font;
        if (file == null) {
            return fi;
        }
        ArrayList<FontInfo> res = new ArrayList<FontInfo>(Arrays.asList(fi));
        try {
            font = factory.newDocumentBuilder().parse(file).getDocumentElement();
        }
        catch (Exception e) {
            throw new XMLResourceParseException("Cannot find the file " + name + "!" + e.toString());
        }
        String fontName = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("name", font);
        String fontId = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("id", font);
        if (Font_ID.indexOf(fontId) >= 0) {
            throw new FontAlreadyLoadedException("Font " + fontId + " is already loaded !");
        }
        Font_ID.add(fontId);
        float space = DefaultTeXFontParser.getFloatAndCheck("space", font);
        float xHeight = DefaultTeXFontParser.getFloatAndCheck("xHeight", font);
        float quad = DefaultTeXFontParser.getFloatAndCheck("quad", font);
        int skewChar = DefaultTeXFontParser.getOptionalInt("skewChar", font, -1);
        int unicode = DefaultTeXFontParser.getOptionalInt("unicode", font, 0);
        String bold = null;
        try {
            bold = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("boldVersion", font);
        }
        catch (ResourceParseException resourceParseException) {
            // empty catch block
        }
        String roman = null;
        try {
            roman = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("romanVersion", font);
        }
        catch (ResourceParseException resourceParseException) {
            // empty catch block
        }
        String ss = null;
        try {
            ss = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("ssVersion", font);
        }
        catch (ResourceParseException resourceParseException) {
            // empty catch block
        }
        String tt = null;
        try {
            tt = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("ttVersion", font);
        }
        catch (ResourceParseException resourceParseException) {
            // empty catch block
        }
        String it = null;
        try {
            it = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("itVersion", font);
        }
        catch (ResourceParseException resourceParseException) {
            // empty catch block
        }
        String path = name.substring(0, name.lastIndexOf("/") + 1) + fontName;
        FontInfo info = new FontInfo(Font_ID.indexOf(fontId), this.base, path, fontName, unicode, xHeight, space, quad, bold, roman, ss, tt, it);
        if (skewChar != -1) {
            info.setSkewChar((char)skewChar);
        }
        NodeList listF = font.getElementsByTagName("Char");
        for (int j = 0; j < listF.getLength(); ++j) {
            DefaultTeXFontParser.processCharElement((Element)listF.item(j), info);
        }
        res.add(info);
        for (int i = 0; i < res.size(); ++i) {
            FontInfo fin = res.get(i);
            fin.setBoldId(Font_ID.indexOf(fin.boldVersion));
            fin.setRomanId(Font_ID.indexOf(fin.romanVersion));
            fin.setSsId(Font_ID.indexOf(fin.ssVersion));
            fin.setTtId(Font_ID.indexOf(fin.ttVersion));
            fin.setItId(Font_ID.indexOf(fin.itVersion));
        }
        this.parsedTextStyles = this.parseStyleMappings();
        return res.toArray(fi);
    }

    public FontInfo[] parseFontDescriptions(FontInfo[] fi) throws ResourceParseException {
        Element fontDescriptions = (Element)this.root.getElementsByTagName("FontDescriptions").item(0);
        if (fontDescriptions != null) {
            NodeList list = fontDescriptions.getElementsByTagName("Metrics");
            for (int i = 0; i < list.getLength(); ++i) {
                String include = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("include", (Element)list.item(i));
                fi = this.base == null ? this.parseFontDescriptions(fi, DefaultTeXFontParser.class.getResourceAsStream(include), include) : this.parseFontDescriptions(fi, this.base.getClass().getResourceAsStream(include), include);
            }
        }
        return fi;
    }

    protected void parseExtraPath() throws ResourceParseException {
        Element settings;
        Element syms = (Element)this.root.getElementsByTagName("TeXSymbols").item(0);
        if (syms != null) {
            String include = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("include", syms);
            SymbolAtom.addSymbolAtom(this.base.getClass().getResourceAsStream(include), include);
        }
        if ((settings = (Element)this.root.getElementsByTagName("FormulaSettings").item(0)) != null) {
            String include = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("include", settings);
            TeXFormula.addSymbolMappings(this.base.getClass().getResourceAsStream(include), include);
        }
    }

    private static void processCharElement(Element charElement, FontInfo info) throws ResourceParseException {
        char ch = (char)DefaultTeXFontParser.getIntAndCheck("code", charElement);
        float[] metrics = new float[]{DefaultTeXFontParser.getOptionalFloat("width", charElement, 0.0f), DefaultTeXFontParser.getOptionalFloat("height", charElement, 0.0f), DefaultTeXFontParser.getOptionalFloat("depth", charElement, 0.0f), DefaultTeXFontParser.getOptionalFloat("italic", charElement, 0.0f)};
        info.setMetrics(ch, metrics);
        NodeList list = charElement.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() == 3) continue;
            Element el = (Element)node;
            CharChildParser parser = charChildParsers.get(el.getTagName());
            if (parser == null) {
                throw new XMLResourceParseException("DefaultTeXFont.xml: a <Char>-element has an unknown child element '" + el.getTagName() + "'!");
            }
            parser.parse(el, ch, info);
        }
    }

    public static void registerFonts(boolean b) {
        shouldRegisterFonts = b;
    }

    public static Font createFont(String name) throws ResourceParseException {
        return DefaultTeXFontParser.createFont(DefaultTeXFontParser.class.getResourceAsStream(name), name);
    }

    public static Font createFont(InputStream fontIn, String name) throws ResourceParseException {
        try {
            Font f;
            block14: {
                f = Font.createFont(0, fontIn).deriveFont(TeXFormula.PIXELS_PER_POINT * TeXFormula.FONT_SCALE_FACTOR);
                GraphicsEnvironment graphicEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
                if (shouldRegisterFonts) {
                    try {
                        Method registerFontMethod = graphicEnv.getClass().getMethod("registerFont", Font.class);
                        if ((Boolean)registerFontMethod.invoke((Object)graphicEnv, f) == Boolean.FALSE) {
                            System.err.println("Cannot register the font " + f.getFontName());
                        }
                    }
                    catch (Exception ex) {
                        if (registerFontExceptionDisplayed) break block14;
                        System.err.println("Warning: Jlatexmath: Could not access to registerFont. Please update to java 6");
                        registerFontExceptionDisplayed = true;
                    }
                }
            }
            Font font = f;
            return font;
        }
        catch (Exception e) {
            throw new XMLResourceParseException("DefaultTeXFont.xml: error reading font '" + name + "'. Error message: " + e.getMessage());
        }
        finally {
            try {
                if (fontIn != null) {
                    fontIn.close();
                }
            }
            catch (IOException ioex) {
                throw new RuntimeException("Close threw exception", ioex);
            }
        }
    }

    public Map<String, CharFont> parseSymbolMappings() throws ResourceParseException {
        HashMap<String, CharFont> res = new HashMap<String, CharFont>();
        Element symbolMappings = (Element)this.root.getElementsByTagName("SymbolMappings").item(0);
        if (symbolMappings == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, "SymbolMappings");
        }
        NodeList list = symbolMappings.getElementsByTagName("Mapping");
        for (int i = 0; i < list.getLength(); ++i) {
            Element map2;
            String include = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("include", (Element)list.item(i));
            try {
                map2 = this.base == null ? factory.newDocumentBuilder().parse(DefaultTeXFontParser.class.getResourceAsStream(include)).getDocumentElement() : factory.newDocumentBuilder().parse(this.base.getClass().getResourceAsStream(include)).getDocumentElement();
            }
            catch (Exception e) {
                throw new XMLResourceParseException("Cannot find the file " + include + "!");
            }
            NodeList listM = map2.getElementsByTagName(SYMBOL_MAPPING_EL);
            for (int j = 0; j < listM.getLength(); ++j) {
                Element mapping = (Element)listM.item(j);
                String symbolName = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("name", mapping);
                int ch = DefaultTeXFontParser.getIntAndCheck("ch", mapping);
                String fontId = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("fontId", mapping);
                String boldFontId = null;
                try {
                    boldFontId = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("boldId", mapping);
                }
                catch (ResourceParseException resourceParseException) {
                    // empty catch block
                }
                if (boldFontId == null) {
                    res.put(symbolName, new CharFont((char)ch, Font_ID.indexOf(fontId)));
                    continue;
                }
                res.put(symbolName, new CharFont((char)ch, Font_ID.indexOf(fontId), Font_ID.indexOf(boldFontId)));
            }
        }
        return res;
    }

    public String[] parseDefaultTextStyleMappings() throws ResourceParseException {
        String[] res = new String[4];
        Element defaultTextStyleMappings = (Element)this.root.getElementsByTagName("DefaultTextStyleMapping").item(0);
        if (defaultTextStyleMappings == null) {
            return res;
        }
        NodeList list = defaultTextStyleMappings.getElementsByTagName("MapStyle");
        for (int i = 0; i < list.getLength(); ++i) {
            int index;
            Element mapping = (Element)list.item(i);
            String code = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("code", mapping);
            Integer codeMapping = rangeTypeMappings.get(code);
            if (codeMapping == null) {
                throw new XMLResourceParseException(RESOURCE_NAME, "MapStyle", "code", "contains an unknown \"range name\" '" + code + "'!");
            }
            String textStyleName = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("textStyle", mapping);
            CharFont[] styleMapping = this.parsedTextStyles.get(textStyleName);
            if (styleMapping == null) {
                throw new XMLResourceParseException(RESOURCE_NAME, "MapStyle", "textStyle", "contains an unknown text style '" + textStyleName + "'!");
            }
            CharFont[] charFonts = this.parsedTextStyles.get(textStyleName);
            if (charFonts[index = codeMapping.intValue()] == null) {
                throw new XMLResourceParseException("DefaultTeXFont.xml: the default text style mapping '" + textStyleName + "' for the range '" + code + "' contains no mapping for that range!");
            }
            res[index] = textStyleName;
        }
        return res;
    }

    public Map<String, Float> parseParameters() throws ResourceParseException {
        HashMap<String, Float> res = new HashMap<String, Float>();
        Element parameters = (Element)this.root.getElementsByTagName("Parameters").item(0);
        if (parameters == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, "Parameters");
        }
        NamedNodeMap list = parameters.getAttributes();
        for (int i = 0; i < list.getLength(); ++i) {
            String name = ((Attr)list.item(i)).getName();
            res.put(name, new Float(DefaultTeXFontParser.getFloatAndCheck(name, parameters)));
        }
        return res;
    }

    public Map<String, Number> parseGeneralSettings() throws ResourceParseException {
        HashMap<String, Number> res = new HashMap<String, Number>();
        Element generalSettings = (Element)this.root.getElementsByTagName(GEN_SET_EL).item(0);
        if (generalSettings == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, GEN_SET_EL);
        }
        res.put(MUFONTID_ATTR, Font_ID.indexOf(DefaultTeXFontParser.getAttrValueAndCheckIfNotNull(MUFONTID_ATTR, generalSettings)));
        res.put(SPACEFONTID_ATTR, Font_ID.indexOf(DefaultTeXFontParser.getAttrValueAndCheckIfNotNull(SPACEFONTID_ATTR, generalSettings)));
        res.put("scriptfactor", Float.valueOf(DefaultTeXFontParser.getFloatAndCheck("scriptfactor", generalSettings)));
        res.put("scriptscriptfactor", Float.valueOf(DefaultTeXFontParser.getFloatAndCheck("scriptscriptfactor", generalSettings)));
        return res;
    }

    public Map<String, CharFont[]> parseTextStyleMappings() {
        return this.parsedTextStyles;
    }

    private Map<String, CharFont[]> parseStyleMappings() throws ResourceParseException {
        HashMap<String, CharFont[]> res = new HashMap<String, CharFont[]>();
        Element textStyleMappings = (Element)this.root.getElementsByTagName("TextStyleMappings").item(0);
        if (textStyleMappings == null) {
            return res;
        }
        NodeList list = textStyleMappings.getElementsByTagName(STYLE_MAPPING_EL);
        for (int i = 0; i < list.getLength(); ++i) {
            Element mapping = (Element)list.item(i);
            String textStyleName = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("name", mapping);
            String boldFontId = null;
            try {
                boldFontId = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("bold", mapping);
            }
            catch (ResourceParseException resourceParseException) {
                // empty catch block
            }
            NodeList mapRangeList = mapping.getElementsByTagName("MapRange");
            CharFont[] charFonts = new CharFont[4];
            for (int j = 0; j < mapRangeList.getLength(); ++j) {
                Element mapRange = (Element)mapRangeList.item(j);
                String fontId = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("fontId", mapRange);
                int ch = DefaultTeXFontParser.getIntAndCheck("start", mapRange);
                String code = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("code", mapRange);
                Integer codeMapping = rangeTypeMappings.get(code);
                if (codeMapping == null) {
                    throw new XMLResourceParseException(RESOURCE_NAME, "MapRange", "code", "contains an unknown \"range name\" '" + code + "'!");
                }
                charFonts[codeMapping.intValue()] = boldFontId == null ? new CharFont((char)ch, Font_ID.indexOf(fontId)) : new CharFont((char)ch, Font_ID.indexOf(fontId), Font_ID.indexOf(boldFontId));
            }
            res.put(textStyleName, charFonts);
        }
        return res;
    }

    private static void setRangeTypeMappings() {
        rangeTypeMappings.put("numbers", 0);
        rangeTypeMappings.put("capitals", 1);
        rangeTypeMappings.put("small", 2);
        rangeTypeMappings.put("unicode", 3);
    }

    private static String getAttrValueAndCheckIfNotNull(String attrName, Element element) throws ResourceParseException {
        String attrValue = element.getAttribute(attrName);
        if (attrValue.equals("")) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getTagName(), attrName, null);
        }
        return attrValue;
    }

    public static float getFloatAndCheck(String attrName, Element element) throws ResourceParseException {
        String attrValue = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull(attrName, element);
        float res = 0.0f;
        try {
            res = (float)Double.parseDouble(attrValue);
        }
        catch (NumberFormatException e) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getTagName(), attrName, "has an invalid real value!");
        }
        return res;
    }

    public static int getIntAndCheck(String attrName, Element element) throws ResourceParseException {
        String attrValue = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull(attrName, element);
        int res = 0;
        try {
            res = Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getTagName(), attrName, "has an invalid integer value!");
        }
        return res;
    }

    public static int getOptionalInt(String attrName, Element element, int defaultValue) throws ResourceParseException {
        String attrValue = element.getAttribute(attrName);
        if (attrValue.equals("")) {
            return defaultValue;
        }
        int res = 0;
        try {
            res = Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getTagName(), attrName, "has an invalid integer value!");
        }
        return res;
    }

    public static float getOptionalFloat(String attrName, Element element, float defaultValue) throws ResourceParseException {
        String attrValue = element.getAttribute(attrName);
        if (attrValue.equals("")) {
            return defaultValue;
        }
        float res = 0.0f;
        try {
            res = (float)Double.parseDouble(attrValue);
        }
        catch (NumberFormatException e) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getTagName(), attrName, "has an invalid float value!");
        }
        return res;
    }

    static {
        DefaultTeXFontParser.setRangeTypeMappings();
        DefaultTeXFontParser.setCharChildParsers();
    }

    private static class NextLargerParser
    implements CharChildParser {
        NextLargerParser() {
        }

        @Override
        public void parse(Element el, char ch, FontInfo info) throws ResourceParseException {
            String fontId = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("fontId", el);
            int code = DefaultTeXFontParser.getIntAndCheck("code", el);
            info.setNextLarger(ch, (char)code, Font_ID.indexOf(fontId));
        }
    }

    private static class LigParser
    implements CharChildParser {
        LigParser() {
        }

        @Override
        public void parse(Element el, char ch, FontInfo info) throws ResourceParseException {
            int code = DefaultTeXFontParser.getIntAndCheck("code", el);
            int ligCode = DefaultTeXFontParser.getIntAndCheck("ligCode", el);
            info.addLigature(ch, (char)code, (char)ligCode);
        }
    }

    private static class KernParser
    implements CharChildParser {
        KernParser() {
        }

        @Override
        public void parse(Element el, char ch, FontInfo info) throws ResourceParseException {
            int code = DefaultTeXFontParser.getIntAndCheck("code", el);
            float kernAmount = DefaultTeXFontParser.getFloatAndCheck("val", el);
            info.addKern(ch, (char)code, kernAmount);
        }
    }

    private static class ExtensionParser
    implements CharChildParser {
        ExtensionParser() {
        }

        @Override
        public void parse(Element el, char ch, FontInfo info) throws ResourceParseException {
            int[] extensionChars = new int[4];
            extensionChars[2] = DefaultTeXFontParser.getIntAndCheck("rep", el);
            extensionChars[0] = DefaultTeXFontParser.getOptionalInt("top", el, -1);
            extensionChars[1] = DefaultTeXFontParser.getOptionalInt("mid", el, -1);
            extensionChars[3] = DefaultTeXFontParser.getOptionalInt("bot", el, -1);
            info.setExtension(ch, extensionChars);
        }
    }

    private static interface CharChildParser {
        public void parse(Element var1, char var2, FontInfo var3) throws XMLResourceParseException;
    }
}

