/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.agents.ideformer.executable;

import ai.grazie.code.agents.ideformer.executable.exception.UnsupportedArchitectureException;
import ai.grazie.code.agents.ideformer.executable.exception.UnsupportedOsException;
import ai.grazie.code.exec.model.DeviceArchitecture;
import ai.grazie.code.exec.model.DeviceOS;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J'\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0016\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u0014\u0010\u0018\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u0014\u0010\u001a\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000bR\u0011\u0010\u001c\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000b\u00a8\u0006("}, d2={"Lai/grazie/code/agents/ideformer/executable/IdeFormerExecutableIdentifier;", "", "version", "", "os", "Lai/grazie/code/exec/model/DeviceOS;", "arch", "Lai/grazie/code/exec/model/DeviceArchitecture;", "<init>", "(Ljava/lang/String;Lai/grazie/code/exec/model/DeviceOS;Lai/grazie/code/exec/model/DeviceArchitecture;)V", "getVersion", "()Ljava/lang/String;", "getOs", "()Lai/grazie/code/exec/model/DeviceOS;", "getArch", "()Lai/grazie/code/exec/model/DeviceArchitecture;", "osIdentifier", "archIdentifier", "extension", "executableBaseName", "executableName", "getExecutableName$code_agents_ideformer_executable", "archiveName", "getArchiveName$code_agents_ideformer_executable", "downloadFile", "getDownloadFile$code_agents_ideformer_executable", "resourceBasePath", "getResourceBasePath$code_agents_ideformer_executable", "resourcePath", "getResourcePath", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "code-agents-ideformer-executable"})
public final class IdeFormerExecutableIdentifier {
    @NotNull
    private final String version;
    @NotNull
    private final DeviceOS os;
    @NotNull
    private final DeviceArchitecture arch;
    @NotNull
    private final String osIdentifier;
    @NotNull
    private final String archIdentifier;
    @NotNull
    private final String extension;
    @NotNull
    private final String executableBaseName;
    @NotNull
    private final String executableName;
    @NotNull
    private final String archiveName;
    @NotNull
    private final String downloadFile;
    @NotNull
    private final String resourceBasePath;
    @NotNull
    private final String resourcePath;

    public IdeFormerExecutableIdentifier(@NotNull String version, @NotNull DeviceOS os, @NotNull DeviceArchitecture arch) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        Intrinsics.checkNotNullParameter((Object)((Object)arch), (String)"arch");
        this.version = version;
        this.os = os;
        this.arch = arch;
        this.osIdentifier = switch (WhenMappings.$EnumSwitchMapping$0[this.os.ordinal()]) {
            case 1 -> "win";
            case 2 -> "mac";
            case 3 -> "linux";
            case 4 -> "unix";
            case 5 -> throw new UnsupportedOsException();
            default -> throw new NoWhenBranchMatchedException();
        };
        this.archIdentifier = switch (WhenMappings.$EnumSwitchMapping$1[this.arch.ordinal()]) {
            case 1 -> "x86";
            case 2 -> "arm64";
            case 3 -> throw new UnsupportedArchitectureException();
            default -> throw new NoWhenBranchMatchedException();
        };
        this.extension = switch (WhenMappings.$EnumSwitchMapping$0[this.os.ordinal()]) {
            case 2 -> ".app";
            case 1 -> ".exe";
            default -> "";
        };
        this.executableBaseName = "ideformer-" + this.version + "-" + this.osIdentifier + "_" + this.archIdentifier;
        this.executableName = this.executableBaseName + this.extension;
        this.archiveName = this.executableName + ".zip";
        this.downloadFile = this.os == DeviceOS.MAC_OS ? this.archiveName : this.executableName;
        this.resourceBasePath = "ideformer-executable/" + this.version + "-" + this.osIdentifier + "_" + this.archIdentifier + "/" + this.executableName;
        this.resourcePath = this.os == DeviceOS.MAC_OS ? this.resourceBasePath + "/Contents/MacOS/" + this.executableBaseName : this.resourceBasePath;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final DeviceOS getOs() {
        return this.os;
    }

    @NotNull
    public final DeviceArchitecture getArch() {
        return this.arch;
    }

    @NotNull
    public final String getExecutableName$code_agents_ideformer_executable() {
        return this.executableName;
    }

    @NotNull
    public final String getArchiveName$code_agents_ideformer_executable() {
        return this.archiveName;
    }

    @NotNull
    public final String getDownloadFile$code_agents_ideformer_executable() {
        return this.downloadFile;
    }

    @NotNull
    public final String getResourceBasePath$code_agents_ideformer_executable() {
        return this.resourceBasePath;
    }

    @NotNull
    public final String getResourcePath() {
        return this.resourcePath;
    }

    @NotNull
    public final String component1() {
        return this.version;
    }

    @NotNull
    public final DeviceOS component2() {
        return this.os;
    }

    @NotNull
    public final DeviceArchitecture component3() {
        return this.arch;
    }

    @NotNull
    public final IdeFormerExecutableIdentifier copy(@NotNull String version, @NotNull DeviceOS os, @NotNull DeviceArchitecture arch) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        Intrinsics.checkNotNullParameter((Object)((Object)arch), (String)"arch");
        return new IdeFormerExecutableIdentifier(version, os, arch);
    }

    public static /* synthetic */ IdeFormerExecutableIdentifier copy$default(IdeFormerExecutableIdentifier ideFormerExecutableIdentifier, String string, DeviceOS deviceOS, DeviceArchitecture deviceArchitecture, int n, Object object) {
        if ((n & 1) != 0) {
            string = ideFormerExecutableIdentifier.version;
        }
        if ((n & 2) != 0) {
            deviceOS = ideFormerExecutableIdentifier.os;
        }
        if ((n & 4) != 0) {
            deviceArchitecture = ideFormerExecutableIdentifier.arch;
        }
        return ideFormerExecutableIdentifier.copy(string, deviceOS, deviceArchitecture);
    }

    @NotNull
    public String toString() {
        return "IdeFormerExecutableIdentifier(version=" + this.version + ", os=" + this.os + ", arch=" + this.arch + ")";
    }

    public int hashCode() {
        int result2 = this.version.hashCode();
        result2 = result2 * 31 + this.os.hashCode();
        result2 = result2 * 31 + this.arch.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IdeFormerExecutableIdentifier)) {
            return false;
        }
        IdeFormerExecutableIdentifier ideFormerExecutableIdentifier = (IdeFormerExecutableIdentifier)other;
        if (!Intrinsics.areEqual((Object)this.version, (Object)ideFormerExecutableIdentifier.version)) {
            return false;
        }
        if (this.os != ideFormerExecutableIdentifier.os) {
            return false;
        }
        return this.arch == ideFormerExecutableIdentifier.arch;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DeviceOS.values().length];
            try {
                nArray[DeviceOS.WINDOWS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceOS.MAC_OS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceOS.LINUX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceOS.UNIX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceOS.UNKNOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DeviceArchitecture.values().length];
            try {
                nArray[DeviceArchitecture.X86_64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceArchitecture.ARM_64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceArchitecture.UNKNOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

