/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.agents.ideformer.executable;

import ai.grazie.code.exec.jvm.JVMDeviceMetadataProvider;
import ai.grazie.code.exec.model.DeviceOS;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\"\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"calculateSHA256Checksum", "", "stream", "Ljava/io/InputStream;", "unzip", "", "Ljava/nio/file/Path;", "dirToExtract", "standardCopyOptions", "", "Ljava/nio/file/CopyOption;", "getStandardCopyOptions", "()[Ljava/nio/file/CopyOption;", "[Ljava/nio/file/CopyOption;", "code-agents-ideformer-executable"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nai/grazie/code/agents/ideformer/executable/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,57:1\n1#2:58\n37#3:59\n36#3,3:60\n*S KotlinDebug\n*F\n+ 1 Utils.kt\nai/grazie/code/agents/ideformer/executable/UtilsKt\n*L\n56#1:59\n56#1:60,3\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final CopyOption[] standardCopyOptions;

    @NotNull
    public static final String calculateSHA256Checksum(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        MessageDigest digest = MessageDigest.getInstance("SHA256");
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while (true) {
            int n;
            int it = n = stream.read(buffer);
            boolean bl = false;
            bytesRead = it;
            if (n == -1) break;
            digest.update(buffer, 0, bytesRead);
        }
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, UtilsKt::calculateSHA256Checksum$lambda$1, (int)30, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unzip(@NotNull Path $this$unzip, @NotNull Path dirToExtract) {
        Intrinsics.checkNotNullParameter((Object)$this$unzip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dirToExtract, (String)"dirToExtract");
        if (JVMDeviceMetadataProvider.INSTANCE.os() == DeviceOS.WINDOWS) {
            String string = "JBAI-11755: Windows is not supported yet";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempDirectory(null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        Path tmpDir = path.toAbsolutePath();
        try {
            String zipFilePath = ((Object)$this$unzip.toAbsolutePath()).toString();
            Object[] objectArray = new String[4];
            objectArray[0] = "unzip";
            objectArray[1] = zipFilePath;
            objectArray[2] = "-d";
            Intrinsics.checkNotNull((Object)tmpDir);
            objectArray[3] = ((Object)tmpDir.toAbsolutePath()).toString();
            Process process = new ProcessBuilder((String[])objectArray).inheritIO().start();
            process.waitFor();
            File file = dirToExtract.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            FilesKt.deleteRecursively((File)file);
            objectArray = standardCopyOptions;
            Files.move(tmpDir, dirToExtract, (CopyOption[])Arrays.copyOf(objectArray, objectArray.length));
        }
        finally {
            File file = tmpDir.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            FilesKt.deleteRecursively((File)file);
        }
    }

    @NotNull
    public static final CopyOption[] getStandardCopyOptions() {
        return standardCopyOptions;
    }

    private static final CharSequence calculateSHA256Checksum$lambda$1(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    static {
        List list2;
        List $this$standardCopyOptions_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$standardCopyOptions_u24lambda_u242.add(StandardCopyOption.REPLACE_EXISTING);
        if (JVMDeviceMetadataProvider.INSTANCE.os() == DeviceOS.MAC_OS) {
            $this$standardCopyOptions_u24lambda_u242.add(StandardCopyOption.ATOMIC_MOVE);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.build((List)list2);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        standardCopyOptions = thisCollection$iv.toArray(new CopyOption[0]);
    }
}

