/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.files.jvm;

import ai.grazie.code.exec.jvm.JVMDeviceMetadataProvider;
import ai.grazie.code.exec.model.DeviceOS;
import ai.grazie.code.files.jvm.JVMFileSystemProvider;
import ai.grazie.code.files.model.FileMetadata;
import ai.grazie.code.files.model.FileSystemProvider;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.PathsJvmKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006J$\u0010\u0007\u001a\u00020\b*\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a8\u0006\u0010"}, d2={"Lai/grazie/code/files/jvm/JVMFileSystemProvider;", "", "<init>", "()V", "contentType", "Lai/grazie/code/files/model/FileMetadata$FileContent;", "Ljava/nio/file/Path;", "isFileHeadTextBased", "", "headMaxSize", "", "charsetsToTry", "", "Ljava/nio/charset/Charset;", "ReadOnly", "ReadWrite", "code-files-jvm"})
@SourceDebugExtension(value={"SMAP\nJVMFileSystemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JVMFileSystemProvider.kt\nai/grazie/code/files/jvm/JVMFileSystemProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1#2:183\n1761#3,3:184\n*S KotlinDebug\n*F\n+ 1 JVMFileSystemProvider.kt\nai/grazie/code/files/jvm/JVMFileSystemProvider\n*L\n178#1:184,3\n*E\n"})
public final class JVMFileSystemProvider {
    @NotNull
    public static final JVMFileSystemProvider INSTANCE = new JVMFileSystemProvider();

    private JVMFileSystemProvider() {
    }

    @NotNull
    public final FileMetadata.FileContent contentType(@NotNull Path $this$contentType) {
        FileMetadata.FileContent fileContent;
        Intrinsics.checkNotNullParameter((Object)$this$contentType, (String)"<this>");
        if (JVMFileSystemProvider.isFileHeadTextBased$default(this, $this$contentType, 0, null, 3, null)) {
            fileContent = FileMetadata.FileContent.Text;
        } else {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            fileContent = Files.isRegularFile($this$contentType, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? FileMetadata.FileContent.Binary : FileMetadata.FileContent.Inapplicable;
        }
        return fileContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFileHeadTextBased(@NotNull Path $this$isFileHeadTextBased, int headMaxSize, @NotNull List<? extends Charset> charsetsToTry) {
        Object object;
        Object $this$isFileHeadTextBased_u24lambda_u244;
        Intrinsics.checkNotNullParameter((Object)$this$isFileHeadTextBased, (String)"<this>");
        Intrinsics.checkNotNullParameter(charsetsToTry, (String)"charsetsToTry");
        Object object2 = $this$isFileHeadTextBased;
        try {
            boolean bl;
            block15: {
                ByteBuffer byteBuffer;
                $this$isFileHeadTextBased_u24lambda_u244 = object2;
                boolean bl2 = false;
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream((Path)$this$isFileHeadTextBased_u24lambda_u244, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                AutoCloseable autoCloseable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream stream = (InputStream)autoCloseable;
                    boolean bl3 = false;
                    byte[] buffer = new byte[headMaxSize];
                    int it = stream.read(buffer, 0, headMaxSize);
                    boolean bl4 = false;
                    byte[] byArray = Arrays.copyOf(buffer, it);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
                    byteBuffer = ByteBuffer.wrap(byArray);
                }
                catch (Throwable bl3) {
                    throwable = bl3;
                    throw bl3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                ByteBuffer headData = byteBuffer;
                Iterable $this$any$iv = charsetsToTry;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Object object3;
                        Charset it = (Charset)element$iv;
                        boolean bl5 = false;
                        Object object4 = $this$isFileHeadTextBased_u24lambda_u244;
                        try {
                            Object $this$isFileHeadTextBased_u24lambda_u244_u24lambda_u243_u24lambda_u242 = object4;
                            boolean bl6 = false;
                            object3 = Result.constructor-impl((Object)it.newDecoder().decode(headData));
                        }
                        catch (Throwable throwable2) {
                            object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                        }
                        if (!Result.isSuccess-impl((Object)object3)) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            $this$isFileHeadTextBased_u24lambda_u244 = Result.constructor-impl((Object)bl);
        }
        catch (Throwable bl2) {
            $this$isFileHeadTextBased_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        object2 = $this$isFileHeadTextBased_u24lambda_u244;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = false;
        }
        return (Boolean)object;
    }

    public static /* synthetic */ boolean isFileHeadTextBased$default(JVMFileSystemProvider jVMFileSystemProvider, Path path, int n, List list2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1024;
        }
        if ((n2 & 2) != 0) {
            list2 = CollectionsKt.listOf((Object)Charsets.UTF_8);
        }
        return jVMFileSystemProvider.isFileHeadTextBased(path, n, list2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\bJ \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0097@\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0017J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\rH\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\rH\u0016J\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\rH\u0002J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006!"}, d2={"Lai/grazie/code/files/jvm/JVMFileSystemProvider$ReadOnly;", "Lai/grazie/code/files/model/FileSystemProvider$ReadOnly;", "Ljava/nio/file/Path;", "<init>", "()V", "metadata", "Lai/grazie/code/files/model/FileMetadata;", "path", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "list", "", "parent", "relative", "", "root", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "relativize", "exists", "", "toPathString", "toAbsolutePathString", "fromAbsoluteString", "fromRelativeString", "base", "name", "extension", "toSystemDependentName", "read", "", "source", "Lkotlinx/io/Source;", "size", "", "code-files-jvm"})
    @SourceDebugExtension(value={"SMAP\nJVMFileSystemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JVMFileSystemProvider.kt\nai/grazie/code/files/jvm/JVMFileSystemProvider$ReadOnly\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
    public static final class ReadOnly
    implements FileSystemProvider.ReadOnly<Path> {
        @NotNull
        public static final ReadOnly INSTANCE = new ReadOnly();

        private ReadOnly() {
        }

        @Override
        @Nullable
        public Object metadata(@NotNull Path path, @NotNull Continuation<? super FileMetadata> $completion) {
            FileMetadata fileMetadata;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isRegularFile(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                fileMetadata = new FileMetadata(FileMetadata.FileType.File, Files.isHidden(path), INSTANCE.contentType(path));
            } else {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                fileMetadata = Files.isDirectory(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) ? new FileMetadata(FileMetadata.FileType.Directory, Files.isHidden(path), INSTANCE.contentType(path)) : null;
            }
            return fileMetadata;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Object list(@NotNull Path path, @NotNull Continuation<? super List<? extends Path>> $completion) {
            Object object;
            Object $this$list_u24lambda_u243;
            Object object2 = this;
            try {
                List list2;
                $this$list_u24lambda_u243 = object2;
                boolean bl = false;
                AutoCloseable autoCloseable = Files.list(path);
                Throwable throwable = null;
                try {
                    Stream it = (Stream)autoCloseable;
                    boolean bl2 = false;
                    list2 = it.sorted((arg_0, arg_1) -> ReadOnly.list$lambda$3$lambda$2$lambda$1(ReadOnly::list$lambda$3$lambda$2$lambda$0, arg_0, arg_1)).toList();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                $this$list_u24lambda_u243 = Result.constructor-impl(list2);
            }
            catch (Throwable bl) {
                $this$list_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = $this$list_u24lambda_u243;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) {
                object = object2;
            } else {
                Throwable it = throwable;
                boolean bl = false;
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        @Override
        @Nullable
        public Object parent(@NotNull Path path, @NotNull Continuation<? super Path> $completion) {
            return path.getParent();
        }

        @Override
        @Deprecated(message="Use relativize instead", replaceWith=@ReplaceWith(expression="relativize(root, path)", imports={}))
        @Nullable
        public Object relative(@NotNull Path root, @NotNull Path path, @NotNull Continuation<? super String> $completion) {
            Path path2 = PathsKt.relativeToOrNull((Path)path, (Path)root);
            return path2 != null && (path2 = path2.normalize()) != null ? ((Object)path2).toString() : null;
        }

        @Override
        @Nullable
        public Object relativize(@NotNull Path root, @NotNull Path path, @NotNull Continuation<? super String> $completion) {
            Path path2 = PathsKt.relativeToOrNull((Path)path, (Path)root);
            return path2 != null && (path2 = path2.normalize()) != null ? ((Object)path2).toString() : null;
        }

        @Override
        @Nullable
        public Object exists(@NotNull Path path, @NotNull Continuation<? super Boolean> $completion) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            return Boxing.boxBoolean((boolean)Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)));
        }

        @Override
        @Deprecated(message="Use toAbsolutePathString instead", replaceWith=@ReplaceWith(expression="toAbsolutePathString(path)", imports={}))
        @NotNull
        public String toPathString(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Path path2 = path.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"normalize(...)");
            return ((Object)path2).toString();
        }

        @Override
        @NotNull
        public String toAbsolutePathString(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Path path2 = path.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"normalize(...)");
            return ((Object)path2.toAbsolutePath()).toString();
        }

        @Override
        @NotNull
        public Path fromAbsoluteString(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Path path2 = Path.of(this.toSystemDependentName(path), new String[0]).normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"normalize(...)");
            return path2;
        }

        @Override
        @NotNull
        public Path fromRelativeString(@NotNull Path base, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Path path2 = base.resolve(path).normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"normalize(...)");
            return path2;
        }

        @Override
        @Nullable
        public Object name(@NotNull Path path, @NotNull Continuation<? super String> $completion) {
            return PathsKt.getName((Path)path);
        }

        @Override
        @Nullable
        public Object extension(@NotNull Path path, @NotNull Continuation<? super String> $completion) {
            return PathsKt.getExtension((Path)path);
        }

        private final String toSystemDependentName(String path) {
            String separator = FileSystems.getDefault().getSeparator();
            Intrinsics.checkNotNull((Object)separator);
            String adjustedPath = StringsKt.replace$default((String)StringsKt.replace$default((String)path, (String)"/", (String)separator, (boolean)false, (int)4, null), (String)"\\", (String)separator, (boolean)false, (int)4, null);
            if (Intrinsics.areEqual((Object)separator, (Object)"\\") && StringsKt.contains$default((CharSequence)adjustedPath, (char)':', (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{'\\'};
                return StringsKt.trimStart((String)adjustedPath, (char[])cArray);
            }
            return adjustedPath;
        }

        @Override
        @Nullable
        public Object read(@NotNull Path path, @NotNull Continuation<? super byte[]> $completion) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isRegularFile(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                boolean $i$a$-require-JVMFileSystemProvider$ReadOnly$read$42 = false;
                String $i$a$-require-JVMFileSystemProvider$ReadOnly$read$42 = "Path must be a regular file";
                throw new IllegalArgumentException($i$a$-require-JVMFileSystemProvider$ReadOnly$read$42.toString());
            }
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.exists(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                boolean bl = false;
                String string = "Path must exist";
                throw new IllegalArgumentException(string.toString());
            }
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>(path, null){
                int label;
                final /* synthetic */ Path $path;
                {
                    this.$path = $path;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            byte[] byArray = Files.readAllBytes(this.$path);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                            return byArray;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super byte[]> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        @Override
        @Nullable
        public Object source(@NotNull Path path, @NotNull Continuation<? super Source> $completion) {
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Source>, Object>(path, null){
                int label;
                final /* synthetic */ Path $path;
                {
                    this.$path = $path;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            return CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source(PathsJvmKt.Path((String)((Object)this.$path).toString())));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Source> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        @Override
        @Nullable
        public Object size(@NotNull Path path, @NotNull Continuation<? super Long> $completion) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isRegularFile(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                boolean $i$a$-require-JVMFileSystemProvider$ReadOnly$size$42 = false;
                String $i$a$-require-JVMFileSystemProvider$ReadOnly$size$42 = "Path must be a regular file";
                throw new IllegalArgumentException($i$a$-require-JVMFileSystemProvider$ReadOnly$size$42.toString());
            }
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.exists(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                boolean bl = false;
                String string = "Path must exist";
                throw new IllegalArgumentException(string.toString());
            }
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(path, null){
                int label;
                final /* synthetic */ Path $path;
                {
                    this.$path = $path;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            return Boxing.boxLong((long)Files.size(this.$path));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Long> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        private static final int list$lambda$3$lambda$2$lambda$0(Path a, Path b) {
            Intrinsics.checkNotNull((Object)a);
            String string = PathsKt.getName((Path)a);
            Intrinsics.checkNotNull((Object)b);
            return string.compareTo(PathsKt.getName((Path)b));
        }

        private static final int list$lambda$3$lambda$2$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0002\u0010\u0019J\u001e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0002H\u0096A\u00a2\u0006\u0002\u0010!J\u0016\u0010\"\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0002H\u0096A\u00a2\u0006\u0002\u0010!J\u0011\u0010#\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\bH\u0096\u0001J\u0019\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\bH\u0096\u0001J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'2\u0006\u0010\u0011\u001a\u00020\u0002H\u0096A\u00a2\u0006\u0002\u0010!J\u0018\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0011\u001a\u00020\u0002H\u0096A\u00a2\u0006\u0002\u0010!J\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0002H\u0096A\u00a2\u0006\u0002\u0010!J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0096A\u00a2\u0006\u0002\u0010!J\u0016\u0010*\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0002H\u0096A\u00a2\u0006\u0002\u0010!J \u0010+\u001a\u0004\u0018\u00010\b2\u0006\u0010,\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0097A\u00a2\u0006\u0002\u0010\u001dJ \u0010-\u001a\u0004\u0018\u00010\b2\u0006\u0010,\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0096A\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010.\u001a\u00020/2\u0006\u0010\u0011\u001a\u00020\u0002H\u0096A\u00a2\u0006\u0002\u0010!J\u0016\u0010\u001b\u001a\u0002002\u0006\u0010\u0011\u001a\u00020\u0002H\u0096A\u00a2\u0006\u0002\u0010!J\u0011\u00101\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0002H\u0096\u0001J\u0011\u00102\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0002H\u0097\u0001R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lai/grazie/code/files/jvm/JVMFileSystemProvider$ReadWrite;", "Lai/grazie/code/files/model/FileSystemProvider$ReadWrite;", "Ljava/nio/file/Path;", "Lai/grazie/code/files/model/FileSystemProvider$ReadOnly;", "<init>", "()V", "WINDOWS_RESERVED_NAMES", "", "", "create", "", "parent", "name", "type", "Lai/grazie/code/files/model/FileMetadata$FileType;", "(Ljava/nio/file/Path;Ljava/lang/String;Lai/grazie/code/files/model/FileMetadata$FileType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "write", "path", "content", "", "(Ljava/nio/file/Path;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sink", "Lkotlinx/io/Sink;", "append", "", "(Ljava/nio/file/Path;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "move", "source", "target", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "delete", "(Ljava/nio/file/Path;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "exists", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "extension", "fromAbsoluteString", "fromRelativeString", "base", "list", "", "metadata", "Lai/grazie/code/files/model/FileMetadata;", "read", "relative", "root", "relativize", "size", "", "Lkotlinx/io/Source;", "toAbsolutePathString", "toPathString", "code-files-jvm"})
    public static final class ReadWrite
    implements FileSystemProvider.ReadWrite<Path>,
    FileSystemProvider.ReadOnly<Path> {
        @NotNull
        public static final ReadWrite INSTANCE = new ReadWrite();
        private final /* synthetic */ ReadOnly $$delegate_0;
        @NotNull
        private static final Set<String> WINDOWS_RESERVED_NAMES;

        private ReadWrite() {
            this.$$delegate_0 = ReadOnly.INSTANCE;
        }

        @Override
        @Nullable
        public Object create(@NotNull Path parent2, @NotNull String name2, @NotNull FileMetadata.FileType type, @NotNull Continuation<? super Unit> $completion) {
            Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(name2, parent2, type, null){
                int label;
                final /* synthetic */ String $name;
                final /* synthetic */ Path $parent;
                final /* synthetic */ FileMetadata.FileType $type;
                {
                    this.$name = $name;
                    this.$parent = $parent;
                    this.$type = $type;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Path path;
                            ResultKt.throwOnFailure((Object)object);
                            if (ReadWrite.access$getWINDOWS_RESERVED_NAMES$p().contains(this.$name) && JVMDeviceMetadataProvider.INSTANCE.os() == DeviceOS.WINDOWS) {
                                throw new IOException("Invalid file name: " + this.$name);
                            }
                            Path file = this.$parent.resolve(this.$name);
                            Intrinsics.checkNotNull((Object)file);
                            PathsKt.createParentDirectories((Path)file, (FileAttribute[])new FileAttribute[0]);
                            switch (create.WhenMappings.$EnumSwitchMapping$0[this.$type.ordinal()]) {
                                case 1: {
                                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                                    Path path2 = Files.createFile(file, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                                    path = path2;
                                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createFile(...)");
                                    break;
                                }
                                case 2: {
                                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                                    Path path3 = Files.createDirectory(file, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                                    path = path3;
                                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectory(...)");
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            return path;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @Override
        @Nullable
        public Object write(@NotNull Path path, @NotNull byte[] content2, @NotNull Continuation<? super Unit> $completion) {
            PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
            Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(path, content2, null){
                int label;
                final /* synthetic */ Path $path;
                final /* synthetic */ byte[] $content;
                {
                    this.$path = $path;
                    this.$content = $content;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            OpenOption[] openOptionArray = new OpenOption[]{};
                            Files.write(this.$path, this.$content, Arrays.copyOf(openOptionArray, openOptionArray.length));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @Override
        @Nullable
        public Object sink(@NotNull Path path, boolean append, @NotNull Continuation<? super Sink> $completion) {
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Sink>, Object>(path, append, null){
                int label;
                final /* synthetic */ Path $path;
                final /* synthetic */ boolean $append;
                {
                    this.$path = $path;
                    this.$append = $append;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            PathsKt.createParentDirectories((Path)this.$path, (FileAttribute[])new FileAttribute[0]);
                            return CoreKt.buffered((RawSink)FileSystemJvmKt.SystemFileSystem.sink(PathsJvmKt.Path((String)((Object)this.$path).toString()), this.$append));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Sink> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        @Override
        @Nullable
        public Object move(@NotNull Path source2, @NotNull Path target, @NotNull Continuation<? super Unit> $completion) {
            Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(source2, target, null){
                int label;
                final /* synthetic */ Path $source;
                final /* synthetic */ Path $target;
                {
                    this.$source = $source;
                    this.$target = $target;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Path path;
                            ResultKt.throwOnFailure((Object)object);
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            if (!Files.isDirectory(this.$source, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                                if (!Files.isRegularFile(this.$source, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) throw new IOException("Source path is neither a file nor a directory: " + this.$source);
                                Path path2 = this.$source;
                                Path path3 = this.$target;
                                CopyOption[] copyOptionArray = new CopyOption[]{};
                                Path path4 = Files.move(path2, path3, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
                                path = path4;
                                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"move(...)");
                                return path;
                            }
                            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(this.$target, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                            AutoCloseable autoCloseable = Files.list(this.$source);
                            Path path5 = this.$target;
                            Throwable throwable = null;
                            try {
                                Stream stream = (Stream)autoCloseable;
                                boolean bl = false;
                                stream.forEach(arg_0 -> move.2.invokeSuspend$lambda$2$lambda$1(arg_0 -> move.2.invokeSuspend$lambda$2$lambda$0(path5, arg_0), arg_0));
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                            }
                            Files.delete(this.$source);
                            path = Unit.INSTANCE;
                            return path;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Unit invokeSuspend$lambda$2$lambda$0(Path $target, Path child) {
                    Intrinsics.checkNotNull((Object)child);
                    Path targetChild = $target.resolve(PathsKt.getName((Path)child));
                    Path path = child;
                    Intrinsics.checkNotNull((Object)targetChild);
                    Path path2 = targetChild;
                    CopyOption[] copyOptionArray = new CopyOption[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.move(path, path2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(...)");
                    return Unit.INSTANCE;
                }

                private static final void invokeSuspend$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
                    $tmp0.invoke(p0);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @Override
        @Nullable
        public Object delete(@NotNull Path parent2, @NotNull String name2, @NotNull Continuation<? super Unit> $completion) {
            Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(parent2, name2, null){
                int label;
                final /* synthetic */ Path $parent;
                final /* synthetic */ String $name;
                {
                    this.$parent = $parent;
                    this.$name = $name;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Path path = this.$parent.resolve(this.$name);
                            Intrinsics.checkNotNull((Object)path);
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                                PathsKt.deleteRecursively((Path)path);
                            } else {
                                Files.delete(path);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @Override
        @Deprecated(message="Use toAbsolutePathString instead", replaceWith=@ReplaceWith(expression="toAbsolutePathString(path)", imports={}))
        @NotNull
        public String toPathString(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.$$delegate_0.toPathString(path);
        }

        @Override
        @NotNull
        public String toAbsolutePathString(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.$$delegate_0.toAbsolutePathString(path);
        }

        @Override
        @NotNull
        public Path fromAbsoluteString(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.$$delegate_0.fromAbsoluteString(path);
        }

        @Override
        @NotNull
        public Path fromRelativeString(@NotNull Path base, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.$$delegate_0.fromRelativeString(base, path);
        }

        @Override
        @Nullable
        public Object name(@NotNull Path path, @NotNull Continuation<? super String> $completion) {
            return this.$$delegate_0.name(path, $completion);
        }

        @Override
        @Nullable
        public Object extension(@NotNull Path path, @NotNull Continuation<? super String> $completion) {
            return this.$$delegate_0.extension(path, $completion);
        }

        @Override
        @Nullable
        public Object metadata(@NotNull Path path, @NotNull Continuation<? super FileMetadata> $completion) {
            return this.$$delegate_0.metadata(path, $completion);
        }

        @Override
        @Nullable
        public Object list(@NotNull Path path, @NotNull Continuation<? super List<? extends Path>> $completion) {
            return this.$$delegate_0.list(path, $completion);
        }

        @Override
        @Nullable
        public Object parent(@NotNull Path path, @NotNull Continuation<? super Path> $completion) {
            return this.$$delegate_0.parent(path, $completion);
        }

        @Override
        @Deprecated(message="Use relativize instead", replaceWith=@ReplaceWith(expression="relativize(root, path)", imports={}))
        @Nullable
        public Object relative(@NotNull Path root, @NotNull Path path, @NotNull Continuation<? super String> $completion) {
            return this.$$delegate_0.relative(root, path, $completion);
        }

        @Override
        @Nullable
        public Object relativize(@NotNull Path root, @NotNull Path path, @NotNull Continuation<? super String> $completion) {
            return this.$$delegate_0.relativize(root, path, $completion);
        }

        @Override
        @Nullable
        public Object exists(@NotNull Path path, @NotNull Continuation<? super Boolean> $completion) {
            return this.$$delegate_0.exists(path, $completion);
        }

        @Override
        @Nullable
        public Object read(@NotNull Path path, @NotNull Continuation<? super byte[]> $completion) {
            return this.$$delegate_0.read(path, $completion);
        }

        @Override
        @Nullable
        public Object source(@NotNull Path path, @NotNull Continuation<? super Source> $completion) {
            return this.$$delegate_0.source(path, $completion);
        }

        @Override
        @Nullable
        public Object size(@NotNull Path path, @NotNull Continuation<? super Long> $completion) {
            return this.$$delegate_0.size(path, $completion);
        }

        public static final /* synthetic */ Set access$getWINDOWS_RESERVED_NAMES$p() {
            return WINDOWS_RESERVED_NAMES;
        }

        static {
            Object[] objectArray = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
            WINDOWS_RESERVED_NAMES = SetsKt.setOf((Object[])objectArray);
        }
    }
}

