/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.embeddings.base;

import ai.koog.embeddings.base.Vector$;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.DoubleSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0004J\u0011\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0000H\u0086\u0004J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0000J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J%\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0001\u00a2\u0006\u0002\b%R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lai/koog/embeddings/base/Vector;", "", "values", "", "", "<init>", "(Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getValues", "()Ljava/util/List;", "dimension", "getDimension", "()I", "isNull", "", "magnitude", "dotProduct", "other", "cosineSimilarity", "euclideanDistance", "component1", "copy", "equals", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$embeddings_base", "Companion", "$serializer", "embeddings-base"})
@SourceDebugExtension(value={"SMAP\nVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vector.kt\nai/koog/embeddings/base/Vector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Vector.kt\nai/koog/embeddings/base/Vector$Companion\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1740#2,3:101\n30#3,11:104\n30#3,11:115\n30#3,11:127\n1#4:126\n*S KotlinDebug\n*F\n+ 1 Vector.kt\nai/koog/embeddings/base/Vector\n*L\n49#1:101,3\n57#1:104,11\n67#1:115,11\n97#1:127,11\n*E\n"})
public final class Vector {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Double> values;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public Vector(@NotNull List<Double> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.values = values;
    }

    @NotNull
    public final List<Double> getValues() {
        return this.values;
    }

    public final int getDimension() {
        return this.values.size();
    }

    public final boolean isNull() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.values;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    double it = ((Number)element$iv).doubleValue();
                    boolean bl2 = false;
                    if (it == 0.0) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final double magnitude() {
        Companion companion = Companion;
        Collection values$iv = this.values;
        boolean $i$f$kahanSum = false;
        double sum$iv = 0.0;
        double compensation$iv = 0.0;
        for (Object value$iv : values$iv) {
            double it = ((Number)value$iv).doubleValue();
            boolean bl = false;
            double y$iv = it * it - compensation$iv;
            double t$iv = sum$iv + y$iv;
            compensation$iv = t$iv - sum$iv - y$iv;
            sum$iv = t$iv;
        }
        return Math.sqrt(sum$iv);
    }

    public final double dotProduct(@NotNull Vector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Companion companion = Companion;
        Collection values$iv = CollectionsKt.zip((Iterable)this.values, (Iterable)other.values);
        boolean $i$f$kahanSum = false;
        double sum$iv = 0.0;
        double compensation$iv = 0.0;
        for (Object value$iv : values$iv) {
            Pair pair = (Pair)value$iv;
            boolean bl = false;
            double a = ((Number)pair.component1()).doubleValue();
            double b = ((Number)pair.component2()).doubleValue();
            double y$iv = a * b - compensation$iv;
            double t$iv = sum$iv + y$iv;
            compensation$iv = t$iv - sum$iv - y$iv;
            sum$iv = t$iv;
        }
        return sum$iv;
    }

    public final double cosineSimilarity(@NotNull Vector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(this.getDimension() == other.getDimension())) {
            boolean bl = false;
            String string = "Vectors must have the same dimension";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.isNull() || other.isNull()) {
            return 0.0;
        }
        return this.dotProduct(other) / (this.magnitude() * other.magnitude());
    }

    public final double euclideanDistance(@NotNull Vector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(this.getDimension() == other.getDimension())) {
            boolean $i$a$-require-Vector$euclideanDistance$22 = false;
            String $i$a$-require-Vector$euclideanDistance$22 = "Vectors must have the same dimension";
            throw new IllegalArgumentException($i$a$-require-Vector$euclideanDistance$22.toString());
        }
        Companion companion = Companion;
        Collection values$iv = CollectionsKt.zip((Iterable)this.values, (Iterable)other.values);
        boolean $i$f$kahanSum = false;
        double sum$iv = 0.0;
        double compensation$iv = 0.0;
        for (Object value$iv : values$iv) {
            Pair pair = (Pair)value$iv;
            boolean bl = false;
            double a = ((Number)pair.component1()).doubleValue();
            double b = ((Number)pair.component2()).doubleValue();
            double it = a - b;
            boolean bl2 = false;
            double y$iv = it * it - compensation$iv;
            double t$iv = sum$iv + y$iv;
            compensation$iv = t$iv - sum$iv - y$iv;
            sum$iv = t$iv;
        }
        return Math.sqrt(sum$iv);
    }

    @NotNull
    public final List<Double> component1() {
        return this.values;
    }

    @NotNull
    public final Vector copy(@NotNull List<Double> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return new Vector(values);
    }

    public static /* synthetic */ Vector copy$default(Vector vector, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = vector.values;
        }
        return vector.copy(list2);
    }

    @NotNull
    public String toString() {
        return "Vector(values=" + this.values + ")";
    }

    public int hashCode() {
        return ((Object)this.values).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector)) {
            return false;
        }
        Vector vector = (Vector)other;
        return Intrinsics.areEqual(this.values, vector.values);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$embeddings_base(Vector self, CompositeEncoder output, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.values);
    }

    public /* synthetic */ Vector(int seen0, List values, SerializationConstructorMarker serializationConstructorMarker) {
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.values = values;
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)DoubleSerializer.INSTANCE))};
        $childSerializers = lazyArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00050\nH\u0082\bJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a8\u0006\u000e"}, d2={"Lai/koog/embeddings/base/Vector$Companion;", "", "<init>", "()V", "kahanSum", "", "T", "values", "", "valueSelector", "Lkotlin/Function1;", "serializer", "Lkotlinx/serialization/KSerializer;", "Lai/koog/embeddings/base/Vector;", "embeddings-base"})
    private static final class Companion {
        private Companion() {
        }

        private final <T> double kahanSum(Collection<? extends T> values, Function1<? super T, Double> valueSelector) {
            boolean $i$f$kahanSum = false;
            double sum = 0.0;
            double compensation = 0.0;
            for (T value : values) {
                double y = ((Number)valueSelector.invoke(value)).doubleValue() - compensation;
                double t = sum + y;
                compensation = t - sum - y;
                sum = t;
            }
            return sum;
        }

        @NotNull
        public final KSerializer<Vector> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

