/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy.fileContentReaders;

import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.fileContentReaders.ContentsRedactor;
import com.intellij.ml.llm.privacy.fileContentReaders.PrivacyReader;
import com.intellij.ml.llm.privacy.fileContentReaders.RedactingPrivacyReaderKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u00020\u0004:\u0001\u000fB\u001b\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u000b\u001a\u00028\u00002\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u000eR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/privacy/fileContentReaders/RedactingPrivacyReader;", "T", "R", "", "", "reader", "Lcom/intellij/ml/llm/privacy/fileContentReaders/PrivacyReader;", "<init>", "(Lcom/intellij/ml/llm/privacy/fileContentReaders/PrivacyReader;)V", "readContentsSafe", "Lcom/intellij/ml/llm/privacy/PrivacySafe;", "entity", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/Object;Lcom/intellij/openapi/project/Project;)Lcom/intellij/ml/llm/privacy/PrivacySafe;", "Companion", "intellij.ml.llm.privacy.shared"})
public final class RedactingPrivacyReader<T, R extends CharSequence> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrivacyReader<T, R> reader;
    @NotNull
    public static final String MESSAGE_BLOCKED_ACCESS = "Tried to access file, but it was blocked by .aiignore: ";
    @NotNull
    public static final String MESSAGE_SUCCESSFUL_ACCESS = "File accessed: ";

    public RedactingPrivacyReader(@NotNull PrivacyReader<T, R> reader) {
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        this.reader = reader;
    }

    @RequiresReadLock
    @NotNull
    public final PrivacySafe<CharSequence> readContentsSafe(T entity, @Nullable Project project) {
        boolean shouldRedact = this.reader.isPrivate(entity, project);
        R unmaskedContents = this.reader.readContentsUnsafe(entity);
        R safeContents = shouldRedact ? (CharSequence)ContentsRedactor.INSTANCE.replaceWithRepeatingPrivacyMessage((CharSequence)unmaskedContents) : unmaskedContents;
        return new PrivacySafe<CharSequence>((CharSequence)safeContents);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/privacy/fileContentReaders/RedactingPrivacyReader$Companion;", "", "<init>", "()V", "MESSAGE_BLOCKED_ACCESS", "", "MESSAGE_SUCCESSFUL_ACCESS", "logFileAccess", "", "filepath", "isSuccessful", "", "intellij.ml.llm.privacy.shared"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresReadLock
        public final void logFileAccess(@NotNull String filepath, boolean isSuccessful) {
            Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
            if (isSuccessful) {
                RedactingPrivacyReaderKt.access$getLog$p().debug(RedactingPrivacyReader.MESSAGE_SUCCESSFUL_ACCESS + filepath);
            } else {
                RedactingPrivacyReaderKt.access$getLog$p().debug(RedactingPrivacyReader.MESSAGE_BLOCKED_ACCESS + filepath);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

