/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.claude.code.monitoring;

import com.intellij.ml.llm.agents.claude.code.protocol.Usage;
import com.intellij.openapi.components.Service;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/agents/claude/code/monitoring/TokenMonitoringService;", "", "<init>", "()V", "sessionStats", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/ml/llm/agents/claude/code/monitoring/TokenMonitoringService$TokenStats;", "updateFromUsage", "", "sessionId", "usage", "Lcom/intellij/ml/llm/agents/claude/code/protocol/Usage;", "getInputTokens", "", "getOutputTokens", "clear", "TokenStats", "intellij.ml.llm.agents.claude.code"})
@SourceDebugExtension(value={"SMAP\nTokenMonitoringService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenMonitoringService.kt\ncom/intellij/ml/llm/agents/claude/code/monitoring/TokenMonitoringService\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n72#2,2:32\n1#3:34\n*S KotlinDebug\n*F\n+ 1 TokenMonitoringService.kt\ncom/intellij/ml/llm/agents/claude/code/monitoring/TokenMonitoringService\n*L\n14#1:32,2\n14#1:34\n*E\n"})
public final class TokenMonitoringService {
    @NotNull
    private final ConcurrentHashMap<String, TokenStats> sessionStats = new ConcurrentHashMap();

    /*
     * WARNING - void declaration
     */
    public final void updateFromUsage(@NotNull String sessionId, @NotNull Usage usage) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        ConcurrentMap concurrentMap = this.sessionStats;
        String key$iv = sessionId;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            TokenStats default$iv = new TokenStats(null, null, 3, null);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        TokenStats stats = (TokenStats)object;
        stats.getInputTokens().addAndGet(usage.getInput_tokens() + usage.getCache_creation_input_tokens());
        stats.getOutputTokens().addAndGet(usage.getOutput_tokens());
    }

    public final int getInputTokens(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Object object = this.sessionStats.get(sessionId);
        return object != null && (object = ((TokenStats)object).getInputTokens()) != null ? ((AtomicInteger)object).get() : 0;
    }

    public final int getOutputTokens(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Object object = this.sessionStats.get(sessionId);
        return object != null && (object = ((TokenStats)object).getOutputTokens()) != null ? ((AtomicInteger)object).get() : 0;
    }

    public final void clear(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        this.sessionStats.remove(sessionId);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/agents/claude/code/monitoring/TokenMonitoringService$TokenStats;", "", "inputTokens", "Ljava/util/concurrent/atomic/AtomicInteger;", "outputTokens", "<init>", "(Ljava/util/concurrent/atomic/AtomicInteger;Ljava/util/concurrent/atomic/AtomicInteger;)V", "getInputTokens", "()Ljava/util/concurrent/atomic/AtomicInteger;", "getOutputTokens", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.agents.claude.code"})
    public static final class TokenStats {
        @NotNull
        private final AtomicInteger inputTokens;
        @NotNull
        private final AtomicInteger outputTokens;

        public TokenStats(@NotNull AtomicInteger inputTokens, @NotNull AtomicInteger outputTokens) {
            Intrinsics.checkNotNullParameter((Object)inputTokens, (String)"inputTokens");
            Intrinsics.checkNotNullParameter((Object)outputTokens, (String)"outputTokens");
            this.inputTokens = inputTokens;
            this.outputTokens = outputTokens;
        }

        public /* synthetic */ TokenStats(AtomicInteger atomicInteger, AtomicInteger atomicInteger2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                atomicInteger = new AtomicInteger(0);
            }
            if ((n & 2) != 0) {
                atomicInteger2 = new AtomicInteger(0);
            }
            this(atomicInteger, atomicInteger2);
        }

        @NotNull
        public final AtomicInteger getInputTokens() {
            return this.inputTokens;
        }

        @NotNull
        public final AtomicInteger getOutputTokens() {
            return this.outputTokens;
        }

        @NotNull
        public final AtomicInteger component1() {
            return this.inputTokens;
        }

        @NotNull
        public final AtomicInteger component2() {
            return this.outputTokens;
        }

        @NotNull
        public final TokenStats copy(@NotNull AtomicInteger inputTokens, @NotNull AtomicInteger outputTokens) {
            Intrinsics.checkNotNullParameter((Object)inputTokens, (String)"inputTokens");
            Intrinsics.checkNotNullParameter((Object)outputTokens, (String)"outputTokens");
            return new TokenStats(inputTokens, outputTokens);
        }

        public static /* synthetic */ TokenStats copy$default(TokenStats tokenStats, AtomicInteger atomicInteger, AtomicInteger atomicInteger2, int n, Object object) {
            if ((n & 1) != 0) {
                atomicInteger = tokenStats.inputTokens;
            }
            if ((n & 2) != 0) {
                atomicInteger2 = tokenStats.outputTokens;
            }
            return tokenStats.copy(atomicInteger, atomicInteger2);
        }

        @NotNull
        public String toString() {
            return "TokenStats(inputTokens=" + this.inputTokens + ", outputTokens=" + this.outputTokens + ")";
        }

        public int hashCode() {
            int result2 = this.inputTokens.hashCode();
            result2 = result2 * 31 + this.outputTokens.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenStats)) {
                return false;
            }
            TokenStats tokenStats = (TokenStats)other;
            if (!Intrinsics.areEqual((Object)this.inputTokens, (Object)tokenStats.inputTokens)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.outputTokens, (Object)tokenStats.outputTokens);
        }

        public TokenStats() {
            this(null, null, 3, null);
        }
    }
}

