/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.claude.code.process;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ml.llm.agents.claude.code.process.ClaudeCodeProcessHandlerKt;
import com.intellij.ml.llm.agents.claude.code.process.Parsing_utilKt;
import com.intellij.ml.llm.agents.claude.code.protocol.ClaudeMessage;
import com.intellij.ml.llm.agents.claude.code.protocol.ExecutionExceptionMessage;
import com.intellij.ml.llm.util.ApplicationUtilKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ApplicationKt;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.system.OS;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0014R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/agents/claude/code/process/ClaudeCodeProcessHandler;", "Lcom/intellij/execution/process/KillableProcessHandler;", "sessionId", "", "cmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "<init>", "(Ljava/lang/String;Lcom/intellij/execution/configurations/GeneralCommandLine;)V", "getSessionId", "()Ljava/lang/String;", "messagesChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/intellij/ml/llm/agents/claude/code/protocol/ClaudeMessage;", "getMessagesChannel", "()Lkotlinx/coroutines/channels/Channel;", "bufferedJsonText", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "readerOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "Companion", "intellij.ml.llm.agents.claude.code"})
public class ClaudeCodeProcessHandler
extends KillableProcessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String sessionId;
    @NotNull
    private final Channel<ClaudeMessage> messagesChannel;
    @NotNull
    private final StringBuilder bufferedJsonText;

    public ClaudeCodeProcessHandler(@Nullable String sessionId, @NotNull GeneralCommandLine cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        super(cmd);
        this.sessionId = sessionId;
        this.messagesChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.bufferedJsonText = new StringBuilder();
        this.addProcessListener(new ProcessListener(){

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                block16: {
                    block15: {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                        if (Registry.Companion.is("llm.chat.agent.claude.code.debug")) {
                            ClaudeCodeProcessHandlerKt.access$getLogger$p().debug("Claude output: '" + event.getText() + "'");
                        } else {
                            ClaudeCodeProcessHandlerKt.access$getLogger$p().trace("Claude output: '" + event.getText() + "'");
                        }
                        if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDERR)) break block15;
                        String string = event.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        if (!StringsKt.startsWith$default((String)string, (String)"[ERROR]", (boolean)false, (int)2, null)) break block16;
                    }
                    Channel<ClaudeMessage> channel = this.getMessagesChannel();
                    String string = event.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    channel.trySend-JP2dKIU((Object)new ExecutionExceptionMessage(null, null, string, 3, null));
                    return;
                }
                if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.SYSTEM)) {
                    return;
                }
                String string = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.startsWith$default((String)string, (String)"[DEBUG]", (boolean)false, (int)2, null)) {
                    return;
                }
                try {
                    String string2 = event.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    String text2 = ClaudeCodeProcessHandlerKt.access$clearAnsi(string2);
                    if (StringsKt.startsWith$default((CharSequence)bufferedJsonText, (CharSequence)"{", (boolean)false, (int)2, null) || ((CharSequence)bufferedJsonText).length() == 0 && StringsKt.startsWith$default((String)text2, (String)"{", (boolean)false, (int)2, null)) {
                        bufferedJsonText.append(text2);
                        String string3 = bufferedJsonText.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                        if (Parsing_utilKt.isCompleteJson(string3)) {
                            String string4 = bufferedJsonText.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                            ClaudeMessage claudeMessage = Parsing_utilKt.parseClaudeMessage(string4);
                            if (claudeMessage == null) {
                                return;
                            }
                            ClaudeMessage message = claudeMessage;
                            this.getMessagesChannel().trySend-JP2dKIU((Object)message);
                            StringsKt.clear((StringBuilder)bufferedJsonText);
                        }
                    }
                }
                catch (Exception e) {
                    Channel<ClaudeMessage> channel = this.getMessagesChannel();
                    String string5 = e.getMessage();
                    if (string5 == null) {
                        string5 = e.toString();
                    }
                    channel.trySend-JP2dKIU((Object)new ExecutionExceptionMessage(null, null, string5, 3, null));
                }
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                StringsKt.clear((StringBuilder)bufferedJsonText);
                SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.getMessagesChannel()), null, (int)1, null);
            }
        });
    }

    @Nullable
    public final String getSessionId() {
        return this.sessionId;
    }

    @NotNull
    public final Channel<ClaudeMessage> getMessagesChannel() {
        return this.messagesChannel;
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"forMostlySilentProcess(...)");
        return options;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u00be\u0001\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0016\b\u0002\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00132\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/agents/claude/code/process/ClaudeCodeProcessHandler$Companion;", "", "<init>", "()V", "startClaudeCode", "Lcom/intellij/ml/llm/agents/claude/code/process/ClaudeCodeProcessHandler;", "binaryPath", "Ljava/nio/file/Path;", "workingDirectory", "prompt", "", "mcpConfig", "sessionId", "permissionPromptTool", "disallowedTools", "", "anthropicBaseUrl", "anthropicAuthToken", "headers", "", "additionalSystemPrompt", "toolReplaces", "permissionMode", "chatSessionId", "intellij.ml.llm.agents.claude.code"})
    @SourceDebugExtension(value={"SMAP\nClaudeCodeProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaudeCodeProcessHandler.kt\ncom/intellij/ml/llm/agents/claude/code/process/ClaudeCodeProcessHandler$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,232:1\n68#2,4:233\n68#2,4:237\n68#2,4:241\n68#2,4:245\n68#2,4:249\n*S KotlinDebug\n*F\n+ 1 ClaudeCodeProcessHandler.kt\ncom/intellij/ml/llm/agents/claude/code/process/ClaudeCodeProcessHandler$Companion\n*L\n114#1:233,4\n120#1:237,4\n126#1:241,4\n132#1:245,4\n202#1:249,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @NotNull
        public final ClaudeCodeProcessHandler startClaudeCode(@NotNull Path binaryPath, @NotNull Path workingDirectory, @Nullable String prompt, @Nullable String mcpConfig, @Nullable String sessionId, @Nullable String permissionPromptTool, @Nullable Collection<String> disallowedTools, @Nullable String anthropicBaseUrl, @Nullable String anthropicAuthToken, @NotNull Map<String, String> headers, @Nullable String additionalSystemPrompt, @Nullable Map<String, String> toolReplaces, @Nullable String permissionMode, @NotNull String chatSessionId) {
            block26: {
                block27: {
                    Intrinsics.checkNotNullParameter((Object)binaryPath, (String)"binaryPath");
                    Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
                    Intrinsics.checkNotNullParameter(headers, (String)"headers");
                    Intrinsics.checkNotNullParameter((Object)chatSessionId, (String)"chatSessionId");
                    var17_15 /* !! */  = new String[]{"-p"};
                    v0 = new GeneralCommandLine().withExePath(binaryPath.toString()).withWorkingDirectory(workingDirectory).withParameters(var17_15 /* !! */ );
                    var17_15 /* !! */  = new String[]{"--verbose", "--output-format", "stream-json"};
                    v1 = v0.withParameters(var17_15 /* !! */ );
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"withParameters(...)");
                    cli = v1;
                    if (!ApplicationKt.getApplication().isInternal() && !ApplicationUtilKt.isNightly((Application)ApplicationKt.getApplication()) && ((var16_17 = (CharSequence)anthropicBaseUrl) == null || var16_17.length() == 0)) {
                        throw new IllegalStateException("Anthropic base URL is not set");
                    }
                    if (OS.CURRENT != OS.Windows) break block26;
                    gitBashEnvName = "CLAUDE_CODE_GIT_BASH_PATH";
                    systemWideBashFromEnv = System.getenv((String)gitBashEnvName);
                    if (systemWideBashFromEnv == null) break block27;
                    $this$trace$iv = ClaudeCodeProcessHandlerKt.access$getLogger$p();
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var24_27 = $this$trace$iv;
                        $i$a$-trace-ClaudeCodeProcessHandler$Companion$startClaudeCode$1 = false;
                        var24_27.trace("Using " + (String)gitBashEnvName + "=" + systemWideBashFromEnv + " from user environment");
                    }
                    var18_31 = cli.withEnvironment((String)gitBashEnvName, systemWideBashFromEnv);
                    Intrinsics.checkNotNull((Object)var18_31);
                    break block26;
                }
                v2 = PathEnvironmentVariableUtil.findInPath((String)"git.exe");
                gitExePath = v2 != null ? v2.toPath() : null;
                $this$trace$iv = ClaudeCodeProcessHandlerKt.access$getLogger$p();
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var24_27 = $this$trace$iv;
                    $i$a$-trace-ClaudeCodeProcessHandler$Companion$startClaudeCode$2 = false;
                    var24_27.trace("Git.exe location is " + (gitExePath != null ? gitExePath.toString() : null));
                }
                if (gitExePath != null) {
                    v3 = gitExePath.getParent();
                    v4 = gitParentDir = v3 != null ? v3.getParent() : null;
                    v5 = v4 != null ? v4.resolve("bin/bash.exe") : null;
                } else {
                    v5 = null;
                }
                bashExePath = v5;
                $this$trace$iv = ClaudeCodeProcessHandlerKt.access$getLogger$p();
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var24_27 = $this$trace$iv;
                    $i$a$-trace-ClaudeCodeProcessHandler$Companion$startClaudeCode$3 = false;
                    v6 = bashExePath;
                    var24_27.trace("bash.exe (from Git) location is " + (v6 != null ? v6.toString() : null));
                }
                if (bashExePath == null) ** GOTO lbl-1000
                v7 = new LinkOption[]{};
                if (Files.exists(bashExePath, Arrays.copyOf(v7, v7.length))) {
                    v8 = bashExePath;
                } else lbl-1000:
                // 2 sources

                {
                    v9 = PathEnvironmentVariableUtil.findInPath((String)"bash.exe");
                    v8 = bashExecutable = v9 != null ? v9.toPath() : null;
                }
                if (bashExecutable != null) {
                    $this$trace$iv = ClaudeCodeProcessHandlerKt.access$getLogger$p();
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var24_27 = $this$trace$iv;
                        $i$a$-trace-ClaudeCodeProcessHandler$Companion$startClaudeCode$4 = false;
                        var24_27.trace("Using " + (String)gitBashEnvName + "=" + bashExecutable);
                    }
                    cli.withEnvironment((String)gitBashEnvName, bashExecutable.toString());
                }
            }
            if (ClaudeCodeProcessHandlerKt.access$getLogger$p().isDebugEnabled() && Registry.Companion.is("llm.chat.agent.claude.code.debug")) {
                gitBashEnvName = new String[]{"--debug"};
                cli.withParameters(gitBashEnvName);
            }
            cli.withEnvironment(ClaudeCodeProcessHandlerKt.getIJ_MCP_AIA_CHAT_ID(), chatSessionId);
            if (sessionId != null) {
                gitBashEnvName = new String[]{"-r", sessionId};
                cli.withParameters(gitBashEnvName);
            }
            if (permissionMode != null) {
                gitBashEnvName = new String[]{"--permission-mode", permissionMode};
                cli.withParameters(gitBashEnvName);
            }
            systemPrompt = new StringBuilder();
            if (additionalSystemPrompt != null) {
                systemPrompt.append(additionalSystemPrompt).append('\n');
            }
            if (toolReplaces != null) {
                toolReplaceMessage = StringsKt.trimMargin$default((String)("\n        |Instead of using your own tools you MUST use the following tools:\n        |" + CollectionsKt.joinToString$default((Iterable)toolReplaces.entrySet(), (CharSequence)"\n", null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, startClaudeCode$lambda$4(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/lang/CharSequence;)(), (int)30, null) + "\n        |\n        |DON'T USE THESE YOUR OWN TOOLS: " + CollectionsKt.joinToString$default((Iterable)toolReplaces.keySet(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "!\n        |You can find the descriptions and parameters in the MCP tools list. \n      "), null, (int)1, null);
                systemPrompt.append((String)toolReplaceMessage).append('\n');
            }
            if (((CharSequence)systemPrompt).length() > 0) {
                toolReplaceMessage = new String[]{"--append-system-prompt", systemPrompt.toString()};
                cli.addParameters(toolReplaceMessage);
            }
            if (anthropicBaseUrl != null) {
                cli.withEnvironment("ANTHROPIC_BASE_URL", anthropicBaseUrl);
            }
            if (anthropicAuthToken != null) {
                cli.withEnvironment("ANTHROPIC_AUTH_TOKEN", anthropicAuthToken);
            }
            if (permissionPromptTool != null) {
                cli.addParameter("--permission-prompt-tool");
                cli.addParameter(permissionPromptTool);
            }
            v10 = disallowedTools;
            v11 = v10 != null ? v10.isEmpty() == false : false;
            if (v11) {
                cli.addParameter("--disallowedTools");
                cli.addParameter(CollectionsKt.joinToString$default((Iterable)disallowedTools, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
            if (mcpConfig != null) {
                cli.addParameter("--strict-mcp-config");
                cli.addParameter("--mcp-config");
                cli.addParameter(mcpConfig + " ");
            }
            if (prompt == null) {
                gitExePath = new String[]{"--input-format", "stream-json"};
                toolReplaceMessage = cli.withParameters(gitExePath);
                Intrinsics.checkNotNull((Object)toolReplaceMessage);
            } else {
                toolReplaceMessage = new String[]{"--", prompt};
                cli.addParameters(toolReplaceMessage);
            }
            if (headers.isEmpty() == false) {
                cli.withEnvironment("ANTHROPIC_CUSTOM_HEADERS", CollectionsKt.joinToString$default((Iterable)headers.entrySet(), (CharSequence)"\n", null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, startClaudeCode$lambda$5(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/lang/CharSequence;)(), (int)30, null));
            }
            if (Registry.Companion.is("llm.chat.agent.claude.code.entrypoint.enabled")) {
                cli.withEnvironment("CLAUDE_CODE_ENTRYPOINT", "claude-jetbrains-ai");
            }
            $this$trace$iv = ClaudeCodeProcessHandlerKt.access$getLogger$p();
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                var24_27 = $this$trace$iv;
                $i$a$-trace-ClaudeCodeProcessHandler$Companion$startClaudeCode$6 = false;
                env = CollectionsKt.joinToString$default((Iterable)cli.getEnvironment().entrySet(), (CharSequence)", ", null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, startClaudeCode$lambda$7$lambda$6(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/lang/CharSequence;)(), (int)30, null);
                var24_27.trace("Running Claude process with command line: " + cli.getCommandLineString() + ", env: " + env);
            }
            $this$startClaudeCode_u24lambda_u248 /* !! */  = var17_15 /* !! */  = new ClaudeCodeProcessHandler(sessionId, cli);
            $i$a$-apply-ClaudeCodeProcessHandler$Companion$startClaudeCode$7 = false;
            $this$startClaudeCode_u24lambda_u248 /* !! */ .startNotify();
            return var17_15 /* !! */ ;
        }

        public static /* synthetic */ ClaudeCodeProcessHandler startClaudeCode$default(Companion companion, Path path, Path path2, String string, String string2, String string3, String string4, Collection collection, String string5, String string6, Map map2, String string7, Map map3, String string8, String string9, int n, Object object) {
            if ((n & 4) != 0) {
                string = null;
            }
            if ((n & 8) != 0) {
                string2 = null;
            }
            if ((n & 0x10) != 0) {
                string3 = null;
            }
            if ((n & 0x20) != 0) {
                string4 = null;
            }
            if ((n & 0x40) != 0) {
                collection = null;
            }
            if ((n & 0x80) != 0) {
                string5 = null;
            }
            if ((n & 0x100) != 0) {
                string6 = null;
            }
            if ((n & 0x200) != 0) {
                map2 = MapsKt.emptyMap();
            }
            if ((n & 0x400) != 0) {
                string7 = null;
            }
            if ((n & 0x800) != 0) {
                map3 = null;
            }
            if ((n & 0x1000) != 0) {
                string8 = null;
            }
            return companion.startClaudeCode(path, path2, string, string2, string3, string4, collection, string5, string6, map2, string7, map3, string8, string9);
        }

        private static final CharSequence startClaudeCode$lambda$4(Map.Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            String original = (String)entry.getKey();
            String replaced = (String)entry.getValue();
            return "* instead of {" + original + "} tool - use {" + replaced + "}";
        }

        private static final CharSequence startClaudeCode$lambda$5(Map.Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            String key = (String)entry.getKey();
            String value2 = (String)entry.getValue();
            return key + ": " + value2;
        }

        private static final CharSequence startClaudeCode$lambda$7$lambda$6(Map.Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            String key = (String)entry.getKey();
            String value2 = (String)entry.getValue();
            return key + "=" + value2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

