/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.wrench.tools;

import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/agents/wrench/tools/SMTRunnerLogger;", "Lcom/intellij/execution/testframework/sm/runner/SMTRunnerEventsAdapter;", "<init>", "()V", "text", "", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "isTerminated", "Lkotlinx/coroutines/CompletableDeferred;", "", "()Lkotlinx/coroutines/CompletableDeferred;", "onTestingStarted", "", "testsRoot", "Lcom/intellij/execution/testframework/sm/runner/SMTestProxy$SMRootTestProxy;", "onTestOutput", "proxy", "Lcom/intellij/execution/testframework/sm/runner/SMTestProxy;", "event", "Lcom/intellij/execution/testframework/sm/runner/events/TestOutputEvent;", "onTestFailed", "test", "onTestFinished", "onTestingFinished", "intellij.ml.llm.agents.wrench"})
@SourceDebugExtension(value={"SMAP\nRunTestsTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunTestsTool.kt\ncom/intellij/ml/llm/agents/wrench/tools/SMTRunnerLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1788#2,4:132\n1788#2,4:136\n1788#2,4:140\n*S KotlinDebug\n*F\n+ 1 RunTestsTool.kt\ncom/intellij/ml/llm/agents/wrench/tools/SMTRunnerLogger\n*L\n120#1:132,4\n121#1:136,4\n122#1:140,4\n*E\n"})
final class SMTRunnerLogger
extends SMTRunnerEventsAdapter {
    @NotNull
    private String text = "";
    @NotNull
    private final CompletableDeferred<Boolean> isTerminated = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.text = string;
    }

    @NotNull
    public final CompletableDeferred<Boolean> isTerminated() {
        return this.isTerminated;
    }

    public void onTestingStarted(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        Intrinsics.checkNotNullParameter((Object)testsRoot, (String)"testsRoot");
        this.text = this.text + "Testing started\n";
    }

    public void onTestOutput(@NotNull SMTestProxy proxy, @NotNull TestOutputEvent event) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.onTestOutput(proxy, event);
    }

    public void onTestFailed(@NotNull SMTestProxy test) {
        DiffHyperlink diffProvider;
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        this.text = this.text + "Test failed: " + test.getName() + "\n";
        String string = test.getErrorMessage();
        if (string == null) {
            string = "N/A";
        }
        this.text = this.text + "  Error: " + string + "\n";
        if (test.getStacktrace() != null) {
            String string2 = test.getStacktrace();
            Intrinsics.checkNotNull((Object)string2);
            this.text = this.text + "  Stacktrace:\n" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)StringsKt.lines((CharSequence)string2), (int)100), (CharSequence)"\n", null, null, (int)0, null, SMTRunnerLogger::onTestFailed$lambda$0, (int)30, null) + "\n";
        }
        if ((diffProvider = test.getDiffViewerProvider()) != null) {
            this.text = this.text + "  Expected: " + diffProvider.getLeft() + "\n";
            this.text = this.text + "  Actual: " + diffProvider.getRight() + "\n";
        }
        this.text = this.text + "\n";
    }

    public void onTestFinished(@NotNull SMTestProxy test) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        if (test.isPassed()) {
            this.text = this.text + "Test passed: " + test.getName() + "\n";
        } else if (test.isIgnored()) {
            this.text = this.text + "Test ignored: " + test.getName() + "\n";
        }
    }

    public void onTestingFinished(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        int n;
        int n2;
        int n3;
        Intrinsics.checkNotNullParameter((Object)testsRoot, (String)"testsRoot");
        List allTests = testsRoot.getAllTests();
        Intrinsics.checkNotNull((Object)allTests);
        Iterable $this$count$iv = allTests;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n3 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                SMTestProxy it = (SMTestProxy)element$iv;
                boolean bl = false;
                if (!it.isPassed() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n3 = count$iv;
        }
        int passedCount = n3;
        Iterable $this$count$iv2 = allTests;
        boolean $i$f$count2 = false;
        if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv2) {
                SMTestProxy it = (SMTestProxy)element$iv;
                boolean bl = false;
                if (!(it.isDefect() && !it.isIgnored()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int failedCount = n2;
        Iterable $this$count$iv3 = allTests;
        boolean $i$f$count3 = false;
        if ($this$count$iv3 instanceof Collection && ((Collection)$this$count$iv3).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv3) {
                SMTestProxy it = (SMTestProxy)element$iv;
                boolean bl = false;
                if (!it.isIgnored() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int ignoredCount = n;
        this.text = this.text + "\nTesting finished\n";
        this.text = this.text + "Results: " + allTests.size() + " total, " + passedCount + " passed, " + failedCount + " failed, " + ignoredCount + " ignored\n";
        if (testsRoot.getDuration() != null) {
            this.text = this.text + "Duration: " + testsRoot.getDuration() + "ms\n";
        }
        this.isTerminated.complete((Object)true);
    }

    private static final CharSequence onTestFailed$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "    " + it;
    }
}

