/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chatInputLanguage;

import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.ml.llm.chatInputLanguage.ChatInputQuoteHandlerKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u000e\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J$\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00192\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J$\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/ChatInputQuoteHandler;", "Lcom/intellij/codeInsight/editorActions/QuoteHandler;", "<init>", "()V", "isClosingQuote", "", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "offset", "", "isOpeningQuote", "hasNonClosedLiteral", "editor", "Lcom/intellij/openapi/editor/Editor;", "isInsideLiteral", "getCodeBlocksRange", "Lkotlin/Pair;", "", "line", "lineOffset", "getCloseRangeOfThisType", "Lcom/intellij/openapi/util/TextRange;", "inputText", "", "getCodeRanges", "", "Lcom/intellij/ml/llm/chatInputLanguage/ChatInputQuoteHandler$CodeRange;", "getQuotePositions", "Lcom/intellij/ml/llm/chatInputLanguage/ChatInputQuoteHandler$QuotePosition;", "getLine", "QuotePosition", "CodeRange", "intellij.ml.llm.chatInputLanguage"})
@SourceDebugExtension(value={"SMAP\nChatInputQuoteHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatInputQuoteHandler.kt\ncom/intellij/ml/llm/chatInputLanguage/ChatInputQuoteHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n774#2:265\n865#2,2:266\n1788#2,4:268\n774#2:273\n865#2,2:274\n1788#2,4:276\n774#2:280\n865#2,2:281\n1788#2,4:283\n1788#2,4:287\n1761#2,3:291\n774#2:294\n865#2,2:295\n774#2:297\n865#2,2:298\n1#3:272\n*S KotlinDebug\n*F\n+ 1 ChatInputQuoteHandler.kt\ncom/intellij/ml/llm/chatInputLanguage/ChatInputQuoteHandler\n*L\n47#1:265\n47#1:266,2\n48#1:268,4\n74#1:273\n74#1:274,2\n75#1:276,4\n102#1:280\n102#1:281,2\n103#1:283,4\n104#1:287,4\n118#1:291,3\n126#1:294\n126#1:295,2\n203#1:297\n203#1:298,2\n*E\n"})
public final class ChatInputQuoteHandler
implements QuoteHandler {
    /*
     * WARNING - void declaration
     */
    public boolean isClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        CharSequence charSequence = iterator.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence inputText = charSequence;
        char currentSymbol = inputText.charAt(offset);
        if (currentSymbol == '\'') {
            Character c = StringsKt.getOrNull((CharSequence)inputText, (int)(offset - 1));
            boolean bl = c != null ? Character.isLetterOrDigit(c.charValue()) : false;
            if (bl) {
                return false;
            }
        }
        Pair<Integer, String> pair = this.getLine(inputText, offset);
        int lineOffset = ((Number)pair.component1()).intValue();
        String currentLine = (String)pair.component2();
        if (ChatInputQuoteHandlerKt.access$getSIMPLE_QUOTE_CHARS$p().contains(Character.valueOf(currentSymbol))) {
            int n;
            void $this$filterTo$iv$iv;
            Pair<Integer, String> pair2 = this.getCodeBlocksRange(currentLine, lineOffset);
            int textRegionOffset = ((Number)pair2.component1()).intValue();
            String textRegion = (String)pair2.component2();
            Iterable $this$filter$iv = this.getQuotePositions(textRegion);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                QuotePosition it = (QuotePosition)element$iv$iv;
                boolean bl = false;
                if (!(it.getChar() == currentSymbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List quotePosition = (List)destination$iv$iv;
            Iterable $this$count$iv = quotePosition;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    QuotePosition it = (QuotePosition)element$iv;
                    boolean bl = false;
                    if (!(it.getStart() < textRegionOffset) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int beforeCount = n;
            return beforeCount % 2 == 1;
        }
        if (ChatInputQuoteHandlerKt.access$getCODE_QUOTE_CHARS$p().contains(Character.valueOf(currentSymbol))) {
            Object v4;
            block10: {
                List<CodeRange> codeRanges = this.getCodeRanges(currentLine);
                Iterable iterable = codeRanges;
                for (Object t : iterable) {
                    CodeRange it = (CodeRange)t;
                    boolean bl = false;
                    if (!it.getRange().contains(lineOffset)) continue;
                    v4 = t;
                    break block10;
                }
                v4 = null;
            }
            CodeRange containerCodeRange = v4;
            if (containerCodeRange != null) {
                int quoteSize = containerCodeRange.getQuote().length();
                return lineOffset >= containerCodeRange.getRange().getEndOffset() - quoteSize;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isOpeningQuote(@NotNull HighlighterIterator iterator, int offset) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        CharSequence charSequence = iterator.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence inputText = charSequence;
        char currentSymbol = inputText.charAt(offset);
        if (currentSymbol == '\'') {
            Character c = StringsKt.getOrNull((CharSequence)inputText, (int)(offset - 1));
            boolean bl = c != null ? Character.isLetterOrDigit(c.charValue()) : false;
            if (bl) {
                return false;
            }
        }
        Pair<Integer, String> pair = this.getLine(inputText, offset);
        int lineOffset = ((Number)pair.component1()).intValue();
        String currentLine = (String)pair.component2();
        if (ChatInputQuoteHandlerKt.access$getSIMPLE_QUOTE_CHARS$p().contains(Character.valueOf(currentSymbol))) {
            int n;
            void $this$filterTo$iv$iv;
            Pair<Integer, String> pair2 = this.getCodeBlocksRange(currentLine, lineOffset);
            int textRegionOffset = ((Number)pair2.component1()).intValue();
            String textRegion = (String)pair2.component2();
            Iterable $this$filter$iv = this.getQuotePositions(textRegion);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                QuotePosition it = (QuotePosition)element$iv$iv;
                boolean bl = false;
                if (!(it.getChar() == currentSymbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List quotePosition = (List)destination$iv$iv;
            Iterable $this$count$iv = quotePosition;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    QuotePosition it = (QuotePosition)element$iv;
                    boolean bl = false;
                    if (!(it.getStart() < textRegionOffset) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int beforeCount = n;
            return beforeCount % 2 == 0;
        }
        if (ChatInputQuoteHandlerKt.access$getCODE_QUOTE_CHARS$p().contains(Character.valueOf(currentSymbol))) {
            int quotesAfterOffset;
            Object v4;
            block10: {
                List<CodeRange> codeRanges = this.getCodeRanges(currentLine);
                Iterable quotePosition = codeRanges;
                for (Object t : quotePosition) {
                    CodeRange it = (CodeRange)t;
                    boolean bl = false;
                    if (!it.getRange().contains(lineOffset)) continue;
                    v4 = t;
                    break block10;
                }
                v4 = null;
            }
            CodeRange containerCodeRange = v4;
            if (containerCodeRange != null) {
                int quoteSize = containerCodeRange.getQuote().length();
                return lineOffset < containerCodeRange.getRange().getStartOffset() + quoteSize;
            }
            TextRange closeRange = this.getCloseRangeOfThisType(currentLine, lineOffset);
            int quotesBeforeOffset = lineOffset - closeRange.getStartOffset();
            return quotesBeforeOffset <= (quotesAfterOffset = closeRange.getEndOffset() - (lineOffset + 1));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasNonClosedLiteral(@NotNull Editor editor2, @Nullable HighlighterIterator iterator, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        String string = editor2.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String inputText = string;
        Pair<Integer, String> pair = this.getLine(inputText, offset);
        int lineOffset = ((Number)pair.component1()).intValue();
        String currentLine = (String)pair.component2();
        char currentSymbol = currentLine.charAt(lineOffset);
        if (ChatInputQuoteHandlerKt.access$getSIMPLE_QUOTE_CHARS$p().contains(Character.valueOf(currentSymbol))) {
            int n;
            int n2;
            void $this$filterTo$iv$iv;
            Pair<Integer, String> pair2 = this.getCodeBlocksRange(currentLine, lineOffset);
            int textRegionOffset = ((Number)pair2.component1()).intValue();
            String textRegion = (String)pair2.component2();
            Iterable $this$filter$iv = this.getQuotePositions(textRegion);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                QuotePosition it = (QuotePosition)element$iv$iv;
                boolean bl = false;
                if (!(it.getChar() == currentSymbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List quotePosition = (List)destination$iv$iv;
            Iterable $this$count$iv = quotePosition;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    QuotePosition it = (QuotePosition)element$iv;
                    boolean bl = false;
                    if (!(it.getStart() < textRegionOffset) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int beforeCount = n2;
            Iterable $this$count$iv2 = quotePosition;
            boolean $i$f$count2 = false;
            if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv2) {
                    QuotePosition it = (QuotePosition)element$iv;
                    boolean bl = false;
                    if (!(it.getStart() > textRegionOffset) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int afterCount = n;
            return (beforeCount + afterCount) % 2 == 0;
        }
        if (ChatInputQuoteHandlerKt.access$getCODE_QUOTE_CHARS$p().contains(Character.valueOf(currentSymbol))) {
            void $this$filterTo$iv$iv;
            CodeRange codeRange;
            CodeRange codeRange2;
            int startPosition;
            Object it;
            block19: {
                CodeRange codeRange3;
                Object v4;
                Object it2;
                List<CodeRange> codeRanges;
                block18: {
                    List<CodeRange> element$iv2;
                    boolean bl;
                    block17: {
                        codeRanges = this.getCodeRanges(currentLine);
                        Iterable $this$any$iv = codeRanges;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (List<CodeRange> element$iv2 : $this$any$iv) {
                                it2 = (CodeRange)((Object)element$iv2);
                                boolean bl2 = false;
                                if (!((CodeRange)it2).getRange().contains(lineOffset)) continue;
                                bl = true;
                                break block17;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return false;
                    }
                    element$iv2 = codeRanges;
                    it2 = element$iv2.listIterator(element$iv2.size());
                    while (it2.hasPrevious()) {
                        Object bl2 = it2.previous();
                        it = (CodeRange)bl2;
                        boolean bl3 = false;
                        if (!(((CodeRange)it).getRange().getEndOffset() <= lineOffset)) continue;
                        v4 = bl2;
                        break block18;
                    }
                    v4 = null;
                }
                startPosition = (codeRange3 = (CodeRange)v4) != null && (codeRange3 = codeRange3.getRange()) != null ? codeRange3.getEndOffset() : 0;
                it2 = codeRanges;
                Iterator bl2 = it2.iterator();
                while (bl2.hasNext()) {
                    it = bl2.next();
                    CodeRange it3 = it;
                    boolean bl = false;
                    if (!(it3.getRange().getStartOffset() > lineOffset)) continue;
                    codeRange2 = it;
                    break block19;
                }
                codeRange2 = null;
            }
            int finishPosition = (codeRange = (CodeRange)codeRange2) != null && (codeRange = codeRange.getRange()) != null ? codeRange.getStartOffset() : currentLine.length();
            String string2 = currentLine.substring(startPosition, finishPosition);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String textRegion = string2;
            Iterable $this$filter$iv = this.getQuotePositions(textRegion);
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                QuotePosition it4 = (QuotePosition)element$iv$iv;
                boolean bl = false;
                if (!(it4.getChar() == currentSymbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List quotesPositions = (List)destination$iv$iv;
            if (quotesPositions.size() > 1) {
                return false;
            }
            TextRange closeRange = this.getCloseRangeOfThisType(currentLine, lineOffset);
            int quotesBeforeOffset = lineOffset - closeRange.getStartOffset();
            int quotesAfterOffset = closeRange.getEndOffset() - (lineOffset + 1);
            return quotesAfterOffset <= quotesBeforeOffset;
        }
        return false;
    }

    public boolean isInsideLiteral(@Nullable HighlighterIterator iterator) {
        return false;
    }

    private final Pair<Integer, String> getCodeBlocksRange(String line, int lineOffset) {
        CodeRange codeRange;
        Object object;
        List<CodeRange> codeRanges;
        block4: {
            codeRanges = this.getCodeRanges(line);
            Iterable iterable = codeRanges;
            for (Object object2 : iterable) {
                CodeRange it = (CodeRange)object2;
                boolean bl = false;
                if (!it.getRange().contains(lineOffset)) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        if ((codeRange = (CodeRange)object) == null || (codeRange = codeRange.getRange()) == null) {
            Object object3;
            int n;
            block6: {
                Object v2;
                CodeRange it;
                Iterator<Object> iterator;
                Object object2;
                block5: {
                    object2 = codeRanges;
                    iterator = object2.listIterator(object2.size());
                    while (iterator.hasPrevious()) {
                        Object e = iterator.previous();
                        it = (CodeRange)e;
                        boolean bl = false;
                        if (!(it.getRange().getEndOffset() <= lineOffset)) continue;
                        v2 = e;
                        break block5;
                    }
                    v2 = null;
                }
                Iterable iterable = codeRanges;
                CodeRange codeRange2 = v2;
                n = codeRange2 != null && (codeRange2 = codeRange2.getRange()) != null ? codeRange2.getEndOffset() : 0;
                object2 = iterable;
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Object object4 = iterator.next();
                    it = (CodeRange)object4;
                    boolean bl = false;
                    if (!(it.getRange().getStartOffset() > lineOffset)) continue;
                    object3 = object4;
                    break block6;
                }
                object3 = null;
            }
            Object object5 = object3;
            CodeRange codeRange3 = (CodeRange)object5;
            int n2 = codeRange3 != null && (codeRange3 = codeRange3.getRange()) != null ? codeRange3.getStartOffset() : line.length();
            int n3 = n;
            codeRange = new TextRange(n3, n2);
        }
        CodeRange currentCodeRange = codeRange;
        String string = line.substring(currentCodeRange.getStartOffset(), currentCodeRange.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String textRegion = string;
        int textRegionOffset = lineOffset - currentCodeRange.getStartOffset();
        return TuplesKt.to((Object)textRegionOffset, (Object)textRegion);
    }

    private final TextRange getCloseRangeOfThisType(CharSequence inputText, int offset) {
        int textLength = inputText.length();
        char charType = inputText.charAt(offset);
        int leftBound = offset;
        int rightBound = offset;
        while (leftBound - 1 >= 0 && inputText.charAt(leftBound - 1) == charType) {
            --leftBound;
        }
        while (rightBound + 1 < textLength && inputText.charAt(rightBound + 1) == charType) {
            ++rightBound;
        }
        TextRange textRange = TextRange.create((int)leftBound, (int)(rightBound + 1));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        return textRange;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CodeRange> getCodeRanges(String inputText) {
        void $this$filterTo$iv$iv;
        boolean bl;
        boolean bl2 = bl = !StringsKt.contains$default((CharSequence)inputText, (CharSequence)"\n", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ChatInputQuoteHandler$getCodeRanges$22 = false;
            String $i$a$-assert-ChatInputQuoteHandler$getCodeRanges$22 = "Input shouldn't be a multi-line string";
            throw new AssertionError((Object)$i$a$-assert-ChatInputQuoteHandler$getCodeRanges$22);
        }
        List ranges = new ArrayList();
        Iterable $this$filter$iv = this.getQuotePositions(inputText);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            QuotePosition it = (QuotePosition)element$iv$iv;
            boolean bl3 = false;
            if (!it.isCodeType()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List quotePositions = (List)destination$iv$iv;
        int startQuote = 0;
        int finishQuote = 0;
        while (startQuote < quotePositions.size()) {
            QuotePosition currentQuote = (QuotePosition)quotePositions.get(startQuote);
            for (finishQuote = startQuote + 1; finishQuote < quotePositions.size() && !Intrinsics.areEqual((Object)((QuotePosition)quotePositions.get(finishQuote)).getQuote(), (Object)currentQuote.getQuote()); ++finishQuote) {
            }
            if (finishQuote < quotePositions.size()) {
                QuotePosition pairedQuote = (QuotePosition)quotePositions.get(finishQuote);
                ranges.add(new CodeRange(new TextRange(currentQuote.getStart(), pairedQuote.getStart() + currentQuote.getQuote().length()), currentQuote.getQuote()));
                startQuote = finishQuote + 1;
                continue;
            }
            ++startQuote;
        }
        return ranges;
    }

    private final List<QuotePosition> getQuotePositions(String inputText) {
        boolean bl;
        boolean bl2 = bl = !StringsKt.contains$default((CharSequence)inputText, (CharSequence)"\n", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ChatInputQuoteHandler$getQuotePositions$22 = false;
            String $i$a$-assert-ChatInputQuoteHandler$getQuotePositions$22 = "Input shouldn't be a multi-line string";
            throw new AssertionError((Object)$i$a$-assert-ChatInputQuoteHandler$getQuotePositions$22);
        }
        List positions = new ArrayList();
        int offset = 0;
        while (offset < inputText.length()) {
            char c = inputText.charAt(offset);
            if (ChatInputQuoteHandlerKt.access$getSIMPLE_QUOTE_CHARS$p().contains(Character.valueOf(c))) {
                positions.add(new QuotePosition(offset, String.valueOf(c)));
                ++offset;
            }
            if (ChatInputQuoteHandlerKt.access$getCODE_QUOTE_CHARS$p().contains(Character.valueOf(c))) {
                int startOffset = offset;
                while (offset < inputText.length() && inputText.charAt(offset) == c) {
                    ++offset;
                }
                positions.add(new QuotePosition(startOffset, StringsKt.repeat((CharSequence)String.valueOf(c), (int)(offset - startOffset))));
            }
            if (ChatInputQuoteHandlerKt.access$getSIMPLE_QUOTE_CHARS$p().contains(Character.valueOf(c)) || ChatInputQuoteHandlerKt.access$getCODE_QUOTE_CHARS$p().contains(Character.valueOf(c))) continue;
            ++offset;
        }
        return positions;
    }

    private final Pair<Integer, String> getLine(CharSequence inputText, int offset) {
        int textLength = inputText.length();
        int leftBound = offset;
        int rightBound = offset;
        while (leftBound - 1 >= 0 && inputText.charAt(leftBound - 1) != '\n') {
            --leftBound;
        }
        while (rightBound + 1 < textLength && inputText.charAt(rightBound + 1) != '\n') {
            ++rightBound;
        }
        return TuplesKt.to((Object)(offset - leftBound), (Object)((Object)inputText.subSequence(leftBound, rightBound + 1)).toString());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/ChatInputQuoteHandler$CodeRange;", "", "range", "Lcom/intellij/openapi/util/TextRange;", "quote", "", "<init>", "(Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;)V", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getQuote", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.chatInputLanguage"})
    private static final class CodeRange {
        @NotNull
        private final TextRange range;
        @NotNull
        private final String quote;

        public CodeRange(@NotNull TextRange range, @NotNull String quote) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)quote, (String)"quote");
            this.range = range;
            this.quote = quote;
        }

        @NotNull
        public final TextRange getRange() {
            return this.range;
        }

        @NotNull
        public final String getQuote() {
            return this.quote;
        }

        @NotNull
        public final TextRange component1() {
            return this.range;
        }

        @NotNull
        public final String component2() {
            return this.quote;
        }

        @NotNull
        public final CodeRange copy(@NotNull TextRange range, @NotNull String quote) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)quote, (String)"quote");
            return new CodeRange(range, quote);
        }

        public static /* synthetic */ CodeRange copy$default(CodeRange codeRange, TextRange textRange, String string, int n, Object object) {
            if ((n & 1) != 0) {
                textRange = codeRange.range;
            }
            if ((n & 2) != 0) {
                string = codeRange.quote;
            }
            return codeRange.copy(textRange, string);
        }

        @NotNull
        public String toString() {
            return "CodeRange(range=" + this.range + ", quote=" + this.quote + ")";
        }

        public int hashCode() {
            int result2 = this.range.hashCode();
            result2 = result2 * 31 + this.quote.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CodeRange)) {
                return false;
            }
            CodeRange codeRange = (CodeRange)other;
            if (!Intrinsics.areEqual((Object)this.range, (Object)codeRange.range)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.quote, (Object)codeRange.quote);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/ChatInputQuoteHandler$QuotePosition;", "", "start", "", "quote", "", "<init>", "(ILjava/lang/String;)V", "getStart", "()I", "getQuote", "()Ljava/lang/String;", "char", "", "getChar", "()C", "isCodeType", "", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "intellij.ml.llm.chatInputLanguage"})
    private static final class QuotePosition {
        private final int start;
        @NotNull
        private final String quote;

        public QuotePosition(int start2, @NotNull String quote) {
            Intrinsics.checkNotNullParameter((Object)quote, (String)"quote");
            this.start = start2;
            this.quote = quote;
        }

        public final int getStart() {
            return this.start;
        }

        @NotNull
        public final String getQuote() {
            return this.quote;
        }

        public final char getChar() {
            return this.quote.charAt(0);
        }

        public final boolean isCodeType() {
            return ChatInputQuoteHandlerKt.access$getCODE_QUOTE_CHARS$p().contains(Character.valueOf(this.getChar()));
        }

        public final int component1() {
            return this.start;
        }

        @NotNull
        public final String component2() {
            return this.quote;
        }

        @NotNull
        public final QuotePosition copy(int start2, @NotNull String quote) {
            Intrinsics.checkNotNullParameter((Object)quote, (String)"quote");
            return new QuotePosition(start2, quote);
        }

        public static /* synthetic */ QuotePosition copy$default(QuotePosition quotePosition, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = quotePosition.start;
            }
            if ((n2 & 2) != 0) {
                string = quotePosition.quote;
            }
            return quotePosition.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "QuotePosition(start=" + this.start + ", quote=" + this.quote + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.start);
            result2 = result2 * 31 + this.quote.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QuotePosition)) {
                return false;
            }
            QuotePosition quotePosition = (QuotePosition)other;
            if (this.start != quotePosition.start) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.quote, (Object)quotePosition.quote);
        }
    }
}

