/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chatInputLanguage;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.ml.llm.chatInputLanguage.psi.ChatInputFile;
import com.intellij.ml.llm.chatInputLanguage.psi.ChatInputTypes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/ChatInputTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "<init>", "()V", "checkAutoPopup", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "charTyped", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.ml.llm.chatInputLanguage"})
public final class ChatInputTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof ChatInputFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        int offset = editor2.getCaretModel().getPrimaryCaret().getOffset();
        PsiElement element2 = ((ChatInputFile)file).findElementAt(offset - 1);
        switch (charTyped) {
            case '/': 
            case '`': {
                if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element2), (Object)ChatInputTypes.CODE_LINE) || Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element2), (Object)ChatInputTypes.CODE_FENCE_END)) {
                    return TypedHandlerDelegate.Result.CONTINUE;
                }
                PsiDocumentManager.getInstance((Project)project2).commitDocument(editor2.getDocument());
                AutoPopupController.getInstance((Project)project2).autoPopupMemberLookup(editor2, null);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        if (charTyped == '#' || charTyped == '@' || ChatInputTypes.REFERENCE_TOKENS.contains(PsiTreeUtilKt.getElementType((PsiElement)element2))) {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(editor2.getDocument());
            AutoPopupController.getInstance((Project)project2).autoPopupMemberLookup(editor2, null);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }
}

