/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chatInputLanguage.commands;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ml.llm.chatInputLanguage.commands.CustomUserCommandsService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ProcessingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/commands/CustomUserChatInputCommandCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "SpaceInsertHandler", "intellij.ml.llm.chatInputLanguage"})
public final class CustomUserChatInputCommandCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (!Registry.Companion.is("llm.chat.input.language.user.commands.enabled")) {
            return;
        }
        double priority = -99.0;
        CustomUserCommandsService service = CustomUserCommandsService.Companion.getInstance();
        Project project2 = parameters.getPosition().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        List<VirtualFile> customCommands = service.getUserCommands(project2);
        for (VirtualFile command : customCommands) {
            String string = command.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String normalizedName = service.normalizeName(string);
            result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)LookupElementBuilder.create((String)normalizedName).withPresentableText("/" + normalizedName).withTypeText(".aiassistant/commands/" + command.getName()).withInsertHandler((InsertHandler)SpaceInsertHandler.INSTANCE)), (double)priority));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/commands/CustomUserChatInputCommandCompletionProvider$SpaceInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "intellij.ml.llm.chatInputLanguage"})
    private static final class SpaceInsertHandler
    implements InsertHandler<LookupElement> {
        @NotNull
        public static final SpaceInsertHandler INSTANCE = new SpaceInsertHandler();

        private SpaceInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            context2.getDocument().insertString(context2.getTailOffset(), (CharSequence)" ");
            context2.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, false);
        }
    }
}

