/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chatInputLanguage.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.ml.llm.chatInputLanguage.ChatInputMessageBundle;
import com.intellij.ml.llm.chatInputLanguage.psi.ChatInputTypes;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/parser/ChatInputParser;", "Lcom/intellij/lang/PsiParser;", "<init>", "()V", "parse", "Lcom/intellij/lang/ASTNode;", "root", "Lcom/intellij/psi/tree/IElementType;", "builder", "Lcom/intellij/lang/PsiBuilder;", "parsePlaintextSegment", "", "parseCodeFence", "parseReference", "parseReferenceValue", "intellij.ml.llm.chatInputLanguage"})
public final class ChatInputParser
implements PsiParser {
    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        PsiBuilder.Marker marker = builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker rootMarker = marker;
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (Intrinsics.areEqual((Object)tokenType, (Object)ChatInputTypes.CODE_FENCE_START)) {
                this.parseCodeFence(builder);
                continue;
            }
            if (Intrinsics.areEqual((Object)tokenType, (Object)ChatInputTypes.REFERENCE_START)) {
                this.parseReference(builder);
                continue;
            }
            if (ChatInputTypes.PLAINTEXT_TOKENS.contains(tokenType)) {
                this.parsePlaintextSegment(builder);
                continue;
            }
            builder.advanceLexer();
        }
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getTreeBuilt(...)");
        return aSTNode;
    }

    private final void parsePlaintextSegment(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker plaintextSegmentMarker = marker;
        while (!builder.eof() && ChatInputTypes.PLAINTEXT_TOKENS.contains(builder.getTokenType())) {
            builder.advanceLexer();
        }
        plaintextSegmentMarker.done(ChatInputTypes.PLAINTEXT_SEGMENT);
    }

    private final void parseCodeFence(PsiBuilder builder) {
        IElementType iElementType;
        IElementType tokenType;
        IElementType iElementType2;
        PsiBuilder.Marker marker = builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker codeFenceMarker = marker;
        builder.advanceLexer();
        IElementType tokenTypeAfterCodeFenceStart = builder.getTokenType();
        if (!builder.eof()) {
            iElementType2 = builder.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType2, (Object)ChatInputTypes.CODE_FENCE_LANGUAGE_ID) || Intrinsics.areEqual((Object)iElementType2, (Object)ChatInputTypes.NEWLINE)) {
                builder.advanceLexer();
            } else {
                codeFenceMarker.done(ChatInputTypes.CODE_FENCE_ELEMENT);
                return;
            }
        }
        if (!builder.eof() && Intrinsics.areEqual((Object)tokenTypeAfterCodeFenceStart, (Object)ChatInputTypes.CODE_FENCE_LANGUAGE_ID)) {
            iElementType2 = builder.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType2, (Object)ChatInputTypes.NEWLINE)) {
                builder.advanceLexer();
            } else {
                if (Intrinsics.areEqual((Object)iElementType2, (Object)ChatInputTypes.CODE_FENCE_END)) {
                    builder.mark().done(ChatInputTypes.CODE_FENCE_CONTENTS_ELEMENT);
                    builder.advanceLexer();
                    codeFenceMarker.done(ChatInputTypes.CODE_FENCE_ELEMENT);
                    return;
                }
                codeFenceMarker.done(ChatInputTypes.CODE_FENCE_ELEMENT);
                return;
            }
        }
        PsiBuilder.Marker marker2 = builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
        PsiBuilder.Marker contentsMarker = marker2;
        while (!(builder.eof() || Intrinsics.areEqual((Object)(tokenType = builder.getTokenType()), (Object)ChatInputTypes.NEWLINE) && Intrinsics.areEqual((Object)builder.lookAhead(1), (Object)ChatInputTypes.CODE_FENCE_END) || Intrinsics.areEqual((Object)(iElementType = tokenType), (Object)ChatInputTypes.CODE_FENCE_END))) {
            if (Intrinsics.areEqual((Object)iElementType, (Object)ChatInputTypes.CODE_LINE) || Intrinsics.areEqual((Object)iElementType, (Object)ChatInputTypes.NEWLINE)) {
                builder.advanceLexer();
                continue;
            }
            builder.error(ChatInputMessageBundle.INSTANCE.message("parsing.error.code.line.or.newline.expected", new Object[0]));
            return;
        }
        contentsMarker.done(ChatInputTypes.CODE_FENCE_CONTENTS_ELEMENT);
        if (!builder.eof() && Intrinsics.areEqual((Object)builder.getTokenType(), (Object)ChatInputTypes.NEWLINE)) {
            builder.advanceLexer();
        }
        if (!builder.eof()) {
            if (Intrinsics.areEqual((Object)builder.getTokenType(), (Object)ChatInputTypes.CODE_FENCE_END)) {
                builder.advanceLexer();
            } else {
                builder.error(ChatInputMessageBundle.INSTANCE.message("parsing.error.code.fence.end.expected", new Object[0]));
                return;
            }
        }
        codeFenceMarker.done(ChatInputTypes.CODE_FENCE_ELEMENT);
    }

    private final void parseReference(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker referenceMarker = marker;
        builder.advanceLexer();
        if (Intrinsics.areEqual((Object)builder.getTokenType(), (Object)ChatInputTypes.REFERENCE_VALUE_DELIMITER) || Intrinsics.areEqual((Object)builder.getTokenType(), (Object)ChatInputTypes.REFERENCE_VALUE)) {
            this.parseReferenceValue(builder);
            referenceMarker.done(ChatInputTypes.REFERENCE_ELEMENT);
            return;
        }
        if (!Intrinsics.areEqual((Object)builder.getTokenType(), (Object)ChatInputTypes.REFERENCE_TYPE)) {
            referenceMarker.done(ChatInputTypes.REFERENCE_ELEMENT);
            return;
        }
        builder.advanceLexer();
        if (!Intrinsics.areEqual((Object)builder.getTokenType(), (Object)ChatInputTypes.REFERENCE_SEPARATOR)) {
            referenceMarker.done(ChatInputTypes.REFERENCE_ELEMENT);
            return;
        }
        builder.advanceLexer();
        this.parseReferenceValue(builder);
        referenceMarker.done(ChatInputTypes.REFERENCE_ELEMENT);
    }

    private final void parseReferenceValue(PsiBuilder builder) {
        boolean referenceHasMultipleWords = Intrinsics.areEqual((Object)builder.getTokenType(), (Object)ChatInputTypes.REFERENCE_VALUE_DELIMITER);
        if (referenceHasMultipleWords) {
            builder.advanceLexer();
        }
        if (!Intrinsics.areEqual((Object)builder.getTokenType(), (Object)ChatInputTypes.REFERENCE_VALUE)) {
            builder.error(ChatInputMessageBundle.INSTANCE.message("parsing.error.reference.value.expected", new Object[0]));
            return;
        }
        builder.advanceLexer();
        if (referenceHasMultipleWords && Intrinsics.areEqual((Object)builder.getTokenType(), (Object)ChatInputTypes.REFERENCE_VALUE_DELIMITER)) {
            builder.advanceLexer();
        }
    }
}

