/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.codeGeneration.AICodeGenerationPromptController;
import com.intellij.ml.llm.codeGeneration.AICodeGenerationUtils;
import com.intellij.ml.llm.codeGeneration.diff.AIDiffUtilKt;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIInEditorDiffViewer;
import com.intellij.ml.llm.codeGeneration.popup.AICodeGenerationPopupActionKt;
import com.intellij.ml.llm.core.chat.actions.codeSnippet.AIAssistantInsertAtCaretActionUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\t\u001a\u0004\u0018\u00010\u0006*\u00020\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ%\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\f\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0013J\u001d\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0016J$\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\f0\u0011J\u001c\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0015J\u001c\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0015J*\u0010\u001b\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0010\u0010!\u001a\u00020\"2\b\u0010\r\u001a\u0004\u0018\u00010\nJ\u0010\u0010#\u001a\u00020$2\b\u0010\r\u001a\u0004\u0018\u00010\nJ \u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u000e\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020*R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/ml/llm/codeGeneration/AICodeGenerationControllerUtils;", "", "<init>", "()V", "AI_CODE_GENERATION_ACTIVE_PROMPT_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/codeGeneration/AICodeGenerationPromptController;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getActivePrompt", "Lcom/intellij/openapi/editor/Editor;", "setActivePrompt", "", "editor", "controller", "disposeActivePrompt", "getRegenerateCallback", "Lkotlin/Function1;", "Lcom/intellij/openapi/actionSystem/DataContext;", "getRegenerateCallback$intellij_ml_llm_codeGeneration", "getStopCallback", "Lkotlin/Function0;", "getStopCallback$intellij_ml_llm_codeGeneration", "addRegenerateCallback", "callback", "addSpecifyCallback", "addStopCallback", "cancelInteraction", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "diffViewer", "Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffViewer;", "getChangesNumber", "", "anyChangesGenerated", "", "setTestPromptController", "disposable", "Lcom/intellij/openapi/Disposable;", "isInEditorMode", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.ml.llm.codeGeneration"})
@ApiStatus.Internal
@StabilityInferred(parameters=0)
public final class AICodeGenerationControllerUtils {
    @NotNull
    public static final AICodeGenerationControllerUtils INSTANCE = new AICodeGenerationControllerUtils();
    @NotNull
    private static Key<AICodeGenerationPromptController> AI_CODE_GENERATION_ACTIVE_PROMPT_KEY;
    public static final int $stable;

    private AICodeGenerationControllerUtils() {
    }

    @Nullable
    public final AICodeGenerationPromptController getActivePrompt(@NotNull Editor $this$getActivePrompt) {
        Intrinsics.checkNotNullParameter((Object)$this$getActivePrompt, (String)"<this>");
        return (AICodeGenerationPromptController)AI_CODE_GENERATION_ACTIVE_PROMPT_KEY.get((UserDataHolder)$this$getActivePrompt);
    }

    public final void setActivePrompt(@NotNull Editor editor2, @Nullable AICodeGenerationPromptController controller2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        editor2.putUserData(AI_CODE_GENERATION_ACTIVE_PROMPT_KEY, (Object)controller2);
        if (controller2 != null) {
            AIAssistantInsertAtCaretActionUtil.INSTANCE.disableInsertAction((Disposable)controller2);
        }
    }

    public final void disposeActivePrompt(@NotNull Editor editor2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            AICodeGenerationPromptController aICodeGenerationPromptController = this.getActivePrompt(editor2);
            if (aICodeGenerationPromptController == null) break block0;
            AICodeGenerationPromptController it = aICodeGenerationPromptController;
            boolean bl = false;
            INSTANCE.setActivePrompt(editor2, null);
            Disposer.dispose((Disposable)it);
        }
    }

    @Nullable
    public final Function1<DataContext, Unit> getRegenerateCallback$intellij_ml_llm_codeGeneration(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        AICodeGenerationPromptController aICodeGenerationPromptController = this.getActivePrompt(editor2);
        return aICodeGenerationPromptController != null ? aICodeGenerationPromptController.getOnRegenerate() : null;
    }

    @Nullable
    public final Function0<Unit> getStopCallback$intellij_ml_llm_codeGeneration(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        AICodeGenerationPromptController aICodeGenerationPromptController = this.getActivePrompt(editor2);
        return aICodeGenerationPromptController != null ? aICodeGenerationPromptController.getOnStop() : null;
    }

    public final void addRegenerateCallback(@NotNull Editor editor2, @NotNull Function1<? super DataContext, Unit> callback) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            AICodeGenerationPromptController aICodeGenerationPromptController = this.getActivePrompt(editor2);
            if (aICodeGenerationPromptController == null) break block0;
            aICodeGenerationPromptController.setOnRegenerate(callback);
        }
    }

    public final void addSpecifyCallback(@NotNull Editor editor2, @NotNull Function0<Unit> callback) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            AICodeGenerationPromptController aICodeGenerationPromptController = this.getActivePrompt(editor2);
            if (aICodeGenerationPromptController == null) break block0;
            aICodeGenerationPromptController.setOnSpecify(callback);
        }
    }

    public final void addStopCallback(@NotNull Editor editor2, @NotNull Function0<Unit> callback) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            AICodeGenerationPromptController aICodeGenerationPromptController = this.getActivePrompt(editor2);
            if (aICodeGenerationPromptController == null) break block0;
            aICodeGenerationPromptController.setOnStop(callback);
        }
    }

    public final void cancelInteraction(@Nullable Project project2, @NotNull Editor editor2, @NotNull DataContext dataContext2, @Nullable AIInEditorDiffViewer diffViewer2) {
        Disposable disposable;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        AIInEditorDiffViewer aIInEditorDiffViewer = diffViewer2;
        if (aIInEditorDiffViewer != null) {
            aIInEditorDiffViewer.discardAllChanges();
        }
        if ((disposable = diffViewer2) != null && (disposable = disposable.getInteraction()) != null) {
            disposable.doCancel(dataContext2);
        }
        Project project3 = project2;
        if (project3 != null) {
            ToolWindow toolWindow;
            Project project4 = project3;
            boolean bl = false;
            ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance(project4).getToolWindow("AI-Based Changed Files");
            if (toolWindow2 != null) {
                toolWindow2.hide(null);
            }
        }
        this.disposeActivePrompt(editor2);
    }

    public final int getChangesNumber(@Nullable Editor editor2) {
        Object object = editor2;
        if (object == null || (object = AIDiffUtilKt.getAIInEditorDiffViewer((Editor)object)) == null) {
            return 0;
        }
        Object diffViewer2 = object;
        return ((AIInEditorDiffViewer)diffViewer2).getRenderer().getRenderedChanges().size();
    }

    public final boolean anyChangesGenerated(@Nullable Editor editor2) {
        return AICodeGenerationUtils.INSTANCE.anyCodeGenerated(editor2) && this.getChangesNumber(editor2) > 0;
    }

    @TestOnly
    public final void setTestPromptController(@NotNull Disposable disposable, @NotNull Editor editor2, @NotNull AICodeGenerationPromptController controller2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)controller2, (String)"controller");
        this.setActivePrompt(editor2, controller2);
        DisposerUtilKt.whenDisposed((Disposable)disposable, () -> AICodeGenerationControllerUtils.setTestPromptController$lambda$2(editor2));
    }

    public final boolean isInEditorMode(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor2 = AICodeGenerationPopupActionKt.getEditor(e);
        return (editor2 != null ? this.getActivePrompt(editor2) : null) != null;
    }

    private static final Unit setTestPromptController$lambda$2(Editor $editor) {
        INSTANCE.setActivePrompt($editor, null);
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"AI_CODE_GENERATION_ACTIVE_PROMPT_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        AI_CODE_GENERATION_ACTIVE_PROMPT_KEY = key;
        $stable = 8;
    }
}

