/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.lang.Language;
import com.intellij.ml.llm.codeGeneration.AICodeGenerationFeatures;
import com.intellij.ml.llm.codeGeneration.CodeGenerationInteraction;
import com.intellij.ml.llm.codeGeneration.CodeGenerationPopupStyle;
import com.intellij.ml.llm.codeGeneration.grazie.fileModification.OriginalUpdatedPrompt;
import com.intellij.ml.llm.codeGeneration.grazie.selectionModification.SelectionModificationPrompt;
import com.intellij.ml.llm.codeGeneration.multifile.context.MultifileInstructionVersion;
import com.intellij.ml.llm.core.chat.session.ChatSourceAction;
import com.intellij.ml.llm.util.NightlyRegistryUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\nJ\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\nJ\u0006\u0010\u0011\u001a\u00020\nJ\u0006\u0010\u0012\u001a\u00020\nJ\u0006\u0010\u0013\u001a\u00020\nJ\u0006\u0010\u0014\u001a\u00020\nJ\u0006\u0010\u0015\u001a\u00020\nJ\u0006\u0010\u0016\u001a\u00020\nJ\u0006\u0010\u0017\u001a\u00020\u0005J\u0006\u0010\u0018\u001a\u00020\nJ\u0006\u0010\u0019\u001a\u00020\nJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\nJ\u0006\u0010\u001d\u001a\u00020\nJ\u0006\u0010\u001e\u001a\u00020\nJ\u0006\u0010\u001f\u001a\u00020\nJ\u0006\u0010 \u001a\u00020\nJ\u0006\u0010!\u001a\u00020\nJ\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020#J\u0006\u0010%\u001a\u00020\nJ\u0006\u0010&\u001a\u00020\nJ\u0006\u0010'\u001a\u00020\nJ\u001e\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0086@\u00a2\u0006\u0002\u0010-J\b\u0010.\u001a\u00020/H\u0007J\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020\n2\u0006\u00107\u001a\u000208\u00a8\u00069"}, d2={"Lcom/intellij/ml/llm/codeGeneration/AICodeGenerationFeatures;", "", "<init>", "()V", "getRelatedFilesLimit", "", "getExcludedActionsForDomainContext", "", "Lcom/intellij/ml/llm/core/chat/session/ChatSourceAction;", "shouldApplyIncompleteUpdates", "", "shouldAppendUnmatchedUpdates", "shouldOpenChatAutomatically", "isGenerationPopupEnabled", "shouldDumpChatInteraction", "shouldOptimizeImports", "shouldFixUnambiguousImports", "isDiffNavigationAvailable", "isDiffNavigationHighlighting", "isLightAgentEnabled", "isLightAgentProjectStructureContextEnabled", "isLightAgentRelatedCodeContextEnabled", "shouldSummarizeLightAgentRelatedCodeContext", "getLightAgentRelatedCodeContextSizeLimit", "isLightAgentMockedCustomContextEnabled", "shouldLightAgentViewBeAvailable", "getCodeGenerationPopupStyle", "Lcom/intellij/ml/llm/codeGeneration/CodeGenerationPopupStyle;", "enableFixWithAI", "rerouteFixWithAIThroughEditMode", "onlySuggestAIFixes", "isCodeGenerationBlock", "shouldDiscardInteractionOnStop", "useXMLPatches", "getCodeSelectionInteraction", "Lcom/intellij/ml/llm/codeGeneration/CodeGenerationInteraction;", "getNoSelectionInteraction", "showNotificationOnNoCodeGenerated", "showComparisonsForModifiedCode", "patchCorrectionStepIsEnabled", "isWholeFileModificationSupported", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOriginalUpdatedPrompt", "Lcom/intellij/ml/llm/codeGeneration/grazie/fileModification/OriginalUpdatedPrompt;", "getMultifileInstruction", "Lcom/intellij/ml/llm/codeGeneration/multifile/context/MultifileInstructionVersion;", "getXMLPatchVersion", "", "getSelectionPrompt", "Lcom/intellij/ml/llm/codeGeneration/grazie/selectionModification/SelectionModificationPrompt;", "isMLInlinePromptDetectionEnabled", "language", "Lcom/intellij/lang/Language;", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nAICodeGenerationFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AICodeGenerationFeatures.kt\ncom/intellij/ml/llm/codeGeneration/AICodeGenerationFeatures\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n295#2,2:207\n295#2,2:209\n*S KotlinDebug\n*F\n+ 1 AICodeGenerationFeatures.kt\ncom/intellij/ml/llm/codeGeneration/AICodeGenerationFeatures\n*L\n128#1:207,2\n133#1:209,2\n*E\n"})
public final class AICodeGenerationFeatures {
    @NotNull
    public static final AICodeGenerationFeatures INSTANCE = new AICodeGenerationFeatures();
    public static final int $stable;

    private AICodeGenerationFeatures() {
    }

    public final int getRelatedFilesLimit() {
        return Registry.Companion.intValue("llm.action.codeGeneration.wholeFile.relatedFilesLimit");
    }

    @NotNull
    public final Set<ChatSourceAction> getExcludedActionsForDomainContext() {
        if (!Registry.Companion.is("llm.action.generateCodeInplace.excludeDomainContext")) {
            return SetsKt.emptySet();
        }
        Object[] objectArray = new ChatSourceAction[]{ChatSourceAction.GENERATE_CODE_INPLACE, ChatSourceAction.GENERATE_CODE_INLINE_PROMPT};
        return SetsKt.setOf((Object[])objectArray);
    }

    public final boolean shouldApplyIncompleteUpdates() {
        return Registry.Companion.is("llm.action.generateCodeInplace.wholeFile.applyIncompleteUpdates");
    }

    public final boolean shouldAppendUnmatchedUpdates() {
        return Registry.Companion.is("llm.action.generateCodeInplace.wholeFile.appendUnmatchedUpdates");
    }

    public final boolean shouldOpenChatAutomatically() {
        return Registry.Companion.is("llm.action.generateCodeInplace.autoOpenChat");
    }

    public final boolean isGenerationPopupEnabled() {
        return Registry.Companion.is("llm.in.editor.generation.popup");
    }

    public final boolean shouldDumpChatInteraction() {
        return Registry.Companion.is("llm.action.codeGeneration.log.dumps");
    }

    public final boolean shouldOptimizeImports() {
        return Registry.Companion.is("llm.action.codeGeneration.optimizeImports");
    }

    public final boolean shouldFixUnambiguousImports() {
        return Registry.Companion.is("llm.ask.ai.auto.import");
    }

    public final boolean isDiffNavigationAvailable() {
        return Registry.Companion.is("llm.code.generation.changes.navigation.buttons");
    }

    public final boolean isDiffNavigationHighlighting() {
        return NightlyRegistryUtils.INSTANCE.isEnabled("llm.code.generation.changes.navigation.highlighting");
    }

    public final boolean isLightAgentEnabled() {
        return ApplicationManager.getApplication().isHeadlessEnvironment() || NightlyRegistryUtils.INSTANCE.isEnabled("llm.code.lightAgent.enabled");
    }

    public final boolean isLightAgentProjectStructureContextEnabled() {
        return Registry.Companion.is("llm.code.lightAgent.context.projectStructure.enabled");
    }

    public final boolean isLightAgentRelatedCodeContextEnabled() {
        return Registry.Companion.is("llm.code.lightAgent.context.relatedCode.enabled");
    }

    public final boolean shouldSummarizeLightAgentRelatedCodeContext() {
        return Registry.Companion.is("llm.code.lightAgent.context.relatedCode.summarize");
    }

    public final int getLightAgentRelatedCodeContextSizeLimit() {
        return Registry.Companion.intValue("llm.code.lightAgent.context.relatedCode.sizeLimit", 100000);
    }

    public final boolean isLightAgentMockedCustomContextEnabled() {
        return Registry.Companion.is("llm.code.lightAgent.context.mockedCustomContext.enabled");
    }

    public final boolean shouldLightAgentViewBeAvailable() {
        return Registry.Companion.is("llm.code.lightAgent.view.enabled");
    }

    @NotNull
    public final CodeGenerationPopupStyle getCodeGenerationPopupStyle() {
        return switch (Registry.Companion.intValue("llm.code.generation.popup.style", 0)) {
            case 1 -> CodeGenerationPopupStyle.STICKY_BOTTOM;
            case 2 -> CodeGenerationPopupStyle.BLOCK_TOP;
            case 3 -> CodeGenerationPopupStyle.SEPARATE_TAB;
            default -> CodeGenerationPopupStyle.STICKY_TOP;
        };
    }

    public final boolean enableFixWithAI() {
        return NightlyRegistryUtils.INSTANCE.isEnabled("llm.fix.with.ai.enabled.nightly");
    }

    public final boolean rerouteFixWithAIThroughEditMode() {
        return Registry.Companion.is("llm.fix.with.ai.use.with.edit.mode");
    }

    public final boolean onlySuggestAIFixes() {
        return Registry.Companion.is("llm.suggest.fix.with.ai");
    }

    public final boolean isCodeGenerationBlock() {
        return this.getCodeGenerationPopupStyle() == CodeGenerationPopupStyle.BLOCK_TOP;
    }

    public final boolean shouldDiscardInteractionOnStop() {
        return Registry.Companion.is("llm.code.generation.discard.followups.on.stop");
    }

    public final boolean useXMLPatches() {
        return Registry.Companion.is("llm.code.lightAgent.xml.patches");
    }

    @NotNull
    public final CodeGenerationInteraction getCodeSelectionInteraction() {
        CodeGenerationInteraction codeGenerationInteraction;
        Object v0;
        block2: {
            String registryValue = Registry.Companion.get("llm.action.generateCodeInplace.interaction.selection").getSelectedOption();
            Iterable $this$firstOrNull$iv = (Iterable)CodeGenerationInteraction.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CodeGenerationInteraction it = (CodeGenerationInteraction)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)registryValue)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((codeGenerationInteraction = (CodeGenerationInteraction)v0) == null) {
            codeGenerationInteraction = CodeGenerationInteraction.NONE;
        }
        return codeGenerationInteraction;
    }

    @NotNull
    public final CodeGenerationInteraction getNoSelectionInteraction() {
        CodeGenerationInteraction codeGenerationInteraction;
        Object v0;
        block2: {
            String registryValue = Registry.Companion.get("llm.action.generateCodeInplace.interaction.noSelection").getSelectedOption();
            Iterable $this$firstOrNull$iv = (Iterable)CodeGenerationInteraction.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CodeGenerationInteraction it = (CodeGenerationInteraction)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)registryValue)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((codeGenerationInteraction = (CodeGenerationInteraction)v0) == null) {
            codeGenerationInteraction = CodeGenerationInteraction.NONE;
        }
        return codeGenerationInteraction;
    }

    public final boolean showNotificationOnNoCodeGenerated() {
        return Registry.Companion.is("llm.code.generation.notification.on.no.code.generated");
    }

    public final boolean showComparisonsForModifiedCode() {
        return Registry.Companion.is("llm.code.generation.show.modified.code");
    }

    public final boolean patchCorrectionStepIsEnabled() {
        return Registry.Companion.is("llm.code.lightAgent.patch.correction.step.enabled");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object isWholeFileModificationSupported(@NotNull Project project, @NotNull Editor editor, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isWholeFileModificationSupported.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AICodeGenerationFeatures this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.isWholeFileModificationSupported(null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                registry = NightlyRegistryUtils.INSTANCE.stringValue("llm.action.generateCodeInplace.wholeFile.enabledLanguages");
                if (Intrinsics.areEqual((Object)registry, (Object)"ALL")) {
                    return Boxing.boxBoolean((boolean)true);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)editor);
                $continuation.L$2 = registry;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isWholeFileModificationSupported$lambda$2(com.intellij.openapi.project.Project com.intellij.openapi.editor.Editor ), ()Lcom/intellij/lang/Language;)((Project)project, (Editor)editor), (Continuation)$continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl29
            }
            case 1: {
                registry = (String)$continuation.L$2;
                editor = (Editor)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                v1 = (Language)v0;
                if (v1 == null) {
                    return Boxing.boxBoolean((boolean)false);
                }
                language = v1;
                var7_9 = new String[]{";"};
                supportedLanguages = StringsKt.split$default((CharSequence)registry, (String[])var7_9, (boolean)false, (int)0, (int)6, null);
                return Boxing.boxBoolean((boolean)supportedLanguages.contains(language.getDisplayName()));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @JvmStatic
    @NotNull
    public static final OriginalUpdatedPrompt getOriginalUpdatedPrompt() {
        String string;
        try {
            string = NightlyRegistryUtils.INSTANCE.stringValue("llm.action.generateCodeInplace.originalUpdatePrompt.versionName");
        }
        catch (Exception exception) {
            string = "";
        }
        String versionName = string;
        return OriginalUpdatedPrompt.Companion.getOrDefault(versionName);
    }

    @NotNull
    public final MultifileInstructionVersion getMultifileInstruction() {
        String registry = Registry.Companion.get("llm.code.generation.multifile.prompt.version").getSelectedOption();
        return MultifileInstructionVersion.Companion.getOrDefault(registry);
    }

    @NotNull
    public final String getXMLPatchVersion() {
        String string = Registry.Companion.get("llm.code.lightAgent.xml.patches.version").getSelectedOption();
        if (string == null) {
            string = "V2";
        }
        return string;
    }

    @NotNull
    public final SelectionModificationPrompt getSelectionPrompt() {
        String versionName = NightlyRegistryUtils.INSTANCE.stringValue("llm.action.generateCodeInplace.selectionPrompt.versionName");
        return SelectionModificationPrompt.Companion.getOrDefault(versionName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMLInlinePromptDetectionEnabled(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        String registry = NightlyRegistryUtils.INSTANCE.stringValue("llm.code.generation.ml.prompt.detection.enabledLanguages");
        if (Intrinsics.areEqual((Object)registry, (Object)"ALL")) {
            return true;
        }
        if (Intrinsics.areEqual((Object)registry, (Object)"NO")) {
            return false;
        }
        String[] stringArray = new String[]{";"};
        List supportedLanguages = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)registry, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (supportedLanguages.contains("JavaScript")) {
            Object[] objectArray = new String[]{"TypeScript", "JavaScript JSX", "TypeScript JSX", "ECMAScript 6", "CoffeeScript", "WXS"};
            List jsDialects = CollectionsKt.listOf((Object[])objectArray);
            supportedLanguages.addAll(jsDialects);
        }
        if (supportedLanguages.contains("SQL")) {
            supportedLanguages.add("Oracle");
        }
        if (supportedLanguages.contains(language.getDisplayName())) return true;
        Language language2 = language.getBaseLanguage();
        if (!CollectionsKt.contains((Iterable)supportedLanguages, (Object)(language2 != null ? language2.getID() : null))) return false;
        return true;
    }

    private static final Language isWholeFileModificationSupported$lambda$2(Project $project, Editor $editor) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)$project).getPsiFile($editor.getDocument());
        return psiFile != null ? psiFile.getLanguage() : null;
    }
}

