/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.multifile.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.idea.AppMode;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIInEditorDiffGutterHandler;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIInEditorDiffRenderer;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIInEditorDiffRendererKt;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.CodeGenerationDiffRenderer;
import com.intellij.ml.llm.codeGeneration.inplace.AIDiffBasedCodeGenerationInteraction;
import com.intellij.ml.llm.codeGeneration.multifile.core.ChangeDiffUtilsKt;
import com.intellij.ml.llm.codeGeneration.multifile.core.applier.LlmDiffChangeApplier;
import com.intellij.ml.llm.codeGeneration.multifile.core.change.LlmDiffChange;
import com.intellij.ml.llm.codeGeneration.multifile.ui.AIDeletedCodeEditorTextField;
import com.intellij.ml.llm.codeGeneration.multifile.ui.AIInsertedCodeInlayRenderer;
import com.intellij.ml.llm.codeGeneration.multifile.ui.AcceptInEditorDiffGutterRenderer;
import com.intellij.ml.llm.codeGeneration.multifile.ui.ChangeInEditorDiffRendererKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ComponentInlayAlignment;
import com.intellij.openapi.editor.ComponentInlayKt;
import com.intellij.openapi.editor.ComponentInlayRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 X2\u00020\u0001:\u0002XYB9\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J(\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b2\u000b\u0010,\u001a\u00070-\u00a2\u0006\u0002\b.2\u000b\u0010/\u001a\u00070-\u00a2\u0006\u0002\b.H\u0002J.\u00100\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u0002022\u0006\u00105\u001a\u000202H\u0002J(\u00106\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u000b072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b2\u0006\u00109\u001a\u00020\fH\u0002J0\u0010:\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0018\u0010;\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u000b072\u0006\u0010<\u001a\u00020\u001bH\u0002J\b\u0010=\u001a\u00020'H\u0002J\b\u0010>\u001a\u00020'H\u0016J\b\u0010?\u001a\u00020)H\u0016J\b\u0010@\u001a\u000202H\u0016J&\u0010A\u001a\u00020'2\u0006\u0010<\u001a\u00020\u001b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010(\u001a\u00020)H\u0002J6\u0010B\u001a\u00020'2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010<\u001a\u00020\u001b2\u000e\u0010C\u001a\n\u0012\u0004\u0012\u00020D\u0018\u00010\u000b2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010FH\u0002J\u0010\u0010G\u001a\u00020'2\u0006\u0010<\u001a\u00020\u001bH\u0002J.\u0010H\u001a\u00020'2\u0006\u0010<\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010I\u001a\u00020)H\u0002J&\u0010J\u001a\u00020'2\u0006\u0010<\u001a\u00020\u001b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010(\u001a\u00020)H\u0002J\u001e\u0010K\u001a\u00020'2\u0006\u0010<\u001a\u00020\u001b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J \u0010L\u001a\u00020M2\u0006\u0010<\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)2\u0006\u0010I\u001a\u00020)H\u0002J\u0010\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020-H\u0002J\"\u0010U\u001a\u00020'2\u0006\u0010V\u001a\u00020M2\u0006\u0010<\u001a\u00020\u001b2\b\b\u0002\u0010W\u001a\u00020)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0018\u0010Q\u001a\u00020R*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bS\u0010T\u00a8\u0006Z"}, d2={"Lcom/intellij/ml/llm/codeGeneration/multifile/ui/ChangeInEditorDiffRenderer;", "Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/CodeGenerationDiffRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "resultDocument", "Lcom/intellij/openapi/editor/Document;", "diffChanges", "", "Lcom/intellij/ml/llm/codeGeneration/multifile/core/change/LlmDiffChange;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileTypes/FileType;Lcom/intellij/openapi/editor/Document;Ljava/util/List;)V", "getResultDocument", "()Lcom/intellij/openapi/editor/Document;", "highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "inlays", "Lcom/intellij/openapi/editor/Inlay;", "gutterOperations", "Lcom/intellij/diff/util/DiffGutterOperation;", "initialDocument", "getInitialDocument", "renderedChanges", "Lcom/intellij/diff/fragments/LineFragment;", "getRenderedChanges", "()Ljava/util/List;", "setRenderedChanges", "(Ljava/util/List;)V", "gutterHandler", "Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffGutterHandler;", "getGutterHandler", "()Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffGutterHandler;", "setGutterHandler", "(Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffGutterHandler;)V", "render", "", "withGutter", "", "doRender", "calculateLineFragments", "currentText", "", "Lcom/intellij/openapi/util/NlsSafe;", "resultText", "createEverythingChanged", "length1", "", "length2", "lines1", "lines2", "calculateDiffChangeRanges", "", "calculateDiffChangeRange", "diffChange", "findMatchingDiffChange", "diffChangeRangeMap", "change", "clear", "dispose", "isAnythingRendered", "getRenderingStartOffset", "renderTransparentModifiedCodeRange", "drawInLineHighlighter", "innerFragments", "Lcom/intellij/diff/fragments/DiffFragment;", "textDiffType", "Lcom/intellij/diff/util/TextDiffType;", "addGutterIcons", "renderDeletedCodeRange", "isModifiedCode", "renderInsertedCodeInlay", "createCommentInlay", "addInsertedCodeInlay", "Lcom/intellij/ui/EditorTextField;", "getAIDeletedCodeEditorTextField", "Lcom/intellij/ml/llm/codeGeneration/multifile/ui/AIDeletedCodeEditorTextField;", "deletedText", "lineIndexes", "Lkotlin/ranges/IntRange;", "getLineIndexes", "(Lcom/intellij/openapi/editor/Document;)Lkotlin/ranges/IntRange;", "setupInsertedCodeInlay", "inlay", "modifiedCode", "Companion", "AIInEditorDiffRendererFactory", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChangeInEditorDiffRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeInEditorDiffRenderer.kt\ncom/intellij/ml/llm/codeGeneration/multifile/ui/ChangeInEditorDiffRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,362:1\n1285#2,2:363\n1299#2,4:365\n1761#2,3:372\n1869#2,2:383\n1869#2,2:385\n1869#2,2:387\n1563#2:389\n1634#2,3:390\n1617#2,9:394\n1869#2:403\n1870#2:405\n1626#2:406\n774#2:407\n865#2,2:408\n536#3:369\n521#3,2:370\n523#3,4:375\n126#4:379\n153#4,3:380\n1#5:393\n1#5:404\n*S KotlinDebug\n*F\n+ 1 ChangeInEditorDiffRenderer.kt\ncom/intellij/ml/llm/codeGeneration/multifile/ui/ChangeInEditorDiffRenderer\n*L\n100#1:363,2\n100#1:365,4\n113#1:372,3\n121#1:383,2\n123#1:385,2\n125#1:387,2\n135#1:389\n135#1:390,3\n201#1:394,9\n201#1:403\n201#1:405\n201#1:406\n201#1:407\n201#1:408,2\n112#1:369\n112#1:370,2\n112#1:375,4\n117#1:379\n117#1:380,3\n201#1:404\n*E\n"})
public final class ChangeInEditorDiffRenderer
implements CodeGenerationDiffRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @Nullable
    private final FileType fileType;
    @NotNull
    private final Document resultDocument;
    @NotNull
    private final List<LlmDiffChange> diffChanges;
    @NotNull
    private final List<RangeHighlighter> highlighters;
    @NotNull
    private final List<Inlay<?>> inlays;
    @NotNull
    private final List<DiffGutterOperation> gutterOperations;
    @NotNull
    private final Document initialDocument;
    @NotNull
    private List<? extends LineFragment> renderedChanges;
    @Nullable
    private AIInEditorDiffGutterHandler gutterHandler;
    public static final int $stable = 8;

    private ChangeInEditorDiffRenderer(Editor editor2, Project project2, FileType fileType2, Document resultDocument, List<? extends LlmDiffChange> diffChanges2) {
        this.editor = editor2;
        this.project = project2;
        this.fileType = fileType2;
        this.resultDocument = resultDocument;
        this.diffChanges = diffChanges2;
        this.highlighters = new ArrayList();
        this.inlays = new ArrayList();
        this.gutterOperations = new ArrayList();
        this.initialDocument = this.resultDocument;
        this.renderedChanges = CollectionsKt.emptyList();
    }

    @NotNull
    public final Document getResultDocument() {
        return this.resultDocument;
    }

    @Override
    @NotNull
    public Document getInitialDocument() {
        return this.initialDocument;
    }

    @Override
    @NotNull
    public List<LineFragment> getRenderedChanges() {
        return this.renderedChanges;
    }

    @Override
    public void setRenderedChanges(@NotNull List<? extends LineFragment> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.renderedChanges = list;
    }

    @Override
    @Nullable
    public AIInEditorDiffGutterHandler getGutterHandler() {
        return this.gutterHandler;
    }

    @Override
    public void setGutterHandler(@Nullable AIInEditorDiffGutterHandler aIInEditorDiffGutterHandler) {
        this.gutterHandler = aIInEditorDiffGutterHandler;
    }

    @Override
    public void render(boolean withGutter) {
        this.clear();
        this.doRender(withGutter);
    }

    private final void doRender(boolean withGutter) {
        String string = this.editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this.resultDocument.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        this.setRenderedChanges(this.calculateLineFragments(string, string2));
        Map<LlmDiffChange, List<LineFragment>> diffChangeRangeMap = this.calculateDiffChangeRanges(this.diffChanges);
        for (LineFragment change : this.getRenderedChanges()) {
            boolean insertedRangeIsEmpty = change.getEndLine1() - change.getStartLine1() == 0;
            boolean deletedRangeIsEmpty = change.getEndLine2() - change.getStartLine2() == 0;
            List<LlmDiffChange> diffChanges2 = this.findMatchingDiffChange(diffChangeRangeMap, change);
            this.createCommentInlay(change, diffChanges2);
            if (!deletedRangeIsEmpty && !insertedRangeIsEmpty) {
                this.renderTransparentModifiedCodeRange(change, diffChanges2, withGutter);
                continue;
            }
            if (!deletedRangeIsEmpty) {
                this.renderDeletedCodeRange(change, withGutter, diffChanges2, false);
                continue;
            }
            if (!insertedRangeIsEmpty) {
                this.renderInsertedCodeInlay(change, diffChanges2, withGutter);
                continue;
            }
            throw new IllegalStateException("Unexpected change, both deleted and inserted ranges are empty");
        }
    }

    private final List<LineFragment> calculateLineFragments(String currentText, String resultText) {
        return StringsKt.isBlank((CharSequence)currentText) ? this.createEverythingChanged(resultText.length(), 0, StringUtil.countNewLines((CharSequence)resultText) + 1, 0) : AIInEditorDiffRendererKt.calculateChanges(resultText, currentText);
    }

    private final List<LineFragment> createEverythingChanged(int length1, int length2, int lines1, int lines2) {
        return CollectionsKt.listOf((Object)new LineFragmentImpl(0, lines1, 0, lines2, 0, length1, 0, length2, null, 256, null));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<LlmDiffChange, List<LineFragment>> calculateDiffChangeRanges(List<? extends LlmDiffChange> diffChanges2) {
        Iterable $this$associateWith$iv = diffChanges2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            LlmDiffChange llmDiffChange = (LlmDiffChange)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            List<LineFragment> list = this.calculateDiffChangeRange((LlmDiffChange)it);
            map2.put(t, list);
        }
        return result$iv;
    }

    private final List<LineFragment> calculateDiffChangeRange(LlmDiffChange diffChange) {
        String string = this.resultDocument.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence initialText = LlmDiffChangeApplier.Companion.rollbackChange(string, diffChange);
        String string2 = this.resultDocument.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        return ChangeDiffUtilsKt.calculateLineFragments(initialText, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LlmDiffChange> findMatchingDiffChange(Map<LlmDiffChange, ? extends List<? extends LineFragment>> diffChangeRangeMap, LineFragment change) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry entry;
        void $this$filterTo$iv$iv;
        int containerStart1 = change.getStartLine1();
        int containerEnd1 = change.getEndLine1();
        Map $this$filter$iv = diffChangeRangeMap;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Map.Entry element$iv$iv;
            block5: {
                entry = element$iv$iv = iterator.next();
                boolean bl2 = false;
                List fragments = (List)entry.getValue();
                Iterable $this$any$iv = fragments;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        LineFragment fragment = (LineFragment)element$iv;
                        boolean bl3 = false;
                        if (!(fragment.getStartLine1() >= containerStart1 && fragment.getEndLine1() <= containerEnd1)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            void it;
            entry = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add((LlmDiffChange)it.getKey());
        }
        return (List)destination$iv$iv;
    }

    private final void clear() {
        RangeHighlighter it;
        Iterable $this$forEach$iv = this.highlighters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (RangeHighlighter)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.highlighters.clear();
        $this$forEach$iv = this.inlays;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Inlay)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this.inlays.clear();
        $this$forEach$iv = this.gutterOperations;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (DiffGutterOperation)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.gutterOperations.clear();
    }

    public void dispose() {
        this.clear();
    }

    @Override
    public boolean isAnythingRendered() {
        return !((Collection)this.highlighters).isEmpty() || !((Collection)this.inlays).isEmpty();
    }

    @Override
    public int getRenderingStartOffset() {
        Inlay it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.highlighters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RangeHighlighter rangeHighlighter = (RangeHighlighter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getStartOffset());
        }
        $this$map$iv = this.inlays;
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Inlay)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getOffset());
        }
        Integer n = (Integer)CollectionsKt.minOrNull((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)));
        return n != null ? n : -1;
    }

    private final void renderTransparentModifiedCodeRange(LineFragment change, List<? extends LlmDiffChange> diffChanges2, boolean withGutter) {
        this.renderDeletedCodeRange(change, withGutter, diffChanges2, true);
        this.drawInLineHighlighter(this.editor, change, change.getInnerFragments(), TextDiffType.INSERTED);
        EditorTextField editorTextField = this.addInsertedCodeInlay(change, false, true);
        if (ApplicationManager.getApplication().isUnitTestMode() || AppMode.isRemoteDevHost()) {
            return;
        }
        this.drawInLineHighlighter(editorTextField.getEditor(), change, change.getInnerFragments(), TextDiffType.DELETED);
        this.setupInsertedCodeInlay(editorTextField, change, true);
    }

    private final void drawInLineHighlighter(Editor editor2, LineFragment change, List<? extends DiffFragment> innerFragments, TextDiffType textDiffType) {
        if (innerFragments == null || editor2 == null || editor2.getDocument().getTextLength() <= 1) {
            return;
        }
        int startLineOffset = Intrinsics.areEqual((Object)textDiffType, (Object)TextDiffType.DELETED) ? 0 : change.getStartOffset2();
        for (DiffFragment diffFragment : innerFragments) {
            TextDiffType textDiffType2 = textDiffType;
            if (textDiffType2 == null) {
                TextDiffType textDiffType3 = DiffUtil.getDiffType((DiffFragment)diffFragment);
                textDiffType2 = textDiffType3;
                Intrinsics.checkNotNullExpressionValue((Object)textDiffType3, (String)"getDiffType(...)");
            }
            TextDiffType innerDiffType = textDiffType2;
            int startOffset = Intrinsics.areEqual((Object)textDiffType, (Object)TextDiffType.DELETED) ? diffFragment.getStartOffset1() : diffFragment.getStartOffset2();
            int endOffset = Intrinsics.areEqual((Object)textDiffType, (Object)TextDiffType.DELETED) ? diffFragment.getEndOffset1() : diffFragment.getEndOffset2();
            int coercedStartOffset = RangesKt.coerceIn((int)(startOffset + startLineOffset), (ClosedRange)((ClosedRange)new IntRange(0, editor2.getDocument().getTextLength() - 1)));
            int coercedEndOffset = RangesKt.coerceIn((int)(startLineOffset + endOffset), (ClosedRange)((ClosedRange)new IntRange(coercedStartOffset, editor2.getDocument().getTextLength() - 1)));
            List it = DiffDrawUtil.createInlineHighlighter((Editor)editor2, (int)coercedStartOffset, (int)coercedEndOffset, (TextDiffType)innerDiffType);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.highlighters.addAll(it);
        }
    }

    static /* synthetic */ void drawInLineHighlighter$default(ChangeInEditorDiffRenderer changeInEditorDiffRenderer, Editor editor2, LineFragment lineFragment, List list, TextDiffType textDiffType, int n, Object object) {
        if ((n & 8) != 0) {
            textDiffType = null;
        }
        changeInEditorDiffRenderer.drawInLineHighlighter(editor2, lineFragment, list, textDiffType);
    }

    private final void addGutterIcons(LineFragment change) {
        DiffGutterOperation.Simple simple;
        DiffGutterOperation.Simple it = simple = new DiffGutterOperation.Simple(this.editor, change.getStartOffset2(), () -> ChangeInEditorDiffRenderer.addGutterIcons$lambda$10(change, this));
        boolean bl = false;
        this.gutterOperations.add((DiffGutterOperation)it);
        simple.update(true);
    }

    private final void renderDeletedCodeRange(LineFragment change, boolean withGutter, List<? extends LlmDiffChange> diffChanges2, boolean isModifiedCode) {
        if (withGutter) {
            this.addGutterIcons(change);
        }
        List it = new DiffDrawUtil.LineHighlighterBuilder(this.editor, change.getStartLine2(), change.getEndLine2(), TextDiffType.DELETED).withIgnored(change.getInnerFragments() != null && isModifiedCode).withGutterMode(new DiffDrawUtil.PaintMode(DiffDrawUtil.BackgroundType.NONE, DiffDrawUtil.BorderType.NONE)).withClearThinLineBetweenGutterAndEditor(true).done();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        this.highlighters.addAll(it);
    }

    private final void renderInsertedCodeInlay(LineFragment change, List<? extends LlmDiffChange> diffChanges2, boolean withGutter) {
        EditorTextField editorTextField = this.addInsertedCodeInlay(change, withGutter, false);
        if (ApplicationManager.getApplication().isUnitTestMode() || AppMode.isRemoteDevHost()) {
            return;
        }
        ChangeInEditorDiffRenderer.setupInsertedCodeInlay$default(this, editorTextField, change, false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void createCommentInlay(LineFragment change, List<? extends LlmDiffChange> diffChanges2) {
        block3: {
            Inlay commentInlay;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = diffChanges2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            SimpleColoredComponent $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                LlmDiffChange it = (LlmDiffChange)element$iv$iv;
                boolean bl2 = false;
                if (it.getComment() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            $this$forEach$iv$iv$iv = $this$filterTo$iv$iv.iterator();
            while ($this$forEach$iv$iv$iv.hasNext()) {
                Object element$iv$iv = $this$forEach$iv$iv$iv.next();
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl4 = ((CharSequence)it).length() > 0;
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String comment = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            if (((CharSequence)comment).length() == 0) {
                return;
            }
            int endLine = change.getStartLine2();
            Pair pair = change.getEndLine2() != this.editor.getDocument().getLineCount() ? TuplesKt.to((Object)(endLine - 1), (Object)false) : (change.getEndLine2() != 0 ? TuplesKt.to((Object)(endLine - 1), (Object)false) : TuplesKt.to((Object)0, (Object)false));
            int inlayLine = ((Number)pair.component1()).intValue();
            boolean isAbove = (Boolean)pair.component2();
            SimpleColoredComponent $this$createCommentInlay_u24lambda_u2415 = $this$forEach$iv$iv$iv = new SimpleColoredComponent();
            boolean bl = false;
            $this$createCommentInlay_u24lambda_u2415.setBorder(JBUI.Borders.empty((int)5));
            $this$createCommentInlay_u24lambda_u2415.append(comment, new SimpleTextAttributes(2, (Color)ChangeInEditorDiffRendererKt.getAI_INLAY_TEXT_COLOR()));
            SimpleColoredComponent commentComponent = $this$forEach$iv$iv$iv;
            ComponentInlayRenderer inlayRenderer = new ComponentInlayRenderer((Component)commentComponent, ComponentInlayAlignment.STRETCH_TO_CONTENT_WIDTH);
            Document document2 = this.editor.getDocument();
            Document document3 = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getDocument(...)");
            int n = document2.getLineStartOffset(RangesKt.coerceIn((int)inlayLine, (ClosedRange)((ClosedRange)this.getLineIndexes(document3))));
            InlayProperties inlayProperties = new InlayProperties().showAbove(isAbove);
            Intrinsics.checkNotNullExpressionValue((Object)inlayProperties, (String)"showAbove(...)");
            Inlay inlay = commentInlay = ComponentInlayKt.addComponentInlay((Editor)this.editor, (int)n, (InlayProperties)inlayProperties, (ComponentInlayRenderer)inlayRenderer);
            if (inlay == null) break block3;
            Inlay inlay2 = inlay;
            List<Inlay<?>> list = this.inlays;
            Inlay p0 = inlay2;
            boolean bl5 = false;
            list.add(p0);
        }
    }

    private final EditorTextField addInsertedCodeInlay(LineFragment change, boolean withGutter, boolean isModifiedCode) {
        String addedText = ((Object)DiffUtil.getLinesContent((Document)this.resultDocument, (int)change.getStartLine1(), (int)change.getEndLine1())).toString();
        AIDeletedCodeEditorTextField editorTextField = this.getAIDeletedCodeEditorTextField(addedText);
        int endLine = isModifiedCode ? change.getStartLine2() : change.getEndLine2();
        Pair pair = change.getEndLine2() != this.editor.getDocument().getLineCount() ? TuplesKt.to((Object)endLine, (Object)true) : (change.getEndLine2() != 0 ? TuplesKt.to((Object)(endLine - 1), (Object)false) : TuplesKt.to((Object)0, (Object)false));
        int inlayLine = ((Number)pair.component1()).intValue();
        boolean isAbove = (Boolean)pair.component2();
        Document document2 = this.editor.getDocument();
        Document document3 = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getDocument(...)");
        int n = document2.getLineStartOffset(RangesKt.coerceIn((int)inlayLine, (ClosedRange)((ClosedRange)this.getLineIndexes(document3))));
        InlayProperties inlayProperties = new InlayProperties().showAbove(isAbove);
        Intrinsics.checkNotNullExpressionValue((Object)inlayProperties, (String)"showAbove(...)");
        Inlay inlayAccept = ComponentInlayKt.addComponentInlay((Editor)this.editor, (int)n, (InlayProperties)inlayProperties, (ComponentInlayRenderer)new AIInsertedCodeInlayRenderer(editorTextField, withGutter, new AcceptInEditorDiffGutterRenderer(change, this)));
        if (inlayAccept == null) {
            throw new IllegalStateException("Cannot create inlay");
        }
        this.inlays.add(inlayAccept);
        return editorTextField;
    }

    private final AIDeletedCodeEditorTextField getAIDeletedCodeEditorTextField(String deletedText) {
        AIDeletedCodeEditorTextField result2 = AIDeletedCodeEditorTextField.Companion.create(this.editor, deletedText, this.project, this.fileType);
        result2.setDisposedWith(this);
        return result2;
    }

    private final IntRange getLineIndexes(Document $this$lineIndexes) {
        return new IntRange(0, Math.max(0, $this$lineIndexes.getLineCount() - 1));
    }

    private final void setupInsertedCodeInlay(EditorTextField inlay, LineFragment change, boolean modifiedCode) {
        Editor inlayEditor = inlay.getEditor();
        if (inlayEditor == null) {
            throw new IllegalStateException("Cannot create inlay editor");
        }
        int inlayLinesCount = change.getEndLine1() - change.getStartLine1();
        List it = new DiffDrawUtil.LineHighlighterBuilder(inlayEditor, 0, inlayLinesCount, TextDiffType.INSERTED).withIgnored(change.getInnerFragments() != null && modifiedCode).done();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        this.highlighters.addAll(it);
    }

    static /* synthetic */ void setupInsertedCodeInlay$default(ChangeInEditorDiffRenderer changeInEditorDiffRenderer, EditorTextField editorTextField, LineFragment lineFragment, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        changeInEditorDiffRenderer.setupInsertedCodeInlay(editorTextField, lineFragment, bl);
    }

    private static final GutterIconRenderer addGutterIcons$lambda$10(LineFragment $change, ChangeInEditorDiffRenderer this$0) {
        return (GutterIconRenderer)new AcceptInEditorDiffGutterRenderer($change, this$0);
    }

    public /* synthetic */ ChangeInEditorDiffRenderer(Editor editor2, Project project2, FileType fileType2, Document resultDocument, List diffChanges2, DefaultConstructorMarker $constructor_marker) {
        this(editor2, project2, fileType2, resultDocument, diffChanges2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/codeGeneration/multifile/ui/ChangeInEditorDiffRenderer$AIInEditorDiffRendererFactory;", "Lcom/intellij/ml/llm/codeGeneration/inplace/AIDiffBasedCodeGenerationInteraction$RendererFactory;", "<init>", "()V", "create", "Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/CodeGenerationDiffRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "initialText", "", "intellij.ml.llm.codeGeneration"})
    @StabilityInferred(parameters=1)
    public static final class AIInEditorDiffRendererFactory
    implements AIDiffBasedCodeGenerationInteraction.RendererFactory {
        @NotNull
        public static final AIInEditorDiffRendererFactory INSTANCE = new AIInEditorDiffRendererFactory();
        public static final int $stable;

        private AIInEditorDiffRendererFactory() {
        }

        @Override
        @NotNull
        public CodeGenerationDiffRenderer create(@NotNull Editor editor2, @NotNull Project project2, @Nullable FileType fileType2, @Nullable CharSequence initialText) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return AIInEditorDiffRenderer.Companion.create(editor2, project2, fileType2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/codeGeneration/multifile/ui/ChangeInEditorDiffRenderer$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/ml/llm/codeGeneration/multifile/ui/ChangeInEditorDiffRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "initialContent", "", "diffChanges", "", "Lcom/intellij/ml/llm/codeGeneration/multifile/core/change/LlmDiffChange;", "intellij.ml.llm.codeGeneration"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChangeInEditorDiffRenderer create(@NotNull Editor editor2, @NotNull Project project2, @Nullable FileType fileType2, @Nullable CharSequence initialContent, @NotNull List<? extends LlmDiffChange> diffChanges2) {
            Document initialDocument;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(diffChanges2, (String)"diffChanges");
            VirtualFile virtualFile2 = editor2.getVirtualFile();
            Intrinsics.checkNotNull((Object)virtualFile2);
            String string = "initial-" + virtualFile2.getName();
            CharSequence charSequence = initialContent;
            if (charSequence == null) {
                String string2 = editor2.getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                charSequence = string2;
            }
            if ((initialDocument = VirtualFileUtil.findDocument((VirtualFile)((VirtualFile)new LightVirtualFile(string, fileType2, charSequence)))) == null) {
                throw new IllegalStateException("Cannot create in memory document for comparison");
            }
            initialDocument.setReadOnly(true);
            return new ChangeInEditorDiffRenderer(editor2, project2, fileType2, initialDocument, diffChanges2, null);
        }

        public static /* synthetic */ ChangeInEditorDiffRenderer create$default(Companion companion, Editor editor2, Project project2, FileType fileType2, CharSequence charSequence, List list, int n, Object object) {
            if ((n & 8) != 0) {
                charSequence = null;
            }
            return companion.create(editor2, project2, fileType2, charSequence, list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

