/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context.airules;

import com.intellij.ml.llm.context.airules.AiRuleEditor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\r\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/context/airules/AiRuleEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "", "Lorg/jetbrains/annotations/NonNls;", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "intellij.ml.llm.context.airules"})
public final class AiRuleEditorProvider
implements FileEditorProvider,
DumbAware {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean accept(@NotNull Project project2, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Intrinsics.areEqual((Object)file.getExtension(), (Object)"md")) return false;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)".aiassistant/rules", (boolean)false, (int)2, null)) return false;
        if (!Registry.Companion.is("llm.ai.rules.enabled")) return false;
        return true;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new AiRuleEditor(project2, file);
    }

    @NotNull
    public String getEditorTypeId() {
        return "AiRulesEditor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_OTHER_EDITORS;
    }
}

