/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context.airules;

import com.intellij.ml.llm.context.airules.AiRulesService;
import com.intellij.ml.llm.context.airules.statistics.AIAssistantAiRulesEventLogger;
import com.intellij.ml.llm.context.rules.AiRulesSharedService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0016\u0010\u000b\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/context/airules/AiRuleFileTracker;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "before", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "after", "isAiRule", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.ml.llm.context.airules"})
@SourceDebugExtension(value={"SMAP\nAiRuleFileTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiRuleFileTracker.kt\ncom/intellij/ml/llm/context/airules/AiRuleFileTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n774#2:50\n865#2,2:51\n1869#2,2:53\n774#2:55\n865#2,2:56\n1869#2,2:58\n1#3:60\n*S KotlinDebug\n*F\n+ 1 AiRuleFileTracker.kt\ncom/intellij/ml/llm/context/airules/AiRuleFileTracker\n*L\n22#1:50\n22#1:51,2\n24#1:53,2\n38#1:55\n38#1:56,2\n40#1:58,2\n*E\n"})
public final class AiRuleFileTracker
implements BulkFileListener {
    @NotNull
    private final Project project;

    public AiRuleFileTracker(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    /*
     * WARNING - void declaration
     */
    public void before(@NotNull List<? extends VFileEvent> events) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (!Registry.Companion.is("llm.ai.rules.enabled")) {
            super.before(events);
            return;
        }
        Iterable $this$filter$iv = events;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VFileEvent it = (VFileEvent)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof VFileDeleteEvent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List deletedFiles = (List)destination$iv$iv;
        if (deletedFiles.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = deletedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file;
            VFileEvent event = (VFileEvent)element$iv;
            boolean bl = false;
            if (!this.isAiRule(event.getFile()) || event.getRequestor() instanceof AiRulesService || event.getFile() == null) continue;
            AIAssistantAiRulesEventLogger.logAiRuleDeleted(this.project, file, AIAssistantAiRulesEventLogger.AiRuleDeleteSource.MANUALLY);
        }
        super.before(events);
    }

    /*
     * WARNING - void declaration
     */
    public void after(@NotNull List<? extends VFileEvent> events) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (!Registry.Companion.is("llm.ai.rules.enabled")) {
            super.after(events);
            return;
        }
        Iterable $this$filter$iv = events;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VFileEvent it = (VFileEvent)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof VFileCreateEvent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List createdFiles = (List)destination$iv$iv;
        if (createdFiles.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = createdFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VFileEvent event = (VFileEvent)element$iv;
            boolean bl = false;
            if (!this.isAiRule(event.getFile()) || event.getRequestor() instanceof AiRulesService) continue;
            AIAssistantAiRulesEventLogger.logAiRuleCreated(this.project, AIAssistantAiRulesEventLogger.AiRuleCreateSource.MANUALLY);
        }
        super.after(events);
    }

    private final boolean isAiRule(VirtualFile file) {
        boolean bl;
        VirtualFile virtualFile2 = file;
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl2 = false;
            bl = AiRulesSharedService.Companion.getInstance(this.project).isAiRuleFile(it);
        } else {
            bl = false;
        }
        return bl;
    }
}

