/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context.runtime;

import com.intellij.ml.llm.context.ContextRetrievalRequest;
import com.intellij.ml.llm.context.runtime.privacy.PrivacyKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0007\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\"\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"hasSuspendedSession", "", "Lcom/intellij/ml/llm/context/ContextRetrievalRequest;", "getHasSuspendedSession", "(Lcom/intellij/ml/llm/context/ContextRetrievalRequest;)Z", "currentDebugSession", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "getCurrentDebugSession", "(Lcom/intellij/ml/llm/context/ContextRetrievalRequest;)Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "DEBUG_SESSION_CONTEXT_NAME", "", "getCurrentDebugSessionDescription", "Lcom/intellij/ml/llm/privacy/PSString;", "session", "intellij.ml.llm.context.runtime"})
public final class CurrentDebugSessionKt {
    @NotNull
    private static final String DEBUG_SESSION_CONTEXT_NAME = "currentDebugSession";

    public static final boolean getHasSuspendedSession(@NotNull ContextRetrievalRequest $this$hasSuspendedSession) {
        Intrinsics.checkNotNullParameter((Object)$this$hasSuspendedSession, (String)"<this>");
        XDebugSessionImpl xDebugSessionImpl = CurrentDebugSessionKt.getCurrentDebugSession($this$hasSuspendedSession);
        if (xDebugSessionImpl == null) {
            return false;
        }
        XDebugSessionImpl currentSession = xDebugSessionImpl;
        return currentSession.isSuspended();
    }

    @Nullable
    public static final XDebugSessionImpl getCurrentDebugSession(@NotNull ContextRetrievalRequest $this$currentDebugSession) {
        Intrinsics.checkNotNullParameter((Object)$this$currentDebugSession, (String)"<this>");
        return CurrentDebugSessionKt.getCurrentDebugSession($this$currentDebugSession.getSession().getProject());
    }

    @Nullable
    public static final XDebugSessionImpl getCurrentDebugSession(@NotNull Project $this$currentDebugSession) {
        Intrinsics.checkNotNullParameter((Object)$this$currentDebugSession, (String)"<this>");
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)$this$currentDebugSession).getCurrentSession();
        return xDebugSession instanceof XDebugSessionImpl ? (XDebugSessionImpl)xDebugSession : null;
    }

    @VisibleForTesting
    @NotNull
    public static final PSString getCurrentDebugSessionDescription(@Nullable XDebugSessionImpl session) {
        PSString pSString;
        if (session == null) {
            pSString = ConstantsKt.getPrivacyConst((String)"No debug session is running now");
        } else {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{PrivacyKt.getPrivacySafe((XDebugSession)session).getName()};
            pSString = ConstantsKt.getPrivacyConst((String)"Currently running debug session: '%s'").format(pSStringConvertibleArray);
        }
        return pSString;
    }
}

