/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.httpClient.ktor;

import com.intellij.ml.llm.core.httpClient.AiaHttpClientCallBody;
import com.intellij.ml.llm.core.httpClient.AiaHttpClientCallEvent;
import com.intellij.ml.llm.core.httpClient.AiaHttpClientCallMethod;
import com.intellij.ml.llm.core.httpClient.ktor.KtorHttpClientLoggerKt;
import io.ktor.http.HttpMethod;
import java.io.Closeable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\f\u0010\u000e\u001a\u00020\u0005*\u00020\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0005J\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001e\u001a\u00020\u001fJ\n\u0010#\u001a\u0004\u0018\u00010!H\u0002J\n\u0010$\u001a\u0004\u0018\u00010%H\u0002J\n\u0010&\u001a\u0004\u0018\u00010'H\u0002J\n\u0010(\u001a\u0004\u0018\u00010)H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006+"}, d2={"Lcom/intellij/ml/llm/core/httpClient/ktor/KtorLoggingParser;", "", "<init>", "()V", "requestUrl", "", "tryParseRequestLine", "", "line", "responseStatus", "tryParseResponseLine", "method", "Lcom/intellij/ml/llm/core/httpClient/AiaHttpClientCallMethod;", "tryParseMethodLine", "stripHttpMethodToString", "fromUrl", "tryParseFromLine", "bodyContentType", "tryParseBodyContentTypeLine", "headers", "", "getHeaders", "()Ljava/util/Map;", "tryParseHeaderLine", "body", "getBody", "()Ljava/lang/String;", "setBody", "(Ljava/lang/String;)V", "tryReadBody", "scanner", "Ljava/util/Scanner;", "tryRead", "Lcom/intellij/ml/llm/core/httpClient/AiaHttpClientCallEvent;", "message", "tryBuild", "tryBuildRequest", "Lcom/intellij/ml/llm/core/httpClient/AiaHttpClientCallEvent$HttpRequestEvent;", "tryBuildResponse", "Lcom/intellij/ml/llm/core/httpClient/AiaHttpClientCallEvent$HttpResponseEvent;", "tryBuildBody", "Lcom/intellij/ml/llm/core/httpClient/AiaHttpClientCallBody;", "Companion", "intellij.ml.llm.core.httpClient"})
@SourceDebugExtension(value={"SMAP\nKtorHttpClientLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorHttpClientLogger.kt\ncom/intellij/ml/llm/core/httpClient/ktor/KtorLoggingParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n1#2:237\n*E\n"})
final class KtorLoggingParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String requestUrl;
    @Nullable
    private String responseStatus;
    @Nullable
    private AiaHttpClientCallMethod method;
    @Nullable
    private String fromUrl;
    @Nullable
    private String bodyContentType;
    @NotNull
    private final Map<String, String> headers = new LinkedHashMap();
    @Nullable
    private String body;
    @NotNull
    private static final String REQUEST_PREFIX = "REQUEST: ";
    @NotNull
    private static final String RESPONSE_PREFIX = "RESPONSE: ";
    @NotNull
    private static final String METHOD_PREFIX = "METHOD: ";
    @NotNull
    private static final String FROM_PREFIX = "FROM: ";
    @NotNull
    private static final String COMMON_HEADERS = "COMMON HEADERS";
    @NotNull
    private static final String CONTENT_HEADERS = "CONTENT HEADERS";
    @NotNull
    private static final String HEADER_PREFIX = "-> ";
    @NotNull
    private static final String BODY = "BODY";
    @NotNull
    private static final String BODY_CONTENT_TYPE_PREFIX = "BODY Content-Type: ";
    @NotNull
    private static final Regex bodyPattern = new Regex("BODY START\n(.*)\nBODY END", RegexOption.DOT_MATCHES_ALL);
    @NotNull
    private static final String METHOD_PLACEHOLDER = "***";
    @NotNull
    private static final String methodPlaceholderToString = new HttpMethod("***").toString();

    private final boolean tryParseRequestLine(String line) {
        String string = KtorHttpClientLoggerKt.access$removePrefixOrNull(line, REQUEST_PREFIX);
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            return false;
        }
        this.requestUrl = string;
        return true;
    }

    private final boolean tryParseResponseLine(String line) {
        String string = KtorHttpClientLoggerKt.access$removePrefixOrNull(line, RESPONSE_PREFIX);
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            return false;
        }
        this.responseStatus = string;
        return true;
    }

    private final boolean tryParseMethodLine(String line) {
        String string = KtorHttpClientLoggerKt.access$removePrefixOrNull(line, METHOD_PREFIX);
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            return false;
        }
        String s = string;
        String methodString = this.stripHttpMethodToString(s);
        this.method = AiaHttpClientCallMethod.Companion.fromString(methodString);
        return true;
    }

    private final String stripHttpMethodToString(String $this$stripHttpMethodToString) {
        String suffix;
        String prefix = StringsKt.commonPrefixWith$default((CharSequence)$this$stripHttpMethodToString, (CharSequence)methodPlaceholderToString, (boolean)false, (int)2, null);
        if (Intrinsics.areEqual((Object)(prefix + METHOD_PLACEHOLDER + (suffix = StringsKt.commonSuffixWith$default((CharSequence)$this$stripHttpMethodToString, (CharSequence)methodPlaceholderToString, (boolean)false, (int)2, null))), (Object)methodPlaceholderToString)) {
            String string = $this$stripHttpMethodToString.substring(prefix.length(), $this$stripHttpMethodToString.length() - suffix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return $this$stripHttpMethodToString;
    }

    private final boolean tryParseFromLine(String line) {
        String string = KtorHttpClientLoggerKt.access$removePrefixOrNull(line, FROM_PREFIX);
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            return false;
        }
        this.fromUrl = string;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryParseBodyContentTypeLine(String line) {
        void it;
        String bodyContentTypeLine;
        String string;
        String string2 = KtorHttpClientLoggerKt.access$removePrefixOrNull(line, BODY_CONTENT_TYPE_PREFIX);
        if (string2 == null || (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) == null) {
            return false;
        }
        String string3 = string = (bodyContentTypeLine = string2);
        KtorLoggingParser ktorLoggingParser = this;
        boolean bl = false;
        boolean bl2 = Intrinsics.areEqual((Object)it, (Object)"null");
        ktorLoggingParser.bodyContentType = !bl2 ? string : null;
        return true;
    }

    @NotNull
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    private final boolean tryParseHeaderLine(String line) {
        String string = KtorHttpClientLoggerKt.access$removePrefixOrNull(line, HEADER_PREFIX);
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            return false;
        }
        String headerLine = string;
        Object object = new String[]{": "};
        Object it = object = StringsKt.split$default((CharSequence)headerLine, (String[])object, (boolean)false, (int)2, (int)2, null);
        boolean bl = false;
        Object object2 = it.size() == 2 ? object : null;
        if (object2 == null) {
            return false;
        }
        Object object3 = object2;
        String key = (String)object3.get(0);
        String value2 = (String)object3.get(1);
        this.headers.put(key, value2);
        return true;
    }

    @Nullable
    public final String getBody() {
        return this.body;
    }

    public final void setBody(@Nullable String string) {
        this.body = string;
    }

    private final boolean tryReadBody(Scanner scanner) {
        if (scanner.findWithinHorizon(bodyPattern.toPattern(), 0) == null) {
            return false;
        }
        this.body = scanner.match().group(1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final AiaHttpClientCallEvent tryRead(@NotNull String message) {
        AiaHttpClientCallEvent aiaHttpClientCallEvent;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Closeable closeable = new Scanner(message);
        Throwable throwable = null;
        try {
            Scanner scanner = (Scanner)closeable;
            boolean bl = false;
            AiaHttpClientCallEvent aiaHttpClientCallEvent2 = this.tryRead(scanner);
            if (aiaHttpClientCallEvent2 == null) {
                KtorLoggingParser $this$tryRead_u24lambda_u243_u24lambda_u242 = this;
                boolean bl2 = false;
                KtorHttpClientLoggerKt.access$getLOG$p().debug("Unable to parse log message: " + message);
                aiaHttpClientCallEvent2 = null;
            }
            aiaHttpClientCallEvent = aiaHttpClientCallEvent2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return aiaHttpClientCallEvent;
    }

    @Nullable
    public final AiaHttpClientCallEvent tryRead(@NotNull Scanner scanner) {
        boolean parsedHeader;
        boolean parsedAnythingElseThanHeadersOrBody;
        Intrinsics.checkNotNullParameter((Object)scanner, (String)"scanner");
        String line = null;
        do {
            if (KtorHttpClientLoggerKt.access$nextLineOrNull(scanner) != null) continue;
            KtorLoggingParser $this$tryRead_u24lambda_u244 = this;
            boolean bl = false;
            KtorHttpClientLoggerKt.access$getLOG$p().debug("Unexpected end of input");
            return $this$tryRead_u24lambda_u244.tryBuild();
        } while (parsedAnythingElseThanHeadersOrBody = this.tryParseRequestLine(line) || this.tryParseResponseLine(line) || this.tryParseMethodLine(line) || this.tryParseFromLine(line));
        if (Intrinsics.areEqual((Object)line, (Object)COMMON_HEADERS)) {
            do {
                if (KtorHttpClientLoggerKt.access$nextLineOrNull(scanner) != null) continue;
                return this.tryBuild();
            } while (parsedHeader = this.tryParseHeaderLine(line));
        }
        if (Intrinsics.areEqual((Object)line, (Object)CONTENT_HEADERS)) {
            do {
                if (KtorHttpClientLoggerKt.access$nextLineOrNull(scanner) != null) continue;
                return this.tryBuild();
            } while (parsedHeader = this.tryParseHeaderLine(line));
        }
        if (StringsKt.startsWith$default((String)line, (String)"BODY ", (boolean)false, (int)2, null)) {
            boolean parsedBody;
            boolean bl = parsedBody = this.tryParseBodyContentTypeLine(line) && this.tryReadBody(scanner);
            if (!parsedBody) {
                KtorHttpClientLoggerKt.access$getLOG$p().debug("Unable to extract body starting: " + line);
            }
        }
        return this.tryBuild();
    }

    private final AiaHttpClientCallEvent tryBuild() {
        AiaHttpClientCallEvent.HttpRequestEvent httpRequestEvent = this.tryBuildRequest();
        return httpRequestEvent != null ? (AiaHttpClientCallEvent)httpRequestEvent : (AiaHttpClientCallEvent)this.tryBuildResponse();
    }

    private final AiaHttpClientCallEvent.HttpRequestEvent tryBuildRequest() {
        String string = this.requestUrl;
        if (string == null) {
            return null;
        }
        String requestUrl = string;
        AiaHttpClientCallMethod aiaHttpClientCallMethod = this.method;
        if (aiaHttpClientCallMethod == null) {
            aiaHttpClientCallMethod = AiaHttpClientCallMethod.UNKNOWN;
        }
        return new AiaHttpClientCallEvent.HttpRequestEvent(requestUrl, aiaHttpClientCallMethod, MapsKt.toMap(this.headers), this.tryBuildBody());
    }

    private final AiaHttpClientCallEvent.HttpResponseEvent tryBuildResponse() {
        String string = this.responseStatus;
        if (string == null) {
            return null;
        }
        String responseStatus = string;
        String string2 = this.fromUrl;
        if (string2 == null) {
            return null;
        }
        String fromUrl = string2;
        AiaHttpClientCallMethod aiaHttpClientCallMethod = this.method;
        if (aiaHttpClientCallMethod == null) {
            aiaHttpClientCallMethod = AiaHttpClientCallMethod.UNKNOWN;
        }
        return new AiaHttpClientCallEvent.HttpResponseEvent(fromUrl, aiaHttpClientCallMethod, responseStatus, MapsKt.toMap(this.headers), this.tryBuildBody());
    }

    /*
     * WARNING - void declaration
     */
    private final AiaHttpClientCallBody tryBuildBody() {
        String string;
        String string2 = this.bodyContentType;
        if (string2 == null) {
            return null;
        }
        String contentType = string2;
        String omittedBodyPlaceholder = this.requestUrl != null ? "[request body omitted]" : (this.responseStatus != null ? "[response body omitted]" : null);
        String string3 = contentType;
        String string4 = this.body;
        if (string4 != null) {
            void it;
            String string5;
            String string6 = string5 = string4;
            String string7 = string3;
            boolean bl = false;
            boolean bl2 = !Intrinsics.areEqual((Object)it, (Object)omittedBodyPlaceholder);
            string3 = string7;
            string = bl2 ? string5 : null;
        } else {
            string = null;
        }
        String string8 = string;
        String string9 = string3;
        return new AiaHttpClientCallBody(string9, string8);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/core/httpClient/ktor/KtorLoggingParser$Companion;", "", "<init>", "()V", "REQUEST_PREFIX", "", "RESPONSE_PREFIX", "METHOD_PREFIX", "FROM_PREFIX", "COMMON_HEADERS", "CONTENT_HEADERS", "HEADER_PREFIX", "BODY", "BODY_CONTENT_TYPE_PREFIX", "bodyPattern", "Lkotlin/text/Regex;", "METHOD_PLACEHOLDER", "methodPlaceholderToString", "intellij.ml.llm.core.httpClient"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

