/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.ui;

import com.intellij.ml.llm.daemon.insight.handler.InsightModel;
import com.intellij.ml.llm.daemon.insight.handler.request.InsightEvent;
import com.intellij.ml.llm.daemon.insight.ui.InsightElementRenderer;
import com.intellij.ml.llm.daemon.insight.ui.InsightGutterRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J$\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rH\u0002J$\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderer;", "", "<init>", "()V", "current", "", "", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderer$Rendering;", "update", "", "request", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightEvent;", "insights", "", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "processHover", "point", "Ljava/awt/Point;", "processClick", "findInlayUnder", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightElementRenderer;", "removeInvalidated", "editor", "Lcom/intellij/openapi/editor/Editor;", "removeNoRelevantFromWorkingRange", "event", "addNew", "addInsight", "insight", "Rendering", "Companion", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightRenderer.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightRenderer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n126#2:120\n153#2,3:121\n216#2,2:143\n774#3:124\n865#3,2:125\n1869#3,2:127\n504#4,7:129\n488#4,7:136\n1#5:145\n*S KotlinDebug\n*F\n+ 1 InsightRenderer.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightRenderer\n*L\n32#1:120\n32#1:121,3\n73#1:143,2\n32#1:124\n32#1:125,2\n32#1:127,2\n41#1:129,7\n73#1:136,7\n*E\n"})
public final class InsightRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Long, Rendering> current = new LinkedHashMap();
    @NotNull
    private static final Key<InsightRenderer> key;

    @RequiresEdt
    public final void update(@NotNull InsightEvent request2, @NotNull Map<Long, InsightModel> insights) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter(insights, (String)"insights");
        this.removeInvalidated(request2.getEditor());
        this.removeNoRelevantFromWorkingRange(request2, insights);
        this.addNew(request2, insights);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void processHover(@NotNull Point point) {
        void $this$filterTo$iv$iv;
        InsightElementRenderer it;
        Iterable $this$mapTo$iv$iv;
        InsightElementRenderer renderer2;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Inlay<InsightElementRenderer> inlay = this.findInlayUnder(point);
        InsightElementRenderer insightElementRenderer = renderer2 = inlay != null ? (InsightElementRenderer)inlay.getRenderer() : null;
        if (insightElementRenderer != null) {
            insightElementRenderer.processHover(point);
        }
        Map<Long, Rendering> $this$map$iv = this.current;
        boolean $i$f$map = false;
        Map<Long, Rendering> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((InsightElementRenderer)((Rendering)it.getValue()).getInlay().getRenderer());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv) {
            it = (InsightElementRenderer)((Object)element$iv$iv);
            boolean bl = false;
            if (!(it != renderer2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InsightElementRenderer it2 = (InsightElementRenderer)element$iv;
            boolean bl = false;
            it2.processOutOfHover();
        }
    }

    @RequiresEdt
    public final void processClick(@NotNull Point point) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Object object = this.findInlayUnder(point);
            if (object == null || (object = (InsightElementRenderer)object.getRenderer()) == null) break block0;
            ((InsightElementRenderer)object).processClick(point);
        }
    }

    private final Inlay<InsightElementRenderer> findInlayUnder(Point point) {
        Map<Long, Rendering> $this$filterValues$iv = this.current;
        boolean $i$f$filterValues = false;
        LinkedHashMap<Long, Rendering> result$iv = new LinkedHashMap<Long, Rendering>();
        for (Map.Entry<Long, Rendering> entry$iv : $this$filterValues$iv.entrySet()) {
            Rendering it = entry$iv.getValue();
            boolean bl = false;
            Rectangle rectangle = it.getInlay().getBounds();
            boolean bl2 = rectangle != null ? rectangle.contains(point) : false;
            if (!bl2) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Rendering rendering = (Rendering)CollectionsKt.firstOrNull((Iterable)((Map)result$iv).values());
        return rendering != null ? rendering.getInlay() : null;
    }

    private final void removeInvalidated(Editor editor2) {
        Iterator<Map.Entry<Long, Rendering>> iter = this.current.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, Rendering> current = iter.next();
            if (current.getValue().getInlay().isValid()) continue;
            iter.remove();
            Disposer.dispose((Disposable)((Disposable)current.getValue().getInlay()));
            editor2.getMarkupModel().removeHighlighter(current.getValue().getHighlighter());
        }
    }

    private final void removeNoRelevantFromWorkingRange(InsightEvent event, Map<Long, InsightModel> insights) {
        Iterator<Map.Entry<Long, Rendering>> iter = this.current.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, Rendering> current = iter.next();
            int lineNumber = event.getDocument().getLineNumber(current.getValue().getInlay().getOffset());
            if (!event.getWorkingRange().containsLine(lineNumber) || insights.containsKey(current.getKey())) continue;
            iter.remove();
            Disposer.dispose((Disposable)((Disposable)current.getValue().getInlay()));
            event.getEditor().getMarkupModel().removeHighlighter(current.getValue().getHighlighter());
        }
    }

    private final void addNew(InsightEvent event, Map<Long, InsightModel> insights) {
        Map<Long, InsightModel> $this$filterKeys$iv = insights;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<Long, InsightModel> result$iv = new LinkedHashMap<Long, InsightModel>();
        for (Map.Entry<Long, InsightModel> entry$iv : $this$filterKeys$iv.entrySet()) {
            long it = ((Number)entry$iv.getKey()).longValue();
            boolean bl = false;
            if (!(!this.current.containsKey(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$forEach$iv = result$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            this.addInsight(event, (InsightModel)it.getValue());
        }
    }

    private final void addInsight(InsightEvent event, InsightModel insight) {
        RangeHighlighter rangeHighlighter;
        InsightElementRenderer renderer2 = new InsightElementRenderer(event.getEditor(), event.getProject(), insight);
        Inlay inlay = event.getEditor().getInlayModel().addBlockElement(event.getDocument().getLineEndOffset(insight.getRange().getStartLine()), false, true, 1, (EditorCustomElementRenderer)renderer2);
        if (inlay == null) {
            return;
        }
        Inlay inlay2 = inlay;
        RangeHighlighter it = rangeHighlighter = event.getEditor().getMarkupModel().addRangeHighlighter(event.getDocument().getLineStartOffset(insight.getRange().getStartLine()), event.getDocument().getLineEndOffset(insight.getRange().getEndLine()), 1000, null, HighlighterTargetArea.LINES_IN_RANGE);
        boolean bl = false;
        it.setLineMarkerRenderer((LineMarkerRenderer)new InsightGutterRenderer());
        RangeHighlighter rangeHighlighter2 = rangeHighlighter;
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"also(...)");
        RangeHighlighter highlighter = rangeHighlighter2;
        this.current.put(insight.getId(), new Rendering((Inlay<InsightElementRenderer>)inlay2, highlighter));
    }

    static {
        Key key = Key.create((String)"InsightRenderer");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        InsightRenderer.key = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderer$Companion;", "", "<init>", "()V", "key", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getOrCreate", "editor", "Lcom/intellij/openapi/editor/Editor;", "getOrNull", "intellij.ml.llm.daemon"})
    @SourceDebugExtension(value={"SMAP\nInsightRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightRenderer.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightRenderer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresEdt
        @NotNull
        public final InsightRenderer getOrCreate(@NotNull Editor editor2) {
            InsightRenderer insightRenderer;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            InsightRenderer insightRenderer2 = (InsightRenderer)editor2.getUserData(key);
            if (insightRenderer2 != null) {
                InsightRenderer it = insightRenderer2;
                boolean bl = false;
                return it;
            }
            EditorUtil.disposeWithEditor((Editor)editor2, () -> Companion.getOrCreate$lambda$1(editor2));
            InsightRenderer it = insightRenderer = new InsightRenderer();
            boolean bl = false;
            editor2.putUserData(key, (Object)it);
            return insightRenderer;
        }

        @RequiresEdt
        @Nullable
        public final InsightRenderer getOrNull(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return (InsightRenderer)editor2.getUserData(key);
        }

        private static final void getOrCreate$lambda$1(Editor $editor) {
            $editor.putUserData(key, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderer$Rendering;", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightElementRenderer;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "<init>", "(Lcom/intellij/openapi/editor/Inlay;Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "getInlay", "()Lcom/intellij/openapi/editor/Inlay;", "getHighlighter", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.daemon"})
    private static final class Rendering {
        @NotNull
        private final Inlay<InsightElementRenderer> inlay;
        @NotNull
        private final RangeHighlighter highlighter;

        public Rendering(@NotNull Inlay<InsightElementRenderer> inlay, @NotNull RangeHighlighter highlighter) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            this.inlay = inlay;
            this.highlighter = highlighter;
        }

        @NotNull
        public final Inlay<InsightElementRenderer> getInlay() {
            return this.inlay;
        }

        @NotNull
        public final RangeHighlighter getHighlighter() {
            return this.highlighter;
        }

        @NotNull
        public final Inlay<InsightElementRenderer> component1() {
            return this.inlay;
        }

        @NotNull
        public final RangeHighlighter component2() {
            return this.highlighter;
        }

        @NotNull
        public final Rendering copy(@NotNull Inlay<InsightElementRenderer> inlay, @NotNull RangeHighlighter highlighter) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            return new Rendering(inlay, highlighter);
        }

        public static /* synthetic */ Rendering copy$default(Rendering rendering, Inlay inlay, RangeHighlighter rangeHighlighter, int n, Object object) {
            if ((n & 1) != 0) {
                inlay = rendering.inlay;
            }
            if ((n & 2) != 0) {
                rangeHighlighter = rendering.highlighter;
            }
            return rendering.copy(inlay, rangeHighlighter);
        }

        @NotNull
        public String toString() {
            return "Rendering(inlay=" + this.inlay + ", highlighter=" + this.highlighter + ")";
        }

        public int hashCode() {
            int result2 = this.inlay.hashCode();
            result2 = result2 * 31 + this.highlighter.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Rendering)) {
                return false;
            }
            Rendering rendering = (Rendering)other;
            if (!Intrinsics.areEqual(this.inlay, rendering.inlay)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.highlighter, (Object)rendering.highlighter);
        }
    }
}

