/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.domains.ide.utils;

import com.intellij.ml.llm.domains.DomainSearchScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"createScope", "Lcom/intellij/ml/llm/domains/DomainSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.ml.llm.domains.ide"})
@SourceDebugExtension(value={"SMAP\nscopeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 scopeUtils.kt\ncom/intellij/ml/llm/domains/ide/utils/ScopeUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,26:1\n1#2:27\n*E\n"})
public final class ScopeUtilsKt {
    @NotNull
    public static final DomainSearchScope createScope(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return new DomainSearchScope(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public Project getProject() {
                return this.$project;
            }

            public List<Module> getModules() {
                return ArraysKt.toList((Object[])ModuleManager.Companion.getInstance(this.$project).getModules());
            }

            public SearchScope getScope() {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
                return (SearchScope)globalSearchScope;
            }
        };
    }

    @NotNull
    public static final DomainSearchScope createScope(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return new DomainSearchScope(module){
            final /* synthetic */ Module $module;
            {
                this.$module = $module;
            }

            public Project getProject() {
                Project project2 = this.$module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                return project2;
            }

            public List<Module> getModules() {
                return CollectionsKt.listOf((Object)this.$module);
            }

            public SearchScope getScope() {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleScope((Module)this.$module);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleScope(...)");
                return (SearchScope)globalSearchScope;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final DomainSearchScope createScope(@NotNull PsiElement psiElement) {
        DomainSearchScope domainSearchScope;
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module != null) {
            Module it = module;
            boolean bl = false;
            DomainSearchScope domainSearchScope2 = ScopeUtilsKt.createScope(it);
            if (domainSearchScope2 != null) {
                domainSearchScope = domainSearchScope2;
                return domainSearchScope;
            }
        }
        Project project2 = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        domainSearchScope = ScopeUtilsKt.createScope(project2);
        return domainSearchScope;
    }
}

