/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.agents.jupyter.tools;

import ai.koog.agents.core.tools.Tool;
import ai.koog.agents.core.tools.ToolDescriptor;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.ml.llm.ds.agents.DataSpellAgentContext;
import com.intellij.ml.llm.ds.agents.base.tools.DataSpellTool;
import com.intellij.ml.llm.ds.agents.jupyter.JupyterAgentContext;
import com.intellij.ml.llm.ds.agents.jupyter.tools.GetSpecificCellInfoKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.openapi.editor.Editor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0010J \u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/ds/agents/jupyter/tools/GetNotebookInfo;", "Lcom/intellij/ml/llm/ds/agents/base/tools/DataSpellTool;", "Lcom/intellij/ml/llm/ds/agents/jupyter/JupyterAgentContext;", "Lai/koog/agents/core/tools/Tool$EmptyArgs;", "context", "<init>", "(Lcom/intellij/ml/llm/ds/agents/jupyter/JupyterAgentContext;)V", "argsSerializer", "Lkotlinx/serialization/KSerializer;", "getArgsSerializer", "()Lkotlinx/serialization/KSerializer;", "descriptor", "Lai/koog/agents/core/tools/ToolDescriptor;", "getDescriptor", "()Lai/koog/agents/core/tools/ToolDescriptor;", "doExecuteImpl", "", "args", "(Lai/koog/agents/core/tools/Tool$EmptyArgs;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getJupyterInfoForLlm", "getContextAroundSelectedCells", "allCells", "", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "k", "", "intellij.ml.llm.ds"})
@SourceDebugExtension(value={"SMAP\nGetNotebookInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetNotebookInfo.kt\ncom/intellij/ml/llm/ds/agents/jupyter/tools/GetNotebookInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n774#2:78\n865#2,2:79\n1056#2:81\n1878#2,3:82\n1563#2:85\n1634#2,3:86\n*S KotlinDebug\n*F\n+ 1 GetNotebookInfo.kt\ncom/intellij/ml/llm/ds/agents/jupyter/tools/GetNotebookInfo\n*L\n35#1:78\n35#1:79,2\n35#1:81\n41#1:82,3\n53#1:85\n53#1:86,3\n*E\n"})
public final class GetNotebookInfo
extends DataSpellTool<JupyterAgentContext, Tool.EmptyArgs> {
    @NotNull
    private final KSerializer<Tool.EmptyArgs> argsSerializer;

    public GetNotebookInfo(@NotNull JupyterAgentContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((DataSpellAgentContext)context2);
        this.argsSerializer = Tool.EmptyArgs.INSTANCE.serializer();
    }

    @NotNull
    public KSerializer<Tool.EmptyArgs> getArgsSerializer() {
        return this.argsSerializer;
    }

    @NotNull
    public ToolDescriptor getDescriptor() {
        return new ToolDescriptor("get_notebook_info", "Fetches current information about jupyter notebook such as size and current cell types, current selection.", null, null, 12, null);
    }

    @Override
    @Nullable
    public Object doExecuteImpl(@NotNull Tool.EmptyArgs args, @NotNull Continuation<? super String> $completion) {
        return this.getJupyterInfoForLlm();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getJupyterInfoForLlm() {
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        StringBuilder stringBuilder;
        Editor editor2 = ((JupyterAgentContext)this.getContext()).getEditor();
        JupyterNotebook jupyterNotebook = JupyterHelper.INSTANCE.getJupyterNotebook(editor2);
        if (jupyterNotebook == null) {
            return "Can't find jupyter";
        }
        JupyterNotebook notebook = jupyterNotebook;
        StringBuilder $this$getJupyterInfoForLlm_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$filter$iv = notebook.computeCells();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JupyterCell it = (JupyterCell)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getIndex() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List cells = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                JupyterCell it = (JupyterCell)a;
                boolean bl = false;
                Comparable comparable = it.getIndex();
                it = (JupyterCell)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getIndex());
            }
        });
        $this$getJupyterInfoForLlm_u24lambda_u243.append(" - Info about notebook: \n ");
        $this$getJupyterInfoForLlm_u24lambda_u243.append("Number of cells: " + cells.size() + " \n");
        $this$getJupyterInfoForLlm_u24lambda_u243.append(GetNotebookInfo.getContextAroundSelectedCells$default(this, cells, 0, 2, null));
        $this$getJupyterInfoForLlm_u24lambda_u243.append("All cells and their types: \n ");
        Iterable $this$forEachIndexed$iv = notebook.computeCells();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cell;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (JupyterCell)item$iv;
            int index = n;
            boolean bl3 = false;
            $this$getJupyterInfoForLlm_u24lambda_u243.append("Cell " + (index + 1) + ": cell type: " + cell.getCellType().name() + "\n ");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String getContextAroundSelectedCells(List<? extends JupyterCell> allCells, int k) {
        StringBuilder stringBuilder;
        void $this$mapTo$iv$iv;
        Editor editor2 = ((JupyterAgentContext)this.getContext()).getEditor();
        Object object = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)editor2);
        if (object == null || (object = object.getSelectedCells()) == null) {
            return "No cells selected";
        }
        Object selectedCells = object;
        Iterable $this$map$iv = (Iterable)selectedCells;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOrdinal());
        }
        Set selectedIndices = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Integer n = (Integer)CollectionsKt.minOrNull((Iterable)selectedIndices);
        int minSelectedIndex = n != null ? n : 0;
        Integer n2 = (Integer)CollectionsKt.maxOrNull((Iterable)selectedIndices);
        int maxSelectedIndex = n2 != null ? n2 : 0;
        int startIndex = Math.max(0, minSelectedIndex - k);
        int endIndex = Math.min(allCells.size() - 1, maxSelectedIndex + k);
        StringBuilder $this$getContextAroundSelectedCells_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getContextAroundSelectedCells_u24lambda_u245.append("Context around selected cells:\n");
        int i = startIndex;
        if (i <= endIndex) {
            while (true) {
                JupyterCell cell = allCells.get(i);
                boolean isSelected = selectedIndices.contains(i);
                $this$getContextAroundSelectedCells_u24lambda_u245.append("- Cell " + (i + 1) + (isSelected ? " (SELECTED)" : "") + ":\n");
                $this$getContextAroundSelectedCells_u24lambda_u245.append(GetSpecificCellInfoKt.createInfoForLlm(cell));
                $this$getContextAroundSelectedCells_u24lambda_u245.append("\n");
                if (i == endIndex) break;
                ++i;
            }
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ String getContextAroundSelectedCells$default(GetNotebookInfo getNotebookInfo, List list, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        return getNotebookInfo.getContextAroundSelectedCells(list, n);
    }
}

