/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.next.agents.impl.executors.workspace;

import com.intellij.ml.llm.ds.next.agents.impl.DataSpellNextAgentContext;
import com.intellij.ml.llm.ds.next.agents.impl.base.DataSpellNextAgentModuleBase;
import com.intellij.ml.llm.ds.next.agents.impl.base.tools.DataSpellNextTool;
import com.intellij.ml.llm.ds.next.agents.impl.executors.workspace.WorkspaceAgentContext;
import com.intellij.ml.llm.ds.next.agents.impl.executors.workspace.models.DirectoryModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.workspace.models.WorkspaceModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.workspace.tools.AttachDirectoryTool;
import com.intellij.ml.llm.ds.next.agents.impl.executors.workspace.tools.CreateFileTool;
import com.intellij.ml.llm.ds.next.agents.impl.executors.workspace.tools.SelectAndAttachDirectoryTool;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0012\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u00140\u0013H\u0014R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0010\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/workspace/WorkspaceAgentModule;", "Lcom/intellij/ml/llm/ds/next/agents/impl/base/DataSpellNextAgentModuleBase;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/workspace/WorkspaceAgentContext;", "context", "<init>", "(Lcom/intellij/ml/llm/ds/next/agents/impl/executors/workspace/WorkspaceAgentContext;)V", "name", "", "getName", "()Ljava/lang/String;", "model", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/workspace/models/WorkspaceModel;", "getModel", "()Lcom/intellij/ml/llm/ds/next/agents/impl/executors/workspace/models/WorkspaceModel;", "defSystemPrompt", "getDefSystemPrompt", "systemPromptBase", "getSystemPromptBase", "createTools", "", "Lcom/intellij/ml/llm/ds/next/agents/impl/base/tools/DataSpellNextTool;", "intellij.ml.llm.ds.next"})
public final class WorkspaceAgentModule
extends DataSpellNextAgentModuleBase<WorkspaceAgentContext> {
    public WorkspaceAgentModule(@NotNull WorkspaceAgentContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((DataSpellNextAgentContext)context2);
    }

    @Override
    @NotNull
    public String getName() {
        return "workspace";
    }

    private final WorkspaceModel getModel() {
        return ((WorkspaceAgentContext)this.getContext()).getWorkspaceModel();
    }

    @Override
    @NotNull
    public String getDefSystemPrompt() {
        return "The agent who helps users work with their workspace.\n\nActions this agent can perform:\n- create a file\n- attach a directory\n\nThis agent should only be used for its defined actions. \nTasks that require other types of actions are out of scope and should not be handled by this agent.\n\nExamples of popular files this agent can create include, but are not limited to:\n1. Text file (.txt)\n2. Jupyter Notebook (.ipynb)\n3. Python Script (.py)\n4. R Script (.R)\n5. Quarto Document (.qmd)\n6. Any file with an explicitly specified extension";
    }

    @Override
    @NotNull
    protected String getSystemPromptBase() {
        return StringsKt.trimIndent((String)("\n      You are an agent who applies file, directory, workspace operations.\n      \n      You will receive a user request and, using the tools, must perform actions that best fulfill the user's request.\n\n      Yes MUST operate with tools, not offer text solutions in the result.\n      You MUST perform the user's task with maximum accuracy, without generating unnecessary functions or recommendations.\n      \n      List of attached top-level directories in the workspace, \n      where each entry follows the format \"simple name: absolute path\" (e.g., notebooks : /home/user/project/notebooks):\n      " + CollectionsKt.joinToString$default((Iterable)this.getModel().getAttachedDirectories(), (CharSequence)"\n", null, null, (int)0, null, WorkspaceAgentModule::_get_systemPromptBase_$lambda$0, (int)30, null) + "}\n      \n      The user may refer to existing top-level directories using either absolute paths or simple names.\n      \n      Examples of popular files this agent can create include, but are not limited to:\n      1. Text file (.txt)\n      2. Jupyter Notebook (.ipynb)\n      3. Python Script (.py)\n      4. R Script (.R)\n      5. Quarto Document (.qmd)\n      6. Any file with an explicitly specified extension\n     \n      If you have not applied any actions, include an explanation in your response to the user, stating why you cannot generate a non-empty sequence of actions for their request.         \n    "));
    }

    @Override
    @NotNull
    protected List<DataSpellNextTool<WorkspaceAgentContext, ?>> createTools() {
        DataSpellNextTool[] dataSpellNextToolArray = new DataSpellNextTool[]{new CreateFileTool((WorkspaceAgentContext)this.getContext()), new AttachDirectoryTool((WorkspaceAgentContext)this.getContext()), new SelectAndAttachDirectoryTool((WorkspaceAgentContext)this.getContext())};
        return CollectionsKt.listOf((Object[])dataSpellNextToolArray);
    }

    private static final CharSequence _get_systemPromptBase_$lambda$0(DirectoryModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "- " + it.getName() + " : " + it.getAbsolutePath();
    }
}

