/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.go.embeddings;

import com.goide.GoTypes;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.ml.llm.embeddings.indexer.EmbeddingClassNamesProvider;
import com.intellij.ml.llm.embeddings.indexer.entities.TypedIndexableClassName;
import com.intellij.ml.llm.go.embeddings.GoIndexableClassName;
import com.intellij.ml.llm.go.embeddings.LighterASTUtilsKt;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.PsiDependentFileContent;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/go/embeddings/GoTypeNamesProvider;", "Lcom/intellij/ml/llm/embeddings/indexer/EmbeddingClassNamesProvider;", "<init>", "()V", "parseFile", "", "Lcom/intellij/ml/llm/embeddings/indexer/entities/TypedIndexableClassName;", "fileContent", "Lcom/intellij/util/indexing/FileContent;", "entityExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "getEntityExternalizer", "()Lcom/intellij/util/io/DataExternalizer;", "intellij.ml.llm.go.embeddings"})
@SourceDebugExtension(value={"SMAP\nGoTypeNamesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoTypeNamesProvider.kt\ncom/intellij/ml/llm/go/embeddings/GoTypeNamesProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public final class GoTypeNamesProvider
extends EmbeddingClassNamesProvider {
    @NotNull
    private final DataExternalizer<TypedIndexableClassName> entityExternalizer = (DataExternalizer)new DataExternalizer<TypedIndexableClassName>(){

        public void save(DataOutput dst, TypedIndexableClassName value2) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            GoIndexableClassName cfr_ignored_0 = (GoIndexableClassName)value2;
            dst.writeUTF(value2.getName());
            String string = ((GoIndexableClassName)value2).getPackageName();
            if (string == null) {
                string = "";
            }
            dst.writeUTF(string);
        }

        public TypedIndexableClassName read(DataInput src) {
            String packageName2;
            String string;
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            String name = src.readUTF();
            String it = string = (packageName2 = src.readUTF());
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string2 = !(((CharSequence)it).length() == 0) ? string : null;
            Intrinsics.checkNotNull((Object)name);
            String string3 = name;
            String string4 = string2;
            return new GoIndexableClassName(string4, string3);
        }
    };

    @NotNull
    public List<TypedIndexableClassName> parseFile(@NotNull FileContent fileContent) {
        String string;
        LighterASTNode packageNode;
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        LighterAST lighterAST = ((PsiDependentFileContent)fileContent).getLighterAST();
        Intrinsics.checkNotNullExpressionValue((Object)lighterAST, (String)"getLighterAST(...)");
        LighterAST ast = lighterAST;
        List list = ast.getChildren(ast.getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Sequence topLevelNodes = CollectionsKt.asSequence((Iterable)list);
        IElementType[] iElementTypeArray = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue((Object)GoTypes.PACKAGE_CLAUSE, (String)"PACKAGE_CLAUSE");
        LighterASTNode lighterASTNode = packageNode = (LighterASTNode)SequencesKt.singleOrNull(LighterASTUtilsKt.descendByTokenType(ast, (Sequence<? extends LighterASTNode>)topLevelNodes, iElementTypeArray));
        if (lighterASTNode != null) {
            LighterASTNode it = lighterASTNode;
            boolean bl = false;
            string = LighterASTUtilsKt.extractName(ast, it);
        } else {
            string = null;
        }
        String packageName2 = string;
        IElementType[] iElementTypeArray2 = new IElementType[3];
        Intrinsics.checkNotNullExpressionValue((Object)GoTypes.TYPE_DECLARATION, (String)"TYPE_DECLARATION");
        Intrinsics.checkNotNullExpressionValue((Object)GoTypes.TYPE_SPEC, (String)"TYPE_SPEC");
        Intrinsics.checkNotNullExpressionValue((Object)GoTypes.SPEC_TYPE, (String)"SPEC_TYPE");
        Sequence<LighterASTNode> specTypes = LighterASTUtilsKt.descendByTokenType(ast, (Sequence<? extends LighterASTNode>)topLevelNodes, iElementTypeArray2);
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull(specTypes, arg_0 -> GoTypeNamesProvider.parseFile$lambda$1(ast, arg_0)), arg_0 -> GoTypeNamesProvider.parseFile$lambda$2(packageName2, arg_0)));
    }

    @NotNull
    public DataExternalizer<TypedIndexableClassName> getEntityExternalizer() {
        return this.entityExternalizer;
    }

    private static final String parseFile$lambda$1(LighterAST $ast, LighterASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LighterASTUtilsKt.extractName($ast, it);
    }

    private static final GoIndexableClassName parseFile$lambda$2(String $packageName, String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return new GoIndexableClassName($packageName, typeName);
    }
}

