/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.java.smartChat.fileSummarization;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.smartChat.psiSummarization.LanguageSummaryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/java/smartChat/fileSummarization/JavaSummaryProvider;", "Lcom/intellij/ml/llm/smartChat/psiSummarization/LanguageSummaryProvider;", "<init>", "()V", "methodPlaceholderMessage", "", "importPlaceholderMessage", "value", "", "maxImportsCount", "getMaxImportsCount$intellij_ml_llm_java", "()I", "setMaxImportsCount$intellij_ml_llm_java", "(I)V", "makePlaceholder", "Lcom/intellij/psi/PsiComment;", "placeholderMessage", "project", "Lcom/intellij/openapi/project/Project;", "generateSummary", "Lcom/intellij/ml/llm/privacy/PSString;", "psiElement", "Lcom/intellij/psi/PsiElement;", "removeMethodImplementations", "", "javaClass", "Lcom/intellij/psi/PsiClass;", "intellij.ml.llm.java"})
public final class JavaSummaryProvider
implements LanguageSummaryProvider {
    @NotNull
    private final String methodPlaceholderMessage;
    @NotNull
    private final String importPlaceholderMessage;
    private int maxImportsCount = 5;

    public JavaSummaryProvider() {
        this.methodPlaceholderMessage = "/* implementation omitted for shortness */";
        this.importPlaceholderMessage = "/* imports omitted for shortness */";
    }

    public final int getMaxImportsCount$intellij_ml_llm_java() {
        return this.maxImportsCount;
    }

    @TestOnly
    public final void setMaxImportsCount$intellij_ml_llm_java(int n) {
        this.maxImportsCount = n;
    }

    private final PsiComment makePlaceholder(String placeholderMessage, Project project2) {
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getElementFactory(...)");
        PsiElementFactory psiFactory = psiElementFactory;
        PsiComment psiComment = psiFactory.createCommentFromText(placeholderMessage, null);
        Intrinsics.checkNotNullExpressionValue((Object)psiComment, (String)"createCommentFromText(...)");
        return psiComment;
    }

    @Nullable
    public PSString generateSummary(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!Intrinsics.areEqual((Object)psiElement.getLanguage(), (Object)JavaLanguage.INSTANCE)) {
            return null;
        }
        PsiElement psiElement2 = psiElement;
        if (psiElement2 instanceof PsiJavaFile) {
            Project project2 = ((PsiJavaFile)psiElement).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            Project project3 = project2;
            PsiElement psiElement3 = psiElement.copy();
            Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type com.intellij.psi.PsiJavaFile");
            PsiJavaFile root = (PsiJavaFile)psiElement3;
            PsiImportList psiImportList = root.getImportList();
            if (psiImportList != null) {
                PsiImportList it = psiImportList;
                boolean bl = false;
                if (it.getAllImportStatements().length > this.maxImportsCount) {
                    it.deleteChildRange(it.getFirstChild(), it.getLastChild());
                    it.add((PsiElement)this.makePlaceholder(this.importPlaceholderMessage, project3));
                }
            }
            for (PsiClass javaClass : root.getClasses()) {
                Intrinsics.checkNotNull((Object)javaClass);
                this.removeMethodImplementations(project3, javaClass);
            }
            return ExtensionsKtKt.getPrivacySafe((PsiNamedElement)root).getText();
        }
        if (psiElement2 instanceof PsiClass) {
            Project project4 = ((PsiClass)psiElement).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
            Project project5 = project4;
            PsiElement psiElement4 = psiElement.copy();
            Intrinsics.checkNotNull((Object)psiElement4, (String)"null cannot be cast to non-null type com.intellij.psi.PsiClass");
            PsiClass root = (PsiClass)psiElement4;
            this.removeMethodImplementations(project5, root);
            return ExtensionsKtKt.getPrivacySafe((PsiNamedElement)root).getText();
        }
        return null;
    }

    private final void removeMethodImplementations(Project project2, PsiClass javaClass) {
        for (PsiMethod psiMethod : javaClass.getMethods()) {
            PsiCodeBlock it;
            if (psiMethod.getBody() == null) continue;
            boolean bl = false;
            if (this.methodPlaceholderMessage.length() >= it.getTextLength()) continue;
            it.deleteChildRange(it.getFirstBodyElement(), it.getLastBodyElement());
            it.addAfter((PsiElement)this.makePlaceholder(this.methodPlaceholderMessage, project2), (PsiElement)it.getLBrace());
        }
        for (PsiMethod psiMethod : javaClass.getInnerClasses()) {
            Intrinsics.checkNotNull((Object)psiMethod);
            this.removeMethodImplementations(project2, (PsiClass)psiMethod);
        }
    }
}

