/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.javaee.spring.mvc;

import com.intellij.ml.llm.domains.DomainContext;
import com.intellij.ml.llm.domains.DomainSearchScope;
import com.intellij.ml.llm.domains.context.DomainItemContext;
import com.intellij.ml.llm.domains.ide.presentation.DomainItemPresentation;
import com.intellij.ml.llm.domains.ide.presentation.PresentableProvider;
import com.intellij.ml.llm.domains.mapper.DomainProviderContextMapper;
import com.intellij.ml.llm.javaee.spring.mvc.SpringMvcViewsProviderKt;
import com.intellij.ml.llm.javaee.spring.mvc.ViewPresentation;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.stereotype.SpringController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0011H\u0016R\u000e\u0010\u0017\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/javaee/spring/mvc/SpringMvcViewsProvider;", "Lcom/intellij/ml/llm/domains/mapper/DomainProviderContextMapper;", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/ml/llm/domains/ide/presentation/PresentableProvider;", "<init>", "()V", "getItemPresentation", "Lcom/intellij/ml/llm/domains/ide/presentation/DomainItemPresentation;", "item", "getId", "", "getIcon", "Ljavax/swing/Icon;", "unused", "", "isAvailable", "searchScope", "Lcom/intellij/ml/llm/domains/DomainSearchScope;", "getItems", "", "findItem", "domainContext", "Lcom/intellij/ml/llm/domains/DomainContext;", "TYPE_ID", "asContext", "Lcom/intellij/ml/llm/domains/context/DomainItemContext;", "t", "scope", "Companion", "intellij.ml.llm.javaee.spring.mvc"})
@SourceDebugExtension(value={"SMAP\nSpringMvcViewsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringMvcViewsProvider.kt\ncom/intellij/ml/llm/javaee/spring/mvc/SpringMvcViewsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1374#2:100\n1460#2,2:101\n1563#2:103\n1634#2,3:104\n1374#2:107\n1460#2,5:108\n1374#2:113\n1460#2,5:114\n1462#2,3:119\n*S KotlinDebug\n*F\n+ 1 SpringMvcViewsProvider.kt\ncom/intellij/ml/llm/javaee/spring/mvc/SpringMvcViewsProvider\n*L\n44#1:100\n44#1:101,2\n47#1:103\n47#1:104,3\n48#1:107\n48#1:108,5\n49#1:113\n49#1:114,5\n44#1:119,3\n*E\n"})
public final class SpringMvcViewsProvider
implements DomainProviderContextMapper<PsiFile>,
PresentableProvider<PsiFile> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String TYPE_ID;
    @NotNull
    public static final String ID = "Spring MVC Views";

    public SpringMvcViewsProvider() {
        this.TYPE_ID = "spring-mvc-view";
    }

    @Override
    @NotNull
    public DomainItemPresentation getItemPresentation(@NotNull PsiFile item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return new ViewPresentation(item);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public Icon getIcon(boolean unused) {
        Icon icon2 = SpringApiIcons.SpringBean;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SpringBean");
        return icon2;
    }

    @Override
    public boolean isAvailable(@NotNull DomainSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        return SpringLibraryUtil.hasSpringLibrary((Collection)searchScope.getModules());
    }

    @Override
    @NotNull
    public Set<PsiFile> getItems(@NotNull DomainSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        List<Module> list = searchScope.getModules();
        if (list == null) {
            return SetsKt.emptySet();
        }
        List<Module> modules = list;
        SearchScope scope = searchScope.getScope();
        if (scope instanceof GlobalSearchScope) {
            Object object = ReadAction.compute(() -> SpringMvcViewsProvider.getItems$lambda$4(modules, scope));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
            return (Set)object;
        }
        return SetsKt.emptySet();
    }

    @Override
    @Nullable
    public PsiFile findItem(@NotNull DomainContext domainContext) {
        Intrinsics.checkNotNullParameter((Object)domainContext, (String)"domainContext");
        return null;
    }

    @Override
    @NotNull
    public DomainItemContext asContext(@NotNull PsiFile t, @NotNull DomainSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        String string = t.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)t));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        DomainItemContext selectionContext = DomainItemContext.Companion.create(this.TYPE_ID, string, smartPsiElementPointer).with("name", t.getName()).with("path", t.getVirtualFile().getPath()).with("type", t.getFileType().getName());
        return selectionContext;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set getItems$lambda$4(List $modules, SearchScope $scope) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $modules;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable list$iv$iv;
            Object it;
            Iterable $this$flatMapTo$iv$iv2;
            Iterable $this$flatMap$iv2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Module module = (Module)element$iv$iv;
            boolean bl = false;
            List list = SpringJamModel.getModel((Module)module).getControllers((GlobalSearchScope)$scope);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getControllers(...)");
            Iterable iterable2 = list;
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void controller2;
                SpringController springController = (SpringController)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                BeanService beanService = BeanService.getInstance();
                void v2 = controller2;
                Intrinsics.checkNotNull((Object)v2);
                collection.add(beanService.createSpringBeanPointer((CommonSpringBean)v2));
            }
            $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$flatMap2 = false;
            $this$mapTo$iv$iv = $this$flatMap$iv2;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                it = (SpringBeanPointer)element$iv$iv2;
                boolean bl3 = false;
                list$iv$iv = SpringMvcViewsProviderKt.getMappings(it.getBeanClass());
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv2 = (List)destination$iv$iv2;
            $i$f$flatMap2 = false;
            $this$flatMapTo$iv$iv2 = $this$flatMap$iv2;
            destination$iv$iv2 = new ArrayList();
            $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                it = (String)element$iv$iv2;
                boolean bl4 = false;
                list$iv$iv = SpringMvcViewsProviderKt.resolveMappings(module, (String)it);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv2 = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/javaee/spring/mvc/SpringMvcViewsProvider$Companion;", "", "<init>", "()V", "ID", "", "intellij.ml.llm.javaee.spring.mvc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

