/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.kotlin.context;

import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.ml.llm.core.chat.context.ChatContextItem;
import com.intellij.ml.llm.core.chat.context.ChatContextProvider;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.grazie.tasks.jupyter.kotlin.KotlinNotebookGenerationPrompts;
import com.intellij.ml.llm.jupyter.kotlin.context.NotebookContextBaseRules;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/jupyter/kotlin/context/KotlinNotebookChatBaseRulesContextProvider;", "Lcom/intellij/ml/llm/core/chat/context/ChatContextProvider;", "<init>", "()V", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "collect", "", "Lcom/intellij/ml/llm/core/chat/context/ChatContextItem;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/core/chat/session/ChatSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.jupyter.kotlin"})
public final class KotlinNotebookChatBaseRulesContextProvider
implements ChatContextProvider {
    public boolean isApplicable(@NotNull Project project2, @NotNull ChatSession chatSession) {
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        PsiFile psiFile = chatSession.getCreationContext().getSourceFile();
        Object object = virtualFile2 = psiFile != null ? psiFile.getVirtualFile() : null;
        if (virtualFile2 != null && PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, virtualFile2)) {
            return false;
        }
        VirtualFile virtualFile3 = virtualFile2;
        return virtualFile3 != null ? IsKotlinNotebookKt.isKotlinNotebook((VirtualFile)virtualFile3) : false;
    }

    @Nullable
    public Object collect(@NotNull Project project2, @NotNull ChatSession chatSession, @NotNull Continuation<? super List<ChatContextItem>> $completion) {
        String string = Reflection.getOrCreateKotlinClass(KotlinNotebookChatBaseRulesContextProvider.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        String qualifiedName = string;
        Object[] objectArray = new ChatContextItem[3];
        objectArray[0] = new ChatContextItem(qualifiedName, NotebookContextBaseRules.INSTANCE.getBASIC_INTRO().plus(KotlinNotebookGenerationPrompts.INSTANCE.getREDECLARATION_RULE()), null, 4, null);
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{NotebookContextBaseRules.INSTANCE.getKDS_LIBRARIES()};
        objectArray[1] = new ChatContextItem(qualifiedName, ConstantsKt.getPrivacyConst((String)"For Kotlin Notebook prefer a list of supported libraries: %s").format(pSStringConvertibleArray), null, 4, null);
        objectArray[2] = new ChatContextItem(qualifiedName, ConstantsKt.getPrivacyConst((String)"If asked about dependencies in current Notebook session, consider context of current top level file"), null, 4, null);
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

